/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: segment_cb.c
 */

#include <frontend.h>
#include <gtk/gtk.h>

#include "support.h"
#include "unassign.h"
#include "plugin_cb.h"
#include "segment_cb.h"

/*
 *
 *   void on_segment_manager_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      of segments managers to choose from.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - contains task action code for action to use list
 *
 *   Exit:
 *      Selection list populated with available segment manager plugins
 *
 */
void on_segment_manager_clist_realize(GtkWidget * widget, gpointer user_data)
{
	set_selection_window_clist_column_titles(GTK_CLIST(widget), NULL,
						 _("Segment Manager Plugin"), NULL);
	on_plugin_selection_clist_realize(GTK_CLIST(widget), EVMS_SEGMENT_MANAGER, 0,
					  GPOINTER_TO_UINT(user_data));
}

/*
 *
 *   void on_unassign_segment_manager_clist_realize (GtkWidget *, gpointer)
 *   
 *   Description:
 *      This routine populates the given GtkCList with the list
 *      objects that have a segment manager assigned to them that
 *      can have it removed.
 * 
 *   Entry:
 *      widget    - address of the selections GtkCList widget
 *      user_data - address of user data bound with signal (not used)
 *
 *   Exit:
 *      Selection list populated with storage object that can have a 
 *      segment removed from them.
 *
 */
void on_unassign_segment_manager_clist_realize(GtkWidget * widget, gpointer user_data)
{
	on_unassign_parent_plugin_clist_realize(widget, EVMS_SEGMENT_MANAGER);
}
