/*
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: Swap FSIM
 * File: evms2/engine/plugins/swap/swapfs.h
 */

extern plugin_record_t swap_plugin_record;
extern plugin_record_t *my_plugin_record;
extern engine_functions_t *EngFncs;

#define FS_TYPE_SWAPFS 10

/* mkswap option counts */
#define SWAP_MKFS_OPTIONS_COUNT 1

/* mkswap option array indices */
#define SWAP_MKFS_BADBLOCK_INDEX 0

/* swapon option counts */
#define SWAP_ON_OPTIONS_COUNT	2

/* swapon option array indices */
#define SWAP_ON_PRIORITY_INDEX	0
#define SWAP_ON_PRIORITY_NAME	"priority"
#define SWAP_ON_LEVEL_INDEX	1
#define SWAP_ON_LEVEL_NAME	"level"

#define SWAP_PRIORITY_MIN	0
#define SWAP_PRIORITY_MAX	(SWAP_FLAG_PRIO_MASK >> SWAP_FLAG_PRIO_SHIFT)

/* generic defines */
#define GET 0
#define PUT 1
#define SWAPFS_MAGIC_STRING	"SWAP_SPACE"
#define SWAPFS_MAGIC_STRING2	"SWAPSPACE2"
#define SWAPFS_MIN_SIZE		(PAGE_SIZE / EVMS_VSECTOR_SIZE * 10)
#define SWAP_MAGIC_OFFSET_IN_BYTES	(PAGE_SIZE - 10) /* last 10 bytes of first page */

#define EVMS_Task_swapon	EVMS_Task_Plugin_Function + 1
#define EVMS_Task_swapoff	EVMS_Task_Plugin_Function + 2
