/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

typedef enum {
	TASK_REQUIREMENTS_UNKNOWN = 0,
	TASK_REQUIRES_OBJECTS_ONLY,
	TASK_REQUIRES_OPTIONS_ONLY,
	TASK_REQUIRES_NO_ADDITIONAL_ARGS,
	TASK_REQUIRES_OBJECTS_AND_OPTIONS
} task_requirements_t;

int set_selected_object(task_handle_t task, object_handle_t handle);
gboolean can_plugin_do_action(plugin_handle_t plugin, task_action_t action);
gchar *get_task_action_string(task_action_t action);
gboolean is_task_acceptable_object(plugin_handle_t plugin, object_handle_t object, task_action_t action);
gboolean acceptable_objects_available(task_handle_t task);
inline gboolean object_is_only_available(task_handle_t task, engine_handle_t handle);
int reload_acceptable_objects(struct clist *clist);
struct dialog_window *create_task_confirmation_dialog(struct dialog_list *list, task_handle_t task,
							gchar *title, gchar *verb, gchar *help);
int create_task(engine_handle_t handle, task_action_t action, 
		task_requirements_t *requirements, task_handle_t *task,
		int *objects_min, int *objects_max);
inline task_handle_t get_task_from_dialog_data(struct dialog_window *dialog);
struct dialog_window *create_task_options_dialog(task_handle_t task, gchar *title, gchar *verb, gchar *help,
						GHashTable *hash_table);
struct dialog_window *create_acceptable_objects_selection_dialog(task_handle_t task, char *title, char *verb,
								task_requirements_t requirements, char *help,
								GHashTable *hash_table);
void on_delete_task_dialog(struct dialog_window *dialog);
struct dialog_window *create_task_dialog(struct dialog_list *list, engine_handle_t handle,
			task_action_t action, gchar *title, gchar *verb, gchar *help);
int on_init_task_menuitem_activated(struct menu_item *item);
