// InputField.hh for FbDesk
// Copyright (c) 2003 Henrik Kinnunen (fluxgen at users.sourceforge.net)
// 
// Permission is hereby granted, free of charge, to any person obtaining a
// copy of this software and associated documentation files (the "Software"),
// to deal in the Software without restriction, including without limitation
// the rights to use, copy, modify, merge, publish, distribute, sublicense,
// and/or sell copies of the Software, and to permit persons to whom the
// Software is furnished to do so, subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in
// all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
// THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
// LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
// FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.

// $Id$

#ifndef FBDESK_INPUTFIELD_HH
#define FBDESK_INPUTFIELD_HH

#include "EventHandler.hh"
#include "Command.hh"
#include "Font.hh"
#include "Color.hh"
#include "FbWindow.hh"

#include <string>

namespace FbDesk {
// simple input field
class InputField:public FbTk::EventHandler {
public:
    InputField(int screen_num, const FbTk::Font &font, GC gc, const FbTk::Color &bgcolor);
    virtual ~InputField();
    /**
       @name event handlers
     */
    ///@{
    void exposeEvent(XExposeEvent &event);
    void keyReleaseEvent(XKeyEvent &event);
    ///@}

    void move(int x, int y);
    void resize(unsigned int width, unsigned int height);
    void show();
    void hide();
    void raise();
    void lower();

    void setFont(const FbTk::Font &font);
    // update graphics and size
    void reconfigure();

    void setOnEnter(FbTk::Command *on_enter) { m_on_enter.reset(on_enter); }
    void setTitle(const std::string &label);
    void setText(const std::string &text);

    const std::string &text() const { return m_text; }
    const FbTk::FbWindow &window() const { return m_window; }
    FbTk::FbWindow &window() { return m_window; }
private:
    void redrawText();

    std::auto_ptr<FbTk::Command> m_on_enter; ///< what to do when we're done with input
    FbTk::FbWindow m_window;
    const FbTk::Font *m_font;
    const FbTk::Color &m_bgcolor;
    std::string m_text; ///< displayed text
    GC m_gc;
};

}; // end namespace FbDesk

#endif // FBDESK_INPUTFIELD_HH

