#!/usr/bin/env python
#############################################################################
# Copyright (C) DSTC Pty Ltd (ACN 052 372 577) 1997, 1998, 1999
# All Rights Reserved.
#
# The software contained on this media is the property of the DSTC Pty
# Ltd.  Use of this software is strictly in accordance with the
# license agreement in the accompanying LICENSE.HTML file.  If your
# distribution of this software does not contain a LICENSE.HTML file
# then you have no rights to use this software in any manner and
# should contact DSTC at the address below to determine an appropriate
# licensing arrangement.
# 
#      DSTC Pty Ltd
#      Level 7, GP South
#      Staff House Road
#      University of Queensland
#      St Lucia, 4072
#      Australia
#      Tel: +61 7 3365 4310
#      Fax: +61 7 3365 4311
#      Email: enquiries@dstc.edu.au
# 
# This software is being provided "AS IS" without warranty of any
# kind.  In no event shall DSTC Pty Ltd be liable for damage of any
# kind arising out of or in connection with the use or performance of
# this software.
#
# Project:      Fnorb
# File:         $Source: /cvsroot/fnorb/fnorb/script/fnior.py,v $
# Version:      @(#)$RCSfile: fnior.py,v $ $Revision: 1.1 $
#
#############################################################################
""" Read a stringified IOR from stdin and print its details on stdout. """


# Standard/built-in modules.
import new, sys

# Fnorb modules.
from Fnorb.orb import IOP


def main(argv):
    """ Do it! """

    # fixme: This a hack to remove the spurious last argument ('\n') on
    # Windows 95.
    if argv[-1] == '\n':
	del argv[-1]

    if len(argv) == 1:
	# Read a stringified IOR from stdin.
	stringified_ior = sys.stdin.read()

    elif len(argv) == 2 and argv[1][:4] == 'IOR:':
	# Read a stringified IOR from the command line.
	stringified_ior = argv[1]

    elif len(argv) == 3 and argv[1] == '-f':
	# Read a stringified IOR from a file.
	stringified_ior = open(argv[2]).read()

    else:
	print 'Usage: fnior [-f file | IOR:...]'
	return 1

    # Create a new IOR instance and initialise it from the stringified IOR.
    ior = new.instance(IOP.IOR, {})
    ior._fnorb_from_string(stringified_ior)

    # Print out the details.
    print
    print 'Type Id              :', ior.type_id
    for p in ior.profiles:
	# IIOP profile
	if p.tag == IOP.TAG_INTERNET_IOP:
	    print 'Profile              : IIOP'
	    major = p.profile_data.iiop_version.major
	    minor = p.profile_data.iiop_version.minor
	    print 'IIOP Version         : %d.%d' % (major, minor)
	    print 'Host                 :', p.profile_data.host
	    print 'Port                 :', p.profile_data.port
	    print 'Object Key           :', p.profile_data.object_key
	    print 'Key length           :', len(p.profile_data.object_key)
	    print 'Octal key dump       :',
	    # Dump of object key.
	    i = 0
	    for c in p.profile_data.object_key:
		print '%03o' % ord(c),
		i = i + 1
		if i % 10 == 0:
		    print '\n' + ' ' * 22,

	    print '\n'

	# Multiple component profile.    
	elif p.tag == IOP.TAG_MULTIPLE_COMPONENTS:
	    print 'Profile              : Multiple Components'
	    for co in p.profile_data:
		print 'Component id         :', co.tag
		print 'Component            :', co.component_data
		print 'Component length     :', len(co.component_data)
		print 'Octal component dump :',
		# Dump of component data.
		i = 0
		for c in co.component_data:
		    print '%03o' % ord(c),
		    i = i + 1
		    if i % 10 == 0:
			print '\n' + ' ' * 22,

		print '\n'

	else:
	    print 'Unknown profile tag  :', p.tag
	    print '\n'
	    
    return 0

#############################################################################

if __name__ == '__main__':
    # Do it!
    sys.exit(main(sys.argv))

#############################################################################
