/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2002-2004 The GFC Development Team.
 *
 *  socketsignals.cc - Gtk::Socket virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */
 
#include "socket.hh"
#include "socketsignals.hh"
#include "private/socketclass.hh"

using namespace GFC;

/*  Gtk::SocketSignals
 */

Gtk::SocketSignals::SocketSignals(Socket *socket)
: ContainerSignals(socket)
{
	Gtk::SocketClass::init(GTK_SOCKET_GET_CLASS(socket->gtk_socket()));
}

Gtk::SocketSignals::~SocketSignals()
{
}

void
Gtk::SocketSignals::on_plug_added()
{
	GtkSocketClass *g_class = SocketClass::get_parent_class(instance_);
	if (g_class->plug_added)
		g_class->plug_added((GtkSocket*)instance_);
}

bool
Gtk::SocketSignals::on_plug_removed()
{
	GtkSocketClass *g_class = SocketClass::get_parent_class(instance_);
	bool result = false;
	if (g_class->plug_removed)
		result = g_class->plug_removed((GtkSocket*)instance_);
	return result;
}

/*  Gtk::SocketClass
 */

void
Gtk::SocketClass::init(GtkSocketClass *g_class)
{
	g_class->plug_added = &plug_added_proxy;
	g_class->plug_removed = &plug_removed_proxy;
}

GtkSocketClass*
Gtk::SocketClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_SOCKET_GET_CLASS(instance));
	return static_cast<GtkSocketClass*>(ptr);
}

GType
Gtk::SocketClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_SOCKET);
	}
	return type;
}

void*
Gtk::SocketClass::create()
{
	return g_object_new(get_type(), 0);
}

void
Gtk::SocketClass::plug_added_proxy(GtkSocket *socket)
{
	void *ptr = g_object_get_qdata((GObject*)socket, G::ObjectSignals::quark());
	if (ptr)
		static_cast<SocketSignals*>(ptr)->on_plug_added();
	else
	{
		GtkSocketClass *g_class = SocketClass::get_parent_class(socket);
		if (g_class->plug_added)
			g_class->plug_added(socket);
	}
}

gboolean
Gtk::SocketClass::plug_removed_proxy(GtkSocket *socket)
{
	gboolean result = FALSE;
	void *ptr = g_object_get_qdata((GObject*)socket, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<SocketSignals*>(ptr)->on_plug_removed();
	else
	{
		GtkSocketClass *g_class = SocketClass::get_parent_class(socket);
		if (g_class->plug_removed)
			result = g_class->plug_removed(socket);
	}
	return result;
}

