/*  GFC-UI: GTK+ Foundation Classes (User Interface Library)
 *  Copyright (C) 2004 The GFC Development Team.
 *
 *  toolitemsignals.cc - Gtk::ToolItem virtual signal handlers
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "toolitem.hh"
#include "toolitemsignals.hh"
#include "private/toolitemclass.hh"
#include "tooltips.hh"

using namespace GFC;

/*  Gtk::ToolItemSignals
 */

Gtk::ToolItemSignals::ToolItemSignals(ToolItem *tool_item)
: ContainerSignals(tool_item)
{
	Gtk::ToolItemClass::init(GTK_TOOL_ITEM_GET_CLASS(tool_item->gtk_tool_item()));
}

Gtk::ToolItemSignals::~ToolItemSignals()
{
}

bool 
Gtk::ToolItemSignals::on_create_menu_proxy()
{
	bool result = false;	
	GtkToolItemClass *g_class = ToolItemClass::get_parent_class(instance_);
	if (g_class->create_menu_proxy)
		result = g_class->create_menu_proxy((GtkToolItem*)instance_);
	return result;
}

void 
Gtk::ToolItemSignals::on_toolbar_reconfigured()
{
	GtkToolItemClass *g_class = ToolItemClass::get_parent_class(instance_);
	if (g_class->toolbar_reconfigured)
		g_class->toolbar_reconfigured((GtkToolItem*)instance_);
}

bool 
Gtk::ToolItemSignals::on_set_tooltip(Tooltips& tooltips, const String& tip_text, const String& tip_private)
{
	bool result = false;	
	GtkToolItemClass *g_class = ToolItemClass::get_parent_class(instance_);
	if (g_class->set_tooltip)
		result = g_class->set_tooltip((GtkToolItem*)instance_, tooltips.gtk_tooltips(), 
		                             tip_text.c_str(), tip_private.c_str());
	return result;
}

/*  Gtk::ToolItemClass
 */

void
Gtk::ToolItemClass::init(GtkToolItemClass *g_class)
{
	g_class->create_menu_proxy = &create_menu_proxy_proxy;
	g_class->toolbar_reconfigured = &toolbar_reconfigured_proxy;
	g_class->set_tooltip = &set_tooltip_proxy;
}

GtkToolItemClass*
Gtk::ToolItemClass::get_parent_class(void *instance)
{
	void *ptr = g_type_class_peek_parent(GTK_TOOL_ITEM_GET_CLASS(instance));
	return static_cast<GtkToolItemClass*>(ptr);
}

GType
Gtk::ToolItemClass::get_type()
{
	static GType type = 0;
	if (!type)
	{
		type = G::TypeInstance::register_type(GTK_TYPE_TOOL_ITEM);
	}
	return type;
}

void*
Gtk::ToolItemClass::create()
{
	return g_object_new(get_type(), 0);
}

gboolean 
Gtk::ToolItemClass::create_menu_proxy_proxy(GtkToolItem *tool_item)
{
	gboolean result = FALSE;	
	void *ptr = g_object_get_qdata((GObject*)tool_item, G::ObjectSignals::quark());
	if (ptr)
		result = static_cast<ToolItemSignals*>(ptr)->on_create_menu_proxy();
	else
	{
		GtkToolItemClass *g_class = ToolItemClass::get_parent_class(tool_item);
		if (g_class->create_menu_proxy)
			result = g_class->create_menu_proxy(tool_item);
	}
	return result;
}
	
void 
Gtk::ToolItemClass::toolbar_reconfigured_proxy(GtkToolItem *tool_item)
{
	void *ptr = g_object_get_qdata((GObject*)tool_item, G::ObjectSignals::quark());
	if (ptr)
		static_cast<ToolItemSignals*>(ptr)->on_toolbar_reconfigured();
	else
	{
		GtkToolItemClass *g_class = ToolItemClass::get_parent_class(tool_item);
		if (g_class->toolbar_reconfigured)
			g_class->toolbar_reconfigured(tool_item);
	}
}
	
	
gboolean 
Gtk::ToolItemClass::set_tooltip_proxy(GtkToolItem *tool_item, GtkTooltips *tooltips, const gchar *tip_text, const gchar *tip_private)
{
	gboolean result = FALSE;	
	void *ptr = g_object_get_qdata((GObject*)tool_item, G::ObjectSignals::quark());
	if (ptr)
	{
		String s1(tip_text);
		String s2(tip_private);
		result = static_cast<ToolItemSignals*>(ptr)->on_set_tooltip(*G::Object::wrap<Tooltips>(tooltips), s1, s2);
	}
	else
	{
		GtkToolItemClass *g_class = ToolItemClass::get_parent_class(tool_item);
		if (g_class->set_tooltip)
			result = g_class->set_tooltip(tool_item, tooltips, tip_text, tip_private);
	}
	return result;
}
	
