/* giFTui
 * Copyright (C) 2003 the giFTui team
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */

#include "main.h"

#include <stdio.h>
#include <stdlib.h>
#include <libgift/libgift.h>
#include <gtk/gtk.h>

#include "util.h"
#include "configure.h"
#include "io.h"
#include "event.h"

#include "ui.h"
#include "ui_connect.h"
#include "ui_menu.h"

static GtkWidget *window;

static gboolean
giftui_main_window_deleted (GtkWindow *window)
{
	gint width, height;
	
	gtk_window_get_size (window, &width, &height);
	giftui_config_set_int (PREFS_MAIN_WINDOW_WIDTH, width);
	giftui_config_set_int (PREFS_MAIN_WINDOW_HEIGHT, height);
	
	return FALSE;
}

static gboolean
giftui_main_window_destroyed (GtkWindow *window, GiftuiParent *pa)
{
	giftui_parent_save_children_positions (pa);
	
	gtk_main_quit ();
	
	return FALSE;
}

static gboolean
giftui_main_window_load_tabs (GiftuiParent *parent)
{
	const gchar *tabs;
	gchar *s, *str, *tmp;
	GtkWidget *w = NULL;
	
	tabs = "4.2.0.3";
	/*if (!(tabs = giftui_config_get_str (PREFS_MAIN_TABS)))
	{
		GIFTUI_PRINT_ERR ((_("Can't load tabs, check your ~/.giFT/ui/giftui.conf or remove it to fall back into default configuration.\n")));
		
		return FALSE;
		}*/
	
	str = g_strdup (tabs);
	s = str;
	
	while (s && *s != '\0')
	{
		tmp = strchr (s, '.');
		if (tmp)
			*tmp = '\0';
		
		w = NULL;
		switch (atoi (s))
		{
		case GIFTUI_CHILD_SEARCH:
			w = giftui_search_new ();
			break;
			
		case GIFTUI_CHILD_BROWSE:
			w = giftui_browse_new (NULL);
			break;
			
		case GIFTUI_CHILD_TRANSFER:
			w = giftui_transfer_new ();
			break;
			
		case GIFTUI_CHILD_ABOUT:
			w = giftui_about_new ();
			break;
			
		case GIFTUI_CHILD_PREF:
			w = giftui_pref_new ();
			break;
			
		default:
			break;
		}
		
		if (w)
			giftui_parent_insert_child (parent, NULL, w);
		
		if (tmp)
			s = tmp + 1;
		else
			s = tmp;
	}
	
	if (w)
		giftui_parent_raise_child (parent, w);
	
	g_free (str);
	
	return TRUE;
}

static GtkWidget *
giftui_main_window_create (void)
{
	GtkWidget *menubar, *vbox;
	GtkWidget *parent;
	
	window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
	gtk_widget_realize (window);
	gtk_window_set_default_size (GTK_WINDOW (window),
				     giftui_config_get_int (PREFS_MAIN_WINDOW_WIDTH),
				     giftui_config_get_int (PREFS_MAIN_WINDOW_HEIGHT));
	gtk_container_set_border_width (GTK_CONTAINER (window), 5);
	gtk_window_set_title (GTK_WINDOW (window), PACKAGE);
	gtk_window_set_icon_from_file (GTK_WINDOW (window), ICONFILE, NULL);
	
	vbox = gtk_vbox_new (FALSE, 0);
	gtk_container_add (GTK_CONTAINER (window), vbox);
	gtk_widget_show (vbox);
	
	parent = giftui_notebook_new ();
	
	/**/
	menubar = giftui_menu_create (window, GIFTUI_PARENT (parent));
	gtk_box_pack_start (GTK_BOX (vbox), menubar, FALSE, TRUE, 0);
	
	/**/
	gtk_box_pack_start_defaults (GTK_BOX (vbox), parent);
	
	if (!giftui_main_window_load_tabs (GIFTUI_PARENT (parent)))
		return NULL;
	
	g_signal_connect (window, "destroy",
			  G_CALLBACK (giftui_main_window_destroyed),
			  parent);
	g_signal_connect (window, "delete-event",
			  G_CALLBACK (giftui_main_window_deleted),
			  NULL);
	
	gtk_widget_show (window);
	
	return parent;
}

/*****************************************************************************************/

static void
giftui_end (void)
{
	giftui_config_end ();
	libgift_finish ();
	
	return;
}

static gint
giftui_init (gint argc, gchar *argv[])
{
	/* libgiFT init */
	if (!libgift_init (PACKAGE, GLOG_STDERR, NULL))
	{
		GIFTUI_PRINT_ERR (("bastard ! hmmmm little prob with !#@*^! libgift...\n"));
		
		return EXIT_FAILURE;
	}
	
	/* set locale for i18n */
#ifdef ENABLE_NLS
	gtk_set_locale ();
	bind_textdomain_codeset (PACKAGE, "UTF-8");
	bindtextdomain (PACKAGE, LOCALEDIR);
	textdomain (PACKAGE);
#endif	
	
	/* configuration init & load */
	giftui_config_init ();
	
	if (giftui_config_load_from_args (argc, argv))
	{
		giftui_end ();
		
		return EXIT_FAILURE;
	}
	else if (!giftui_config_get_str (PREFS_DAEMON_HOST))
	{
		GIFTUI_PRINT_ERR ((_("No host to connect %s.\n"), PREFS_DAEMON_HOST));
		giftui_end ();
		
		return EXIT_FAILURE;
	}
		
	
	/* GTK+ init */
	gtk_init (&argc, &argv);
	
	return EXIT_SUCCESS;
}

void
giftui_exit (void)
{
	if (window)
	{
		giftui_main_window_deleted (GTK_WINDOW (window));
		gtk_widget_destroy (window);
		window = NULL;
	}
	
	return;
}

gint
main (gint argc, gchar *argv[])
{
	gint ret;
	GtkWidget *window;
	
	if ((ret = giftui_init (argc, argv)))
		return ret;
	
	/* mmm, what could we do here ... */
	if (!(window = giftui_main_window_create ()))
	{
		giftui_end ();
		
		return EXIT_FAILURE;
	}
	
	/* Connect */
	giftui_connect (giftui_config_get_str (PREFS_DAEMON_HOST),
			giftui_config_get_int (PREFS_DAEMON_PORT),
			giftui_config_get_bool (PREFS_DAEMON_LAUNCH));
	
	gtk_widget_show (window);
	
	gtk_main ();
	
	/* Is the client still connected ? */
	if (gift_connected ())
	{
		gint test;
		GtkWidget *dialog;
		
		/* Is there a local daemon ? (giftui won't ever kill a
		 * foreign daemon) */
		if (giftui_config_get_bool (PREFS_DAEMON_LAUNCH))
		{
			/* Do we need to kill the damon ? */
			test = giftui_config_get_int (PREFS_DAEMON_KILL);
			if (test == 2)
			{
				dialog = gtk_message_dialog_new (NULL,
								 GTK_DIALOG_MODAL,
								 GTK_MESSAGE_QUESTION,
								 GTK_BUTTONS_YES_NO,
								 _("Kill daemon ?"));
				if (gtk_dialog_run (GTK_DIALOG (dialog)) == GTK_RESPONSE_YES)
					gift_quit ();
				gtk_widget_destroy (dialog);
			}
			else if (test == 1)
				gift_quit ();
		}
		else
			gift_disconnect ();
	}
	
	giftui_end ();
	
	return EXIT_SUCCESS;
}
