#!/bin/bash
#
#	$Id: do_examples.bash,v 1.1.1.1 2000/12/28 01:23:45 gmt Exp $
#
# Bash script to test all GMT examples (bash versions).
# If one argument is given it is used as the bin path
# If a second arguemnt is used it is added to the library path

# First determine if awk is buggy:

result=`echo 1 | awk '{print sin($1)}'`
if [ $result = 1 ]; then
	answer=`which nawk`
	if [ $#answer = 1 ]; then
		export AWK=nawk
	else
		export AWK=gawk
	fi
else
	export AWK=awk
fi

if [ $# -ge 1 ]; then
	cd ..
	top=`pwd`
	cd examples
	OLDPATH=$PATH
	OLDGMTHOME=${GMTHOME:-$top}
	export PATH=$1:$OLDPATH
	if [ $# = 2 ]; then
		OLDLD=${LD_LIBRARY_PATH:-/usr/lib}
		export LD_LIBRARY_PATH=$2:$OLDLD
	fi
	export GMTHOME=$top
fi

# Loop over all examples and run each job

for dir in 01 02 03 04 05 06 07 08 09 10 11 12 13 14 15 16 17 18 19 20
do
	if [ -e ex${dir}/job${dir}.bash ]; then
		echo -n "Doing example ${dir}..."
		cd ex${dir}
		bash job${dir}.bash
		cd ..
		echo "done"
	fi
done
if [ $# -ge 1 ]; then
	export PATH=$OLDPATH
	export GMTHOME=$OLDGMTHOME
	if [ $# = 2 ]; then
		export LD_LIBRARY_PATH=$OLDLD
	fi
fi
echo "Completed all examples"
