/**
 ** date_list.c - routines to deal with the songs by date list
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "mp3list.h"

/*
 * Callback for the changed signal of the editable in the date spinbutton.
 * The current time is combined with its value, and any songs newer than the
 * result are added to the display.
 */
void date_changed(GtkEditable *editable, gpointer user_data)
{
    char *string;
    GList *ptr;
    time_t then;
    char *col[2];
    int n;
    MP3 *mp3;

    string = gtk_entry_get_text(GTK_ENTRY(editable));
    then = time(NULL) - atoi(string) * 86400;

    gtk_clist_freeze( GTK_CLIST(gnomp3.time_clist));
    gtk_clist_clear( GTK_CLIST(gnomp3.time_clist));

    for( ptr = mp3list; ptr; ptr = ptr->next ){
	mp3 = ptr->data;
	if( mp3->file_time >= then ){
	    col[0] = mp3->display_name;
	    col[1] = mp3list_build_time(mp3);
	    n = gtk_clist_append( GTK_CLIST(gnomp3.time_clist), col);
	    gtk_clist_set_row_data( GTK_CLIST(gnomp3.time_clist), n, mp3);
	    if(mp3->row_playlist >= 0){
		gtk_clist_set_background( GTK_CLIST(gnomp3.time_clist), n,
					  &gnomp3.in_playlist_bg_color);
		gtk_clist_set_foreground( GTK_CLIST(gnomp3.time_clist), n,
					  &gnomp3.in_playlist_fg_color);
	    }
	} 
    }
    gtk_clist_thaw( GTK_CLIST(gnomp3.time_clist));
}
