#include <gnome.h>

#include "song_list.h"
#include "playlist.h"
#include "mp3_control.h"
#include "all_list.h"
#include "mp3list.h"
#include "mp3_properties.h"

static GnomeUIInfo song_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Add"), NULL, playlist_add,
			  GNOME_STOCK_MENU_BACK),
   GNOMEUIINFO_ITEM_STOCK(N_("Add whole album"), NULL, playlist_add_album,
			  GNOME_STOCK_MENU_ALIGN_RIGHT),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Play song"), NULL, mp3_control_play_selected_song,
			  GNOME_STOCK_MENU_FORWARD),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Reload List"), NULL, mp3list_reload,
			  GNOME_STOCK_MENU_REFRESH),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Properties"), NULL, 
			  mp3_properties_load_dialog,
			  GNOME_STOCK_MENU_PROP),
   GNOMEUIINFO_END,
};

GnomeUIInfo playlist_popup_menu[] = {
    GNOMEUIINFO_ITEM_STOCK(N_("Play"), NULL, mp3_control_play_selected, 
			   GNOME_STOCK_MENU_FORWARD),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK(N_("Delete"), NULL, playlist_delete, 
			   GNOME_STOCK_MENU_CLOSE),
    GNOMEUIINFO_ITEM_STOCK(N_("Move Up"), NULL, playlist_move_row_up, 
			   GNOME_STOCK_MENU_UP),
    GNOMEUIINFO_ITEM_STOCK(N_("Move Down"), NULL, playlist_move_row_down, 
			   GNOME_STOCK_MENU_DOWN),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK(N_("Mark as played"), NULL, 
			   playlist_mark_row_played, 
			   GNOME_STOCK_MENU_BOOK_RED),
    GNOMEUIINFO_ITEM_STOCK(N_("Mark as unplayed"), NULL, 
			   playlist_mark_row_unplayed, 
			   GNOME_STOCK_MENU_BOOK_GREEN),
    GNOMEUIINFO_SEPARATOR,
    GNOMEUIINFO_ITEM_STOCK(N_("Properties"), NULL, 
			   mp3_properties_load_dialog,
			   GNOME_STOCK_MENU_PROP),
    GNOMEUIINFO_END,
};

static GnomeUIInfo search_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Add"), NULL, playlist_add,
			  GNOME_STOCK_MENU_BACK),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Play song"), NULL, mp3_control_play_selected_song,
			  GNOME_STOCK_MENU_FORWARD),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Properties"), NULL, 
			  mp3_properties_load_dialog,
			  GNOME_STOCK_MENU_PROP),
   GNOMEUIINFO_END,
};

static GnomeUIInfo all_list_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Add"), NULL, playlist_add,
			  GNOME_STOCK_MENU_BACK),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Play song"), NULL, mp3_control_play_selected_song,
			  GNOME_STOCK_MENU_FORWARD),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Reload List"), NULL, mp3list_reload,
			  GNOME_STOCK_MENU_REFRESH),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Properties"), NULL, 
			  mp3_properties_load_dialog,
			  GNOME_STOCK_MENU_PROP),
   GNOMEUIINFO_END,
};

static GnomeUIInfo time_list_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Add"), NULL, playlist_add,
			  GNOME_STOCK_MENU_BACK),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Play song"), NULL, mp3_control_play_selected_song,
			  GNOME_STOCK_MENU_FORWARD),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Properties"), NULL, 
			  mp3_properties_load_dialog,
			  GNOME_STOCK_MENU_PROP),
   GNOMEUIINFO_END,
};

static GnomeUIInfo dir_list_popup_menu[] = {
   GNOMEUIINFO_ITEM_STOCK(N_("Add"), NULL, playlist_add,
			  GNOME_STOCK_MENU_BACK),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Play song"), NULL, mp3_control_play_selected_song,
			  GNOME_STOCK_MENU_FORWARD),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Reload List"), NULL, mp3list_reload,
			  GNOME_STOCK_MENU_REFRESH),
   GNOMEUIINFO_SEPARATOR,
   GNOMEUIINFO_ITEM_STOCK(N_("Properties"), NULL, 
			  mp3_properties_load_dialog,
			  GNOME_STOCK_MENU_PROP),
   GNOMEUIINFO_END,
};
