/**
 ** song_list.c - a.k.a album tree
 **
 ** Copyright (C) 2000 Matthew Pratt <mattpratt@yahoo.com>
 **
 ** This software is licensed under the terms of the GNU General 
 ** Public License (GPL). Please see the file LICENSE for details.
 **/ 

#include "gnomp3.h"
#include "utility.h"
#include "mp3info.h"
#include "all_list.h"
#include "mp3list.h"


/* seraches the song_ctree for the given text in cell[0] */
GtkCTreeNode *song_list_find_tree(char *text)
{
    GtkCTreeNode *node;
    char *buf;
    
    node = GTK_CTREE_NODE(GTK_CLIST(gnomp3.song_ctree)->row_list);
    while(node) {
	buf = GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text;
	if( buf && !strcmp( buf, text ) )
	    return node;
	node = GTK_CTREE_ROW(node)->sibling;    
    }
    
    return NULL;
}

/*
 * add a song to the tree.
 */
void song_list_add_row(MP3 *mp3)
{
    char *text[2];
    GtkCTreeNode *node;

    node = song_list_find_tree(mp3->album_name);
    if( !node ){
	text[0] = mp3->album_name;
	text[1]  = "";  
	node = gtk_ctree_insert_node(GTK_CTREE(gnomp3.song_ctree), node, NULL, 
				     text, 0, NULL, NULL, NULL, NULL, 0, 0);
    }
    
    text[0] = mp3->display_name;
    text[1] = mp3list_build_time(mp3);
    node = gtk_ctree_insert_node(GTK_CTREE(gnomp3.song_ctree), node, NULL, 
				 text, 0, NULL, NULL, NULL, NULL, 0, 0);
    gtk_ctree_node_set_row_data( GTK_CTREE(gnomp3.song_ctree), node, 
				 mp3); 
    mp3->row_songlist = node;

}

/* searchs and displays the matching tree in the song list */
void song_entry_changed(GtkEditable *editable, gpointer user_data)
{
    GtkCTreeNode *node;
    char *haystack;
    char *text;
    static GtkCTreeNode *last_node;
    
    text = g_strdup(gtk_entry_get_text(GTK_ENTRY(editable)));
    g_strup(text);
    
    node = GTK_CTREE_NODE(GTK_CLIST(gnomp3.song_ctree)->row_list);
    while(node) {
	haystack = g_strdup(GTK_CELL_PIXTEXT(GTK_CTREE_ROW(node)->row.cell[0])->text);
	g_strup(haystack);
	if( strstr( haystack, text ) ){
	    /* collapse the last selection */
	    if( node != last_node ){
		gtk_ctree_collapse( GTK_CTREE(gnomp3.song_ctree), last_node );
		gtk_ctree_unselect( GTK_CTREE(gnomp3.song_ctree), last_node );
		last_node = node;
	    }
	    /* locate, select, and expand the new one */
	    gtk_ctree_select(GTK_CTREE(gnomp3.song_ctree), node );
	    gtk_ctree_node_moveto( GTK_CTREE(gnomp3.song_ctree), node, 0, 0.5, 0.5 );
	    gtk_ctree_expand( GTK_CTREE(gnomp3.song_ctree), node );
	    break;
	}
	g_free(haystack);
	node = GTK_CTREE_ROW(node)->sibling;    
    }

    g_free(text);
}
