/* -*- Mode: C; tab-width: 8; indent-tabs-mode: t; c-basic-offset: 8 -*- */
/*
  satplot.c: Radial plot showing a satellite pass.

  Copyright (C)  2001-2003  Ran Hadary & Alexandru Csete.

  Authors:   Ran Hadary <hadary@users.sourceforge.net>
             Alexandru Csete <csete@users.sourceforge.net>

  Comments, questions and bugreports should be submitted via
  http://sourceforge.net/projects/groundstation/
  More details can be found at http://groundstation.sourceforge.net/
 
  This program is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.
  
  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.
  
  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the
          Free Software Foundation, Inc.,
	  59 Temple Place, Suite 330,
	  Boston, MA  02111-1307
	  USA
*/

#ifndef SATPLOT_H
#define SATPLOT_H


/* GConf paths */
#define SATPLOT_SWAP_PATH       "/apps/gpredict/satplot/swap"       /* path to N/S E/W swapping */
#define SATPLOT_SHOWSAT_PATH    "/apps/gpredict/satplot/showsat"
#define SATPLOT_SHOWTIME_PATH   "/apps/gpredict/satplot/showtime"
#define SATPLOT_SHOWQTH_PATH    "/apps/gpredict/satplot/showqth"
#define SATPLOT_SHOWAOS_PATH    "/apps/gpredict/satplot/showaos"
#define SATPLOT_NOAACANV_PATH   "/apps/gpredict/satplot/noaacanv"

enum field_of_view_e {
	VIEW_CIRCLE = 0,            /* View is 360 deg            */
	VIEW_NORTH,                 /* View North side 180 deg    */
	VIEW_SOUTH,                 /* View South side 180 deg    */
	VIEW_NE,                    /* View North East 90 deg     */
	VIEW_SE,                    /* View South East 90 deg     */
	VIEW_SW,                    /* View South West 90 deg     */
	VIEW_NW                     /* View North West 90 deg     */
};

typedef enum field_of_view_e field_of_view_t;

struct point_struc {
	gdouble x;
	gdouble y;
	gint point_visible;
};

typedef struct point_struc xypoint_t;

/* How N/S and E/W are plotted. Start at 12 and go clockwise */
enum satplot_swap_e {
	SATPLOT_NESW = 0,          /* North->East->South->West (default) */
	SATPLOT_NWSE,              /* East and West swapped */
	SATPLOT_SENW,              /* North and South are swapped */
	SATPLOT_SWNE               /* Both N/S and E/W are swapped */
};



/* main API functions            */
void sat_plot_aos_track (sat_t *, gchar **, guint);

#endif
