<?php
// File           toggle_fold_procedure.php / ibWebAdmin
// Purpose        unfold/fold the procedure view on the procedures panel
// Author         Lutz Brueckner <irie@gmx.de>
// Copyright      (c) 2000, 2001, 2002, 2003 by Lutz Brueckner,
//                published under the terms of the GNU General Public Licence v.2,
//                see file LICENCE for details
// Created        <02/10/17 11:06:40 lb>
//
// $Id: toggle_fold_procedure.php,v 1.5 2003/02/02 19:55:15 lbrueckner Exp $

// $_GET variables:   $n  procedure name


include('inc/configuration.inc.php');
include('inc/session.inc.php');
include('inc/functions.inc.php');

if (DEBUG === TRUE) { 
    include('inc/debug_funcs.inc.php');
}

session_start();
localize_session_vars();

$pname = $HTTP_GET_VARS['n'];

if (isset($s_procedures[$pname])) {

    if ($s_procedures[$pname]['status'] == 'open') {
        $s_procedures[$pname]['status'] = 'close';
    }

    else {
        $s_procedures[$pname]['status'] = 'open';

        include('inc/interbase.inc.php');
        include('inc/procedures.inc.php');

        if (!($dbhandle = db_connect())) {
            ib_error(__FILE__, __LINE__, 'connect');
        }
        list($in, $out) = get_procedure_parameters($pname);
        $s_procedures[$pname]['in']     = $in;
        $s_procedures[$pname]['out']    = $out;
        $s_procedures[$pname]['source'] = get_procedure_source($pname);
    }
}

globalize_session_vars();
redirect(url_session($HTTP_SERVER_VARS['HTTP_REFERER']));

?>
