-- zoom.lua
--
-- exchanges current client window with the active client window of the frame
-- called 'zoomframe' -- resembling the behavior of larswm
--
-- +---------------------------------------------------+-----------------+
-- |                                                   |                 |
-- |                                                   |                 |
-- |                                                   |                 |
-- |                                                   |   Client 1      |
-- |                                                   |                 |
-- |                                                   |                 |
-- |            Z o o m f r a m e  w i t h             +-----------------+
-- |            z o o m e d   C l i e nt               |                 |
-- |                                                   |                 |
-- |                                                   |   Client 2      |
-- |                                                   |                 |
-- |                                                   |                 |
-- |                                                   |                 |
-- +--------------------------------+------------------+-----------------+
-- |                                |                                    |
-- |                                |                                    |
-- |        Client 4                |            Client 3                |
-- |                                |                                    |
-- |                                |                                    |
-- +--------------------------------+------------------------------------+
--
-- Example: zoom_client on "Client 2" will put "Client 2" into the zoom frame
-- and "zoomed Client" into the frame of "Client 2"
--
-- By Rene van Bevern <rvb@pro-linux.de>, 2005
--	Public Domain
--
-- Example keybinding:
--
-- defbindings("WFrame", {
--    kpress(MOD1.."z", "zoom_client(_, _sub")
-- }

local zoomframe_name = 'zoomframe'

function zoom_client(curframe, curclient)
   local zoomframe = ioncore.lookup_region(zoomframe_name, 'WFrame')
   if (not zoomframe) or (curframe == zoomframe) then
      return
   end
   local zoomclient = zoomframe:lcurrent(1)
   zoomframe:attach(curclient)
   if zoomclient then
      curframe:attach(zoomclient)
   end
   zoomclient:goto() -- make it activated in the frame
   curclient:goto()
end
