// =============================================================================
//
//      --- kvi_colorwindow.cpp ---
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 1999-2000 Szymon Stefanek (stefanek@tin.it)
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc, 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
// =============================================================================

#define _KVI_DEBUG_CHECK_RANGE_
#define _KVI_DEBUG_CLASS_NAME_ "KviColorWindow"

#include <qpainter.h>

#include "kvi_app.h"
#include "kvi_colorwindow.h"
#include "kvi_config.h"
#include "kvi_options.h"

KviColorWindow::KviColorWindow()
	: QWidget(0, "KviColorWindow", Qt::WType_Popup)
{
	setFocusPolicy(NoFocus);
	setBackgroundMode(NoBackground);
	setFixedSize(146, 38);
	m_pOwner = 0;
	setFont(KviConfig::getFixedFont());
}

KviColorWindow::~KviColorWindow()
{
	killTimers();
}

void KviColorWindow::popup(QWidget *owner)
{
	m_pOwner = owner;
	show();
}

void KviColorWindow::paintEvent(QPaintEvent *)
{
	static int clrIdx[16] = { 1, 0, 0, 0, 0, 0, 0, 0, 1, 1, 1, 1, 0, 0, 0, 1 };
	QPainter p(this);
	for( int i = 0; i < 16; i++ ) {
		p.fillRect((i % 8) * 18, (i / 8) * 18, 18, 18, *(g_pOptions->m_pMircColor[i]));
		p.setPen(*(g_pOptions->m_pMircColor[clrIdx[i]]));
		p.drawText((i % 8) * 18, 1 + (i / 8) * 18, 18, 18, Qt::AlignVCenter | Qt::AlignHCenter, QString::number(i));
	}
}

void KviColorWindow::keyPressEvent(QKeyEvent *e)
{
	killTimers();
	hide();
	if( m_pOwner )
		g_pApp->sendEvent(m_pOwner, e);
}

void KviColorWindow::mousePressEvent(QMouseEvent *)
{
	killTimers();
	hide();
}

void KviColorWindow::show()
{
	startTimer(10000); // 10 seconds
	QWidget::show();
}

void KviColorWindow::timerEvent(QTimerEvent *)
{
	killTimers();
	hide();
}

#include "m_kvi_colorwindow.moc"
