
/* ====================================================================
 *
 * MOD_GZIP.C - Version 1.3.26.1a
 *
 * This program was developed by
 *
 * Remote Communications, Inc.
 * Home page: http://www.RemoteCommunications.com
 *
 * and is currently maintained by
 *
 * Christian Kruse, <ckruse@wwwtech.de> and Michael Schroepl,
 * <michael@schroepl.net>
 * Home page: http://sourceforge.net/projects/mod-gzip/
 *
 * Original author: Kevin Kiley, CTO, Remote Communications, Inc.
 * Email: Kiley@RemoteCommunications.com
 *
 * As of this writing there is an online support forum which
 * anyone may join by following the instructions found at...
 * http://lists.over.net/mailman/listinfo/mod_gzip
 *
 * ====================================================================
 */

/* APACHE LICENSE: START
 *
 * Portions of this software are covered under the following license
 * which, as it states, must remain included in this source code
 * module and may not be altered in any way.
 */

/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 *
 * Portions of this software are based upon public domain software
 * originally written at the National Center for Supercomputing Applications,
 * University of Illinois, Urbana-Champaign.
 */

/* APACHE LICENSE: END */

#define CORE_PRIVATE

#include "httpd.h"
#include "http_config.h"
#include "http_core.h"
#include "http_log.h"
#include "http_main.h"
#include "http_protocol.h"
#include "http_request.h"
#include "util_script.h"

#include "mod_gzip.h"

#ifdef MOD_GZIP_DEBUG1
#include "mod_gzip_debug.h"
#endif

extern API_VAR_EXPORT char ap_server_root[ MAX_STRING_LEN ];

static char mod_gzip_version[] = "1.3.26.1a";

int  mod_gzip_imap_size = (int) sizeof( mod_gzip_imap );
long mod_gzip_iusn      = 0;
static char mod_gzip_check_permissions[] = "Make sure all named directories exist and have the correct permissions.";


int mod_gzip_validate1(
request_rec   *r,
mod_gzip_conf *mgc,
char          *r__filename,
char          *r__uri,
char          *r__content_type,
char          *r__handler,
char          *fieldkey,
char          *fieldstring,
int            direction
)
{
 int   x                = 0;
 int   clen             = 0;
 int   hlen             = 0;
 int   flen             = 0;
 int   ulen             = 0;
 int   pass             = 0;
 int   passes           = 2;
 char *this_name        = 0;
 int   this_type        = 0;
 int   this_len1        = 0;
 int   this_action      = 0;
 int   this_include     = 0;
 char *checktarget      = 0;
 int   pass_result      = 0;
 int   action_value     = 0;
 int   filter_value     = 0;
 int   type_to_match    = 0;
 int   ok_to_check_it   = 0;
 int   http_field_check = 0;
 int   item_is_included = 0;
 int   item_is_excluded = 0;
 int   type_is_included = 0;
 int   remove_vary      = 0;

 regex_t *this_pregex   = NULL;
 int      regex_error   = 0;

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_validate1()";
 #endif

 if ( r__filename     ) flen = mod_gzip_strlen( (char *) r__filename );
 if ( r__uri          ) ulen = mod_gzip_strlen( (char *) r__uri );
 if ( r__content_type ) clen = mod_gzip_strlen( (char *) r__content_type );
 if ( r__handler      ) hlen = mod_gzip_strlen( (char *) r__handler );

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: Entry...",cn);
 mod_gzip_printf( "%s: r__filename     = [%s]",cn,npp(r__filename));
 mod_gzip_printf( "%s: flen            = %d",  cn,flen);
 mod_gzip_printf( "%s: r__uri          = [%s]",cn,npp(r__uri));
 mod_gzip_printf( "%s: ulen            = %d",  cn,ulen);
 mod_gzip_printf( "%s: r__content_type = [%s]",cn,npp(r__content_type));
 mod_gzip_printf( "%s: clen            = %d",  cn,clen);
 mod_gzip_printf( "%s: r__handler      = [%s]",cn,npp(r__handler));
 mod_gzip_printf( "%s: hlen            = %d",  cn,hlen);
 mod_gzip_printf( "%s: fieldkey        = [%s]",cn,npp(fieldkey));
 mod_gzip_printf( "%s: fieldstring     = [%s]",cn,npp(fieldstring));
 mod_gzip_printf( "%s: direction       = %d",  cn,direction);

 #endif

 if ( ( fieldkey ) && ( fieldstring ) )
   {
    http_field_check = 1;

    passes = 1;

    if ( direction == MOD_GZIP_REQUEST )
      {
       type_to_match = MOD_GZIP_IMAP_ISREQHEADER;
      }
    else if ( direction == MOD_GZIP_RESPONSE )
      {
       type_to_match = MOD_GZIP_IMAP_ISRSPHEADER;
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Invalid 'direction' value.",cn);
       mod_gzip_printf( "%s: Must be MOD_GZIP_REQUEST or MOD_GZIP_RESPONSE",cn);
       mod_gzip_printf( "%s: Exit > return( MOD_GZIP_IMAP_DECLINED1 ) >",cn);
       #endif

       return( MOD_GZIP_IMAP_DECLINED1 );
      }
   }

 else if ( ( hlen == 0 ) && ( clen == 0 ) && ( flen == 0 ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: hlen = 0 = No handler name passed...",cn);
    mod_gzip_printf( "%s: clen = 0 = No valid content-type passed",cn);
    mod_gzip_printf( "%s: flen = 0 = No valid filename passed",cn);
    mod_gzip_printf( "%s: There is nothing we can use to search",cn);
    mod_gzip_printf( "%s: for a match in the inclusion/exclusion list.",cn);
    mod_gzip_printf( "%s: Exit > return( MOD_GZIP_IMAP_DECLINED1 ) >",cn);
    #endif

    return( MOD_GZIP_IMAP_DECLINED1 );
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: passes = %d", cn,
                 (int) passes );
 mod_gzip_printf( "%s: http_field_check = %d", cn,
                 (int) http_field_check );
 mod_gzip_printf( "%s: mgc->imap_total_entries = %d", cn,
                 (int) mgc->imap_total_entries );
 #endif

 for ( pass=0; pass<passes; pass++ )
    {
     pass_result = 0;

     #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: ",cn);
     #endif
     #endif

     filter_value = pass;

     #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: pass         = %d", cn, pass );
     mod_gzip_printf( "%s: filter_value = %d", cn, filter_value );
     mod_gzip_printf( "%s: mgc->imap_total_entries = %d", cn,
                     (int) mgc->imap_total_entries );
     #endif
     #endif

     for ( x=0; x < mgc->imap_total_entries; x++ )
        {
         this_include = mgc->imap[x].include;
         this_type    = mgc->imap[x].type;
         this_action  = mgc->imap[x].action;

         #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
         #ifdef MOD_GZIP_DEBUG1

         mod_gzip_printf( "%s: --------------------------------------------",cn);
         mod_gzip_printf( "%s: http_field_check = %d",  cn,http_field_check );

         if ( http_field_check )
           {
            mod_gzip_printf( "%s: fieldkey         = [%s]",cn,npp(fieldkey));
            mod_gzip_printf( "%s: fieldstring      = [%s]",cn,npp(fieldstring));
           }
         else
           {
            mod_gzip_printf( "%s: r__filename      = [%s]",cn,npp(r__filename));
            mod_gzip_printf( "%s: r__uri           = [%s]",cn,npp(r__uri));
            mod_gzip_printf( "%s: r__content_type  = [%s]",cn,npp(r__content_type));
            mod_gzip_printf( "%s: r__handler       = [%s]",cn,npp(r__handler));
           }

         if ( this_include == 0 )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].include = %d EXCLUDE",cn,x,this_include);
           }
         else if ( this_include == 1 )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].include = %d INCLUDE",cn,x,this_include);
           }
         else
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].include = %d ??? UNKNOWN VALUE",cn,x,this_include);
           }

         if ( mgc->imap[x].type == MOD_GZIP_IMAP_ISMIME )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].type    = %d MOD_GZIP_IMAP_ISMIME",
                              cn,x,this_type);
           }
         else if ( mgc->imap[x].type == MOD_GZIP_IMAP_ISHANDLER )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].type    = %d MOD_GZIP_IMAP_ISHANDLER",
                              cn,x,this_type);
           }
         else if ( mgc->imap[x].type == MOD_GZIP_IMAP_ISFILE )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].type    = %d MOD_GZIP_IMAP_ISFILE",
                              cn,x,this_type);
           }
         else if ( mgc->imap[x].type == MOD_GZIP_IMAP_ISURI )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].type    = %d MOD_GZIP_IMAP_ISURI",
                              cn,x,this_type);
           }
         else if ( mgc->imap[x].type == MOD_GZIP_IMAP_ISREQHEADER )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].type    = %d MOD_GZIP_IMAP_ISREQHEADER",
                              cn,x,this_type);
           }
         else if ( mgc->imap[x].type == MOD_GZIP_IMAP_ISRSPHEADER )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].type    = %d MOD_GZIP_IMAP_ISRSPHEADER",
                              cn,x,this_type);
           }
         else
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].type    = %d MOD_GZIP_IMAP_IS??? Unknown type",
                              cn,x,this_type);
           }

         if ( mgc->imap[x].action == MOD_GZIP_IMAP_STATIC1 )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].action  = %d MOD_GZIP_IMAP_STATIC1",
                              cn,x,this_action);
           }
         else if ( mgc->imap[x].action == MOD_GZIP_IMAP_DYNAMIC1 )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].action  = %d MOD_GZIP_IMAP_DYNAMIC1",
                              cn,x,this_action);
           }
         else if ( mgc->imap[x].action == MOD_GZIP_IMAP_DYNAMIC2 )
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].action  = %d MOD_GZIP_IMAP_DYNAMIC2",
                              cn,x,this_action);
           }
         else
           {
            mod_gzip_printf( "%s: mgc->imap[%3.3d].action  = %d MOD_GZIP_IMAP_??? Unknown action",
                              cn,x,this_action);
           }

         mod_gzip_printf( "%s: mgc->imap[%3.3d].name    = [%s]",cn,x,npp(mgc->imap[x].name));
         mod_gzip_printf( "%s: mgc->imap[%3.3d].namelen = %d",  cn,x,mgc->imap[x].namelen);

         #endif
         #endif

         if ( this_include == filter_value )
           {
            #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
            #ifdef MOD_GZIP_DEBUG1
            mod_gzip_printf( "%s: This record matches filter_value %d",
                              cn, filter_value );
            mod_gzip_printf( "%s: The record will be checked...",cn);
            #endif
            #endif

            type_is_included = 0;
            checktarget      = 0;
            remove_vary      = 0;

            if ( http_field_check )
              {
               if ( this_type == type_to_match )
                 {
                  type_is_included = 1;

                  checktarget = (char *) fieldstring;
                 }
              }
            else
              {
               if ( ( this_type == MOD_GZIP_IMAP_ISMIME ) &&
                    ( clen > 0 ) )
                 {
                  type_is_included = 1;

                  checktarget = r__content_type;
                 }
               else if ( ( this_type == MOD_GZIP_IMAP_ISFILE ) &&
                         ( flen > 0 ) )
                 {
                  type_is_included = 1;
                  remove_vary      = 1;

                  checktarget = r__filename;
                 }
               else if ( ( this_type == MOD_GZIP_IMAP_ISURI ) &&
                         ( ulen > 0 ) )
                 {
                  type_is_included = 1;
                  remove_vary      = 1;

                  checktarget = r__uri;
                 }
               else if ( ( this_type == MOD_GZIP_IMAP_ISHANDLER ) &&
                         ( hlen > 0 ) )
                 {
                  type_is_included = 1;
                  remove_vary      = 1;

                  checktarget = r__handler;
                 }
              }

            if ( type_is_included )
              {
               #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
               #ifdef MOD_GZIP_DEBUG1
               mod_gzip_printf( "%s: type_is_included = %d = YES",cn,type_is_included);
               #endif
               #endif

               this_name   = mgc->imap[x].name;
               this_len1   = mgc->imap[x].len1;
               this_pregex = mgc->imap[x].pregex;

               ok_to_check_it = 1;

               if ( http_field_check )
                 {
                  #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
                  #ifdef MOD_GZIP_DEBUG1
                  mod_gzip_printf( "%s: fieldkey  = [%s]",cn,npp(fieldkey));
                  mod_gzip_printf( "%s: this_name = [%s]",cn,npp(this_name));
                  mod_gzip_printf( "%s: this_len1 = %d",  cn,this_len1);
                  mod_gzip_printf( "%s: Call mod_gzip_strnicmp(fieldkey,this_name,this_len1)...",cn);
                  #endif
                  #endif

                  if ( mod_gzip_strnicmp( fieldkey, this_name, this_len1 )==0)
                    {
                     #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: .... mod_gzip_strnicmp() = TRUE",cn);
                     mod_gzip_printf( "%s: .... Field key name MATCHES",cn);
                     #endif
                     #endif
                    }
                  else
                    {
                     #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: .... mod_gzip_strnicmp() = FALSE",cn);
                     mod_gzip_printf( "%s: .... Field key name does NOT MATCH",cn);
                     #endif
                     #endif

                     ok_to_check_it = 0;
                    }
                 }

               if ( ok_to_check_it )
                 {
                  #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
                  #ifdef MOD_GZIP_DEBUG1
                  mod_gzip_printf( "%s: ok_to_check_it = %d = YES",cn,ok_to_check_it);
                  #endif
                  #endif

                  if ( ( this_pregex ) && ( checktarget ) )
                    {
                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: 'this_pregex' is NON-NULL",cn);
                     mod_gzip_printf( "%s: Performing regular expression check...",cn);
                     mod_gzip_printf( "%s: Call ap_regexec( this_name=[%s], checktarget=[%s] )",
                                       cn, npp(this_name), npp(checktarget) );
                     #endif

                     regex_error =
                     ap_regexec(
                     this_pregex, checktarget, 0, (regmatch_t *) NULL, 0 );

                     if ( regex_error == 0 )
                       {
                        #ifdef MOD_GZIP_DEBUG1
                        mod_gzip_printf( "%s: YYYY regex_error = %d = MATCH!",cn,regex_error);
                        #endif

                        pass_result  = 1;
                        action_value = this_action;
                        break;
                       }
                     else
                       {
                        #ifdef MOD_GZIP_DEBUG1
                        mod_gzip_printf( "%s: NNNN regex_error = %d = NO MATCH!",cn,regex_error);
                        #endif
                       }
                    }
                  else
                    {
                     #ifdef MOD_GZIP_DEBUG1

                     if ( !this_pregex )
                       {
                        mod_gzip_printf( "%s: 'this_pregex' is NULL",cn);
                       }
                     if ( !checktarget )
                       {
                        mod_gzip_printf( "%s: 'checktarget' is NULL",cn);
                       }

                     mod_gzip_printf( "%s: No regular expression check performed",cn);

                     #endif
                    }
                 }
               else
                 {
                  #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
                  #ifdef MOD_GZIP_DEBUG1
                  mod_gzip_printf( "%s: ok_to_check_it = %d = NO",cn,ok_to_check_it);
                  mod_gzip_printf( "%s: The record has been SKIPPED...",cn);
                  #endif
                  #endif
                 }
              }
            else
              {
               #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
               #ifdef MOD_GZIP_DEBUG1
               mod_gzip_printf( "%s: type_is_included = %d = NO",cn,type_is_included);
               mod_gzip_printf( "%s: The record has been SKIPPED...",cn);
               #endif
               #endif
              }
           }
         else
           {
            #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
            #ifdef MOD_GZIP_DEBUG1
            mod_gzip_printf( "%s: This record does NOT match filter_value %d",
                              cn, filter_value );
            mod_gzip_printf( "%s: The record has been SKIPPED...",cn);
            #endif
            #endif
           }
        }

     #ifdef MOD_GZIP_DEBUG1_VALIDATE1_VERBOSE1
     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: --------------------------------------------",cn);
     mod_gzip_printf( "%s: pass_result = %d",cn,pass_result);
     #endif
     #endif

     if ( pass_result )
       {
        if ( pass == 0 ) item_is_excluded = 1;
        else             item_is_included = 1;

        break;
       }

    }/* End 'for ( pass=0; pass<passes; pass++ )' */
       
 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: item_is_excluded = %d",cn,item_is_excluded);
 mod_gzip_printf( "%s: item_is_included = %d",cn,item_is_included);
 #endif

 if ( item_is_excluded )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: The item is EXCLUDED...",cn);
    mod_gzip_printf( "%s: Exit > return( MOD_GZIP_IMAP_DECLINED1 ) >",cn);
    #endif

    if(remove_vary) {
      #ifdef MOD_GZIP_DEBUG1
      mod_gzip_printf("%s: removing vary...",cn);
      #endif

      ap_table_unset(r->headers_out,"Vary");
    }
    #ifdef MOD_GZIP_DEBUG1
    else {
      mod_gzip_printf("%s: leaving vary as it is...",cn);
    }
    #endif

    return( MOD_GZIP_IMAP_DECLINED1 );
   }

 else if ( item_is_included )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: The item is INCLUDED, leaving vary as it is...",cn);
    mod_gzip_printf( "%s: Exit > return( 1 ) >",cn);
    #endif

    return action_value;
   }

 if ( http_field_check )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ?? Status unknown ?? Default is to 'accept'...",cn);
    mod_gzip_printf( "%s: Exit > return( MOD_GZIP_IMAP_STATIC1 ) >",cn);
    #endif

    return MOD_GZIP_IMAP_STATIC1;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Exit > return( MOD_GZIP_IMAP_DECLINED1 ) >",cn);
 #endif

 if(remove_vary) {
   #ifdef MOD_GZIP_DEBUG1
   mod_gzip_printf("%s: removing vary...",cn);
   #endif

   ap_table_unset(r->headers_out,"Vary");
 }
 #ifdef MOD_GZIP_DEBUG1
 else {
   mod_gzip_printf("%s: leaving vary as it is...",cn);
 }
 #endif

 return( MOD_GZIP_IMAP_DECLINED1 );
}


/* NOTE: If API_VAR_EXPORT prefix is not used for 'top_module' */
/* declaration then MSVC 6.0 will give 'incosistent DLL linkage' */
/* warning during WIN32 compile... */

extern API_VAR_EXPORT module *top_module;

#define MOD_GZIP_RUN_TYPE_CHECKERS      1
#define MOD_GZIP_RUN_TRANSLATE_HANDLERS 2

int mod_gzip_run_handlers( request_rec *r, int flag1 )
{
 int rc    = 0;
 int count = 0;
 int runit = 0;
 int handler_is_present=0;

 module *modp;

 #ifdef MOD_GZIP_DEBUG1
 #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
 const handler_rec *handp;
 char cn[]="mod_gzip_run_handlers()";
 #endif
 #endif

 #ifdef MOD_GZIP_DEBUG1
 #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
 mod_gzip_server_now = r->server;
 mod_gzip_printf( "%s: Entry...",cn);
 mod_gzip_printf( "%s: *IN: r->uri          =[%s]", cn, npp(r->uri));
 mod_gzip_printf( "%s: *IN: r->unparsed_uri =[%s]", cn, npp(r->unparsed_uri));
 mod_gzip_printf( "%s: *IN: r->filename     =[%s]", cn, npp(r->filename));
 mod_gzip_printf( "%s: *IN: r->handler      =[%s]", cn, npp(r->handler));
 mod_gzip_printf( "%s: *IN: r->content_type =[%s]", cn, npp(r->content_type));
 #endif
 #endif

 if ( flag1 == MOD_GZIP_RUN_TYPE_CHECKERS )
   {
    #ifdef MOD_GZIP_DEBUG1
    #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
    mod_gzip_printf( "%s: flag1 = %d = MOD_GZIP_RUN_TYPE_CHECKERS",cn,flag1);
    #endif
    #endif
   }
 else if ( flag1 == MOD_GZIP_RUN_TRANSLATE_HANDLERS )
   {
    #ifdef MOD_GZIP_DEBUG1
    #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
    mod_gzip_printf( "%s: flag1 = %d = MOD_GZIP_RUN_TRANSLATE_HANDLERS",cn,flag1);
    #endif
    #endif
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
    mod_gzip_printf( "%s: flag1 = %d = MOD_GZIP_RUN_??? Unknown value",cn,flag1);
    mod_gzip_printf( "%s: ERROR: Exit > return( DECLINED ) >",cn);
    #endif
    #endif

    return( DECLINED );
   }

 for ( modp = top_module; modp; modp = modp->next )
    {
     #ifdef MOD_GZIP_DEBUG1
     #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
     mod_gzip_printf( "%s: count=%4.4d modp = %10.10ld modp->name=[%s]",
     cn,count,(long)modp,npp(modp->name));
     #endif
     #endif

     runit = 0;

     if ( modp )
       {
        runit = 1;

        if ( modp == &gzip_module )
          {
           runit = 0;
          }

        #ifdef FUTURE_USE
        if ( mod_gzip_strnicmp( (char *) modp->name, "mod_gzip.c",10)==0)
          {
           runit = 0;
          }
        #endif
       }

     if ( runit )
       {
        #ifdef MOD_GZIP_DEBUG1
        #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1

        mod_gzip_printf( "%s: ++++++++++ MODULE FOUND!...",cn);
        mod_gzip_printf( "%s: ++++++++++ modp->module_index = %d",cn,(int)modp->module_index);

        #ifdef REFERENCE

        typedef struct {
        const char *content_type;
        int (*handler) (request_rec *);
        } handler_rec;

        typedef struct module_struct {
        ...
        const handler_rec *handlers;
        ...
        }module;

        #endif

        mod_gzip_printf( "%s: ++++++++++ METHODS",cn);
        mod_gzip_printf( "%s: ++++++++++ modp->translate_handler = %ld",cn,(long)modp->translate_handler);
        mod_gzip_printf( "%s: ++++++++++ modp->ap_check_user_id  = %ld",cn,(long)modp->ap_check_user_id);
        mod_gzip_printf( "%s: ++++++++++ modp->auth_checker      = %ld",cn,(long)modp->auth_checker);
        mod_gzip_printf( "%s: ++++++++++ modp->access_checker    = %ld",cn,(long)modp->access_checker);
        mod_gzip_printf( "%s: ++++++++++ modp->type_checker      = %ld",cn,(long)modp->type_checker);
        mod_gzip_printf( "%s: ++++++++++ modp->fixer_upper       = %ld",cn,(long)modp->fixer_upper);
        mod_gzip_printf( "%s: ++++++++++ modp->logger            = %ld",cn,(long)modp->logger);
        mod_gzip_printf( "%s: ++++++++++ modp->header_parser     = %ld",cn,(long)modp->header_parser);
        mod_gzip_printf( "%s: .......... CONTENT HANDLERS",cn);

        if ( !modp->handlers )
          {
           mod_gzip_printf( "%s: .......... NO CONTENT HANDLERS!",cn);
          }
        else
          {
           for ( handp = modp->handlers; handp->content_type; ++handp )
              {
               mod_gzip_printf( "%s: .......... handp->content_type = [%s]",
               cn,npp(handp->content_type));
               mod_gzip_printf( "%s: .......... handp->handler      = %ld",
               cn,(long)handp->handler);
              }
          }

        #endif
        #endif

        handler_is_present = 0;

        if ( flag1 == MOD_GZIP_RUN_TYPE_CHECKERS )
          {
           if ( modp->type_checker ) handler_is_present = 1;
          }
        else if ( flag1 == MOD_GZIP_RUN_TRANSLATE_HANDLERS )
          {
           if ( modp->translate_handler ) handler_is_present = 1;
          }

        #ifdef MOD_GZIP_DEBUG1
        #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
        mod_gzip_printf( "%s: handler_is_present = %d ",
                          cn, handler_is_present);
        #endif
        #endif

        if ( handler_is_present )
          {
           #ifdef MOD_GZIP_DEBUG1
           #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1

           mod_gzip_printf( "%s: 'handler_is_present' is TRUE...",cn);

           mod_gzip_printf( "%s: r->filename     = [%s]",cn,npp(r->filename));
           mod_gzip_printf( "%s: r->uri          = [%s]",cn,npp(r->uri));
           mod_gzip_printf( "%s: r->handler      = [%s]",cn,npp(r->handler));
           mod_gzip_printf( "%s: r->content_type = [%s]",cn,npp(r->content_type));

           if ( flag1 == MOD_GZIP_RUN_TYPE_CHECKERS )
             {
              mod_gzip_printf( "%s: Call (modp->type_checker)(r)...",cn);
             }
           else if ( flag1 == MOD_GZIP_RUN_TRANSLATE_HANDLERS )
             {
              mod_gzip_printf( "%s: Call (modp->translate_handler)(r)...",cn);
             }

           #endif
           #endif

           if ( flag1 == MOD_GZIP_RUN_TYPE_CHECKERS )
             {
              rc = (modp->type_checker)( (request_rec *) r );
             }
           else if ( flag1 == MOD_GZIP_RUN_TRANSLATE_HANDLERS )
             {
              rc = (modp->translate_handler)( (request_rec *) r );
             }

           #ifdef MOD_GZIP_DEBUG1
           #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1

           if ( flag1 == MOD_GZIP_RUN_TYPE_CHECKERS )
             {
              mod_gzip_printf( "%s: Back (modp->type_checker)(r)...",cn);
             }
           else if ( flag1 == MOD_GZIP_RUN_TRANSLATE_HANDLERS )
             {
              mod_gzip_printf( "%s: Back (modp->translate_handler)(r)...",cn);
             }

           mod_gzip_printf( "%s: r->filename     = [%s]",cn,npp(r->filename));
           mod_gzip_printf( "%s: r->uri          = [%s]",cn,npp(r->uri));
           mod_gzip_printf( "%s: r->handler      = [%s]",cn,npp(r->handler));
           mod_gzip_printf( "%s: r->content_type = [%s]",cn,npp(r->content_type));

           if ( rc == OK )
             {
              mod_gzip_printf( "%s: rc = %d = OK",cn, rc );
             }
           else if ( rc == DECLINED )
             {
              mod_gzip_printf( "%s: rc = %d = DECLINED",cn, rc );
             }
           else if ( rc == DONE )
             {
              mod_gzip_printf( "%s: rc = %d = DONE",cn, rc );
             }
           else
             {
              mod_gzip_printf( "%s: rc = %d = HTTP_ERROR?",cn, rc );
             }

           #endif
           #endif

           if ( rc == OK )
             {
              #ifdef MOD_GZIP_DEBUG1
              #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
              mod_gzip_printf( "%s: Call SUCCEEDED",cn );
              mod_gzip_printf( "%s: Exit > return( rc=%d ) >",cn,rc);
              #endif
              #endif

              return rc;
             }
           else
             {
              #ifdef MOD_GZIP_DEBUG1
              #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
              mod_gzip_printf( "%s: Call FAILED",cn );
              #endif
              #endif

              if ( rc != DECLINED )
                {
                 #ifdef MOD_GZIP_DEBUG1
                 #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
                 mod_gzip_printf( "%s: Something other than 'DECLINED' was returned.",cn);
                 mod_gzip_printf( "%s: Exit > return( rc=%d ) >",cn,rc);
                 #endif
                 #endif

                 return rc;
                }
              else
                {
                 #ifdef MOD_GZIP_DEBUG1
                 #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
                 mod_gzip_printf( "%s: 'DECLINED' was returned... Continuing chain...",cn);
                 #endif
                 #endif
                }
             }
          }
        else
          {
           #ifdef MOD_GZIP_DEBUG1
           #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
           mod_gzip_printf( "%s: 'handler_is_present' is FALSE...",cn);
           #endif
           #endif
          }
       }
     else
       {
        #ifdef MOD_GZIP_DEBUG1
        #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
        mod_gzip_printf( "%s: 'runit' is FALSE...",cn);
        mod_gzip_printf( "%s: SKIPPING THIS MODULE",cn);
        #endif
        #endif
       }

     count++;
    }

 #ifdef MOD_GZIP_DEBUG1
 #ifdef MOD_GZIP_DEBUG1_RUN_HANDLERS1
 mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
 #endif
 #endif

 return DECLINED;
}


int mod_gzip_delete_file(
request_rec   *r,
char          *filename
)
{
 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_delete_file()";
 #endif

 int final_rc = 0; 

 #ifdef WIN32
 BOOL rc;
 #else
 int rc;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...",cn);
 mod_gzip_printf( "%s: filename = [%s]",cn,npp(filename));
 #endif

 #ifdef WIN32

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call DeleteFile(%s)...",cn,npp(filename));
 #endif

 rc = (BOOL) DeleteFile( filename );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back DeleteFile(%s)...",cn,npp(filename));
 #endif

 if ( rc == FALSE ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... DeleteFile() FAILED",cn);
    #endif
   }
 else 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... DeleteFile() SUCCEEDED",cn);
    #endif

    final_rc = 1; 
   }

 #else 

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call unlink(%s)...",cn,npp(filename));
 #endif

 rc = (int) unlink( filename );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back unlink(%s)...",cn,npp(filename));
 #endif

 if ( rc < 0 ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... unlink() FAILED",cn);
    #endif
   }
 else 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... unlink() SUCCEEDED",cn);
    #endif

    final_rc = 1; 
   }

 #endif 

 #ifdef MOD_GZIP_DEBUG1

 if ( final_rc == 1 ) 
   {
    mod_gzip_printf( "%s: Exit > return( final_rc = %d ) SUCCESS >",cn,final_rc);
   }
 else 
   {
    mod_gzip_printf( "%s: Exit > return( final_rc = %d ) FAILURE >",cn,final_rc);
   }

 #endif 

 return( final_rc );
}

static void mod_gzip_init( server_rec *server, pool *p )
{
 int add_version_info=1;

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_init()";
 #endif

 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_server_now = server;

 mod_gzip_printf( " " );
 mod_gzip_printf( "%s: Entry...", cn );

 #endif

 mgc = ( mod_gzip_conf * )
 ap_get_module_config( server->module_config, &gzip_module );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: MODULE_MAGIC_NUMBER = %ld", cn, (long) MODULE_MAGIC_NUMBER );
 #endif

 if ( add_version_info )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: add_version_info = TRUE", cn );
    #endif

    #if MODULE_MAGIC_NUMBER >= 19980507

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: MODULE_MAGIC_NUMBER is >= 19980507",cn);
    mod_gzip_printf( "%s: Call ap_add_version_component(%s)...",
    cn, npp(MOD_GZIP_VERSION_INFO_STRING));
    #endif

    ap_add_version_component( MOD_GZIP_VERSION_INFO_STRING );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back ap_add_version_component(%s)...",
    cn, npp(MOD_GZIP_VERSION_INFO_STRING));
    #endif

    #else

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: MODULE_MAGIC_NUMBER is NOT >= 19980507", cn );
    mod_gzip_printf( "%s: ap_add_version_component() NOT called.", cn );
    #endif

    #endif
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: add_version_info = FALSE", cn );
    mod_gzip_printf( "%s: ap_add_version_component() NOT called.", cn );
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Initialization completed...", cn );
 mod_gzip_printf( "%s: Exit > return( void ) >", cn );
 mod_gzip_printf( " " );
 #endif
}

int mod_gzip_strncmp( char *s1, char *s2, int len1 )
{
 int  i;
 char ch1;
 char ch2;

 if ( ( s1 == 0 ) || ( s2 == 0 ) )
   {
    return 1;
   }

 for ( i=0; i<len1; i++ )
    {
     if ( ( *s1 == 0 ) || ( *s2 == 0 ) ) return( 1 ); 

     ch1 = *s1;
     ch2 = *s2;

     if ( ch1 == '/' ) ch1 = '\\';
     if ( ch2 == '/' ) ch2 = '\\';

     if ( ch1 != ch2 ) return 1;

     s1++;
     s2++;
    }

 return 0;
}

int mod_gzip_strnicmp( char *s1, char *s2, int len1 )
{
 int  i;
 char ch1;
 char ch2;

 if ( ( s1 == 0 ) || ( s2 == 0 ) )
   {
    return 1;
   }

 for ( i=0; i<len1; i++ )
    {
     if ( ( *s1 == 0 ) || ( *s2 == 0 ) ) return( 1 ); 

     ch1 = *s1;
     ch2 = *s2;

     if ( ch1 > 96 ) ch1 -= 32;
     if ( ch2 > 96 ) ch2 -= 32;

     if ( ch1 == '/' ) ch1 = '\\';
     if ( ch2 == '/' ) ch2 = '\\';

     if ( ch1 != ch2 ) return 1;

     s1++;
     s2++;
    }

 return 0;
}

int mod_gzip_strendswith( char *s1, char *s2, int ignorcase )
{
 int len1;
 int len2;

 if ( ( s1 == 0 ) || ( s2 == 0 ) )
   {
    return 0;
   }

 len1 = mod_gzip_strlen( s1 );
 len2 = mod_gzip_strlen( s2 );

 if ( len1 < len2 )
   {
    /* Source string is shorter than search string */
    /* so no match is possible */

    return 0;
   }

 s1 += ( len1 - len2 );

 if ( ignorcase )
   {
    if ( mod_gzip_strnicmp( s1, s2, len2 ) == 0 ) return 1; /* TRUE */
   }
 else
   {
    if ( mod_gzip_strncmp(  s1, s2, len2 ) == 0 ) return 1; /* TRUE */
   }

 return 0; /* FALSE */
}

int mod_gzip_strlen( char *s1 )
{
 int len = 0;

 if ( s1 != 0 )
   {
    while( *s1 != 0 ) { s1++; len++; }
   }

 return len;
}

int mod_gzip_strcpy( char *s1, char *s2 )
{
 int len = 0;

 if ( ( s1 != 0 )&&( s2 != 0 ) )
   {
    while( *s2 != 0 ) { *s1++ = *s2++; len++; }
    *s1=0; 
   }

 return len;
}

int mod_gzip_strncpy(char *s1,char *s2,int l) {
  int len = 0;

  if((s1 != 0) && (s2 != 0)) {
    while(*s2 != 0 && *s1 != 0 && len <= l) {
      *s1++ = *s2++; 
      len++;
    }

    *s1 = 0;
  }

  return len;
}

int mod_gzip_strcat( char *s1, char *s2 )
{
 int len = 0;

 if ( s1 != 0 )
   {
    while( *s1 != 0 ) { s1++; len++; }
    if ( s2 != 0 )
      {
       while( *s2 != 0 ) { *s1++ = *s2++; len++; }
       *s1 = 0; 
      }
   }

 return len;
}

int mod_gzip_stringcontains( char *source, char *substring )
{
 int i;
 int len1;
 int len2;
 int len3;
 int offset=1; 

 char *source1;    
 char *substring1; 

 if ( source == NULL )
   {
    return 0;
   }

 if ( substring == NULL )
   {
    return 0;
   }

 source1    = source;    
 substring1 = substring; 

 len1 = mod_gzip_strlen( source    );
 len2 = mod_gzip_strlen( substring );

 if ( len1 < len2 )
   {
    return 0;
   }

 len3 = len1 - len2;

 for ( i=0; i<=len3; i++ )
    {
     if ( mod_gzip_strnicmp( source, substring, len2 ) == 0 )
       {
        source    = source1;    
        substring = substring1; 

        return offset;
       }

     source++;
     offset++;
    }

 source    = source1;    
 substring = substring1; 

 return 0;
}

#ifndef WIN32
long fake_tid = 99;
#endif

int mod_gzip_create_unique_filename(
char *prefix,
char *target,
int   targetmaxlen
)
{
 long  process_id = 0;  
 long  thread_id  = 0;  

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_create_unique_filename()";
 #endif

 int prefixlen = 0;
 char slash[4];

 #ifdef WIN32
 process_id = (long) GetCurrentProcessId();
 thread_id  = (long) GetCurrentThreadId();
 #else 

 process_id = (long) getpid();
 thread_id  = (long) fake_tid;
 fake_tid++;
 if ( fake_tid > 9999999 ) fake_tid = 99; 
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...",cn );
 mod_gzip_printf( "%s: prefix            = [%s]",cn,npp(prefix));
 mod_gzip_printf( "%s: target            = %ld", cn,(long)target);
 mod_gzip_printf( "%s: targetmaxlen      = %ld", cn,(long)targetmaxlen);
 mod_gzip_printf( "%s: process_id        = %ld", cn,(long)process_id );
 mod_gzip_printf( "%s: thread_id         = %ld", cn,(long)thread_id  );
 mod_gzip_printf( "%s: mod_gzip_iusn     = %ld", cn,(long)mod_gzip_iusn );
 #endif

 if ( ( !target ) || ( targetmaxlen == 0 ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Invalid target or targetmaxlen value.",cn);
    mod_gzip_printf( "%s: Exit > return( 1 ) > ERROR >",cn );
    #endif

    return 1;
   }

 if ( prefix ) 
   {
    prefixlen = mod_gzip_strlen( prefix );
   }

 if ( prefixlen > 0 ) 
   {
    slash[0]=0; 

    if ( ( *(prefix+(prefixlen-1)) != '\\' ) &&
         ( *(prefix+(prefixlen-1)) != '/'  ) )
      {
       #ifdef WIN32
       slash[0]='\\';
       #else
       slash[0]='/';
       #endif
       slash[1]=0;
      }

    sprintf(
    target,
    "%s%s_%ld_%ld_%ld.wrk",
    prefix,              
    slash,               
    (long) process_id,   
    (long) thread_id,    
    (long) mod_gzip_iusn 
    );
   }
 else 
   {
    sprintf(
    target,
    "_%ld_%ld_%ld.wrk",
    (long) process_id,   
    (long) thread_id,    
    (long) mod_gzip_iusn 
    );
   }

 mod_gzip_iusn++; 

 if ( mod_gzip_iusn > 999999999L ) mod_gzip_iusn = 1; 

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: target = [%s]",cn,npp(target));
 mod_gzip_printf( "%s: Exit > return( 0 ) >",cn );
 #endif

 return 0;
}

int mod_gzip_type_checker( request_rec *r )
{
 int         i           = 0;
 int         rc          = 0;
 int         field_ok    = 0;
 int         action_flag = 0;
 const char *tablekey    = 0;
 const char *tablestring = 0;
 int         accept_encoding_gzip_seen = 0;

#ifdef WIN32
 long content_length;
#endif

 _table *t = 0;
 table_entry *elts = 0;

 mod_gzip_conf *dconf = 0;

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_type_checker()";
 mod_gzip_conf *sconf = 0;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( " " );
 mod_gzip_printf( "%s: ''''Entry...",cn);
 mod_gzip_printf( "%s: r                = %ld", cn,(long)r);
 mod_gzip_printf( "%s: r->main          = %ld", cn,(long)r->main);
 mod_gzip_printf( "%s: r->next          = %ld", cn,(long)r->next);
 mod_gzip_printf( "%s: r->prev          = %ld", cn,(long)r->prev);
 mod_gzip_printf( "%s: r->header_only   = %ld", cn,(long)r->header_only );
 mod_gzip_printf( "%s: r->method_number = %ld", cn,(long)r->method_number );
 mod_gzip_printf( "%s: r->method        = [%s]",cn,npp(r->method));
 mod_gzip_printf( "%s: r->unparsed_uri  = [%s]",cn,npp(r->unparsed_uri));
 mod_gzip_printf( "%s: r->uri           = [%s]",cn,npp(r->uri));
 mod_gzip_printf( "%s: r->filename      = [%s]",cn,npp(r->filename));
 mod_gzip_printf( "%s: r->handler       = [%s]",cn,npp(r->handler));
 mod_gzip_printf( "%s: r->content_type  = [%s]",cn,npp(r->content_type));
 #endif

 #ifdef MOD_GZIP_USES_APACHE_LOGS

 if ( r->main )
   {
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:UNHANDLED_SUBREQ"));
   }
 else if ( r->prev )
   {
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:UNHANDLED_REDIR"));
   }
 else
   {
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:INIT1"));
   }

 ap_table_setn( r->notes,"mod_gzip_input_size", ap_pstrdup(r->pool,"0"));
 ap_table_setn( r->notes,"mod_gzip_output_size",ap_pstrdup(r->pool,"0"));
 ap_table_setn( r->notes,"mod_gzip_compression_ratio",ap_pstrdup(r->pool,"0"));

 #endif


 dconf = ( mod_gzip_conf * )
 ap_get_module_config( r->per_dir_config, &gzip_module );

 #ifdef MOD_GZIP_DEBUG1

 sconf = ( mod_gzip_conf * )
 ap_get_module_config( r->server->module_config, &gzip_module );

 mod_gzip_printf( "%s: r->server->server_hostname = [%s]", cn,npp(r->server->server_hostname));
 mod_gzip_printf( "%s: sconf        = %ld", cn,(long)sconf);
 mod_gzip_printf( "%s: sconf->loc   = [%s]",cn,npp(sconf->loc));
 mod_gzip_printf( "%s: sconf->is_on = %ld", cn,(long)sconf->is_on);
 mod_gzip_printf( "%s: dconf        = %ld", cn,(long)dconf);
 mod_gzip_printf( "%s: dconf->loc   = [%s]",cn,npp(dconf->loc));
 mod_gzip_printf( "%s: dconf->is_on = %ld", cn,(long)dconf->is_on);

 #endif

 if(!dconf) {
   #ifdef MOD_GZIP_USES_APACHE_LOGS
   ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:NO_DCONF"));
   #endif

   #ifdef MOD_GZIP_DEBUG1
   mod_gzip_printf( "%s: 'dconf' is NULL. Unable to continue.",cn);
   mod_gzip_printf( "%s: Exit > return( DECLINED ) >", cn);
   #endif

   return DECLINED;
 }

 if(r->filename) {
   #ifdef MOD_GZIP_DEBUG1
   mod_gzip_printf("%s: in r->filename, suffix is: %s, filename is: %s",cn,dconf->suffix,r->filename);
   #endif

   if(mod_gzip_strendswith( r->filename, dconf->suffix, 1)) {
     if(r->prev) {
       /* This is a mod_gzip negotiated .gz static file transmit... */
       #ifdef MOD_GZIP_USES_APACHE_LOGS
       const char *t = ap_table_get(r->prev->notes,"mod_gzip_result_n");
       ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,t ? t : "DECLINED:STATIC_GZ_FOUND"));
       #endif

       if(dconf->send_vary) {
         if(dconf->min_http_set) {
           ap_table_setn(r->headers_out,ap_pstrdup(r->pool,"Vary"),ap_pstrdup(r->pool,"*"));
         }
         else {
           ap_table_setn(r->headers_out,ap_pstrdup(r->pool,"Vary"),mod_gzip_generate_vary_header(dconf,r->pool));
         }
       }
     }
     #ifdef MOD_GZIP_USES_APACHE_LOGS
     else {
       /* This is a direct request from client for a .gz file... */
       ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:FEXT_GZ"));
     }
     #endif

     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: r->filename ends with '%s'...",cn,dconf->suffix);
     mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
     #endif

     return DECLINED;
   }
   #ifdef MOD_GZIP_DEBUG1
   else {
     mod_gzip_printf( "%s: r->filename does NOT end with '%s'...",cn,dconf->suffix);
     mod_gzip_printf( "%s: OK to continue...",cn);
   }
   #endif
 }

 if ( !dconf->is_on )
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:OFF"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'dconf->is_on' is FALSE",cn);
    mod_gzip_printf( "%s: mod_gzip is not turned ON for this location...",cn);
    mod_gzip_printf( "%s: This transaction will be ignored...",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 if ( ( r->method_number != M_GET  ) &&
      ( r->method_number != M_POST ) )
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:NOT_GET_OR_POST"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->method_number is NOT M_GET or M_POST",cn);
    mod_gzip_printf( "%s: Ignoring this request...",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 else {
   if(dconf->handle_methods != MOD_GZIP_M_BOTH && dconf->handle_methods != MOD_GZIP_M_NOT_SET) {
     if(
       (r->method_number == M_GET && dconf->handle_methods == M_POST) ||
       (r->method_number == M_POST && dconf->handle_methods == M_GET)) {
       #ifdef MOD_GZIP_USES_APACHE_LOGS
       ap_table_setn(r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:METHOD_EXCLUDED"));
       #endif

       return DECLINED;
     }
   }
 }

 /*
  * Bugfix for POST bug on win32
  */
#ifdef WIN32
 if(r->method_number == M_POST) {
   content_length = strtol(ap_table_get(r->headers_in,"Content-Length"),NULL,10);

   if(r->connection->client->incnt < content_length) {
     #ifdef MOD_GZIP_USES_APACHE_LOGS
     ap_table_setn(r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:POST_TOO_BIG"));
     #endif
     return DECLINED;
   }
 }
#endif

 if ( r->header_only  )
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:HEAD_REQUEST"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->header_only is TRUE...",cn);
    mod_gzip_printf( "%s: Ignoring this HEAD request...",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }


 /*
  * set the vary header
  */
 if(dconf->send_vary) {
   if(dconf->min_http_set) {
     ap_table_setn(r->headers_out,ap_pstrdup(r->pool,"Vary"),ap_pstrdup(r->pool,"*"));
   }
   else {
     ap_table_setn(r->headers_out,ap_pstrdup(r->pool,"Vary"),mod_gzip_generate_vary_header(dconf,r->pool));
   }
 }

 if ( r->main ) /* SUBREQUEST */
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->main is TRUE - This is a subrequest...",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->main is FALSE",cn);
    mod_gzip_printf( "%s: This is NOT a subrequest in progress...",cn);
    mod_gzip_printf( "%s: OK to continue...",cn);
    #endif
   }

 if ( r->prev ) /* REDIRECT */
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->prev is NON-NULL... This is a redirection",cn);
    #ifdef MOD_GZIP_DEBUG1_SHOW_REQUEST_RECORD1
    mod_gzip_printf( "%s: Showing contents of r->prev now...",cn);
    mod_gzip_show_request_record( r->prev, cn );
    #endif
    #endif

    tablestring = ap_table_get(r->prev->notes, "mod_gzip_running");

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->prev->notes->mod_gzip_running = [%s]",
                      cn,npp(tablestring));
    #endif

    if ( tablestring )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: 'mod_gzip_running' note FOUND",cn);
       #endif

       if ( *tablestring == '1' )
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: 'mod_gzip_running' note value is '1'...",cn);
          #endif

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: ************************************************",cn);
          mod_gzip_printf( "%s: mod_gzip is currently 'running' so we ",cn);
          mod_gzip_printf( "%s: must return DECLINED so that other type_checker",cn);
          mod_gzip_printf( "%s: hooks can fire...",cn);
          mod_gzip_printf( "%s: ************************************************",cn);
          mod_gzip_printf( "%s: IMPORTANT: We must now 'replicate' the note flag",cn);
          mod_gzip_printf( "%s: on this record or next time around r->prev",cn);
          mod_gzip_printf( "%s: note flag check will be FALSE.",cn);
          mod_gzip_printf( "%s: ************************************************",cn);
          #endif

          ap_table_setn(r->notes,"mod_gzip_running",ap_pstrdup(r->pool,"1"));

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: r->notes 'mod_gzip_running' set with value = '1'",cn);
          mod_gzip_printf( "%s: ************************************************",cn);
          mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
          #endif

          return DECLINED;
         }
       else
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: 'mod_gzip_running' note value is NOT '1'...",cn);
          #endif
         }
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: 'mod_gzip_running' note NOT FOUND",cn);
       #endif
      }
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: r->prev is NULL... This is NOT a redirection",cn);
   }
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf->min_http = %ld", cn, (long) dconf->min_http );
 mod_gzip_printf( "%s: r->proto_num    = %ld", cn, (long) r->proto_num );
 #endif

 if ( ( dconf->min_http > 0 ) && ( r->proto_num > 0 ) )
   {
    if ( r->proto_num < dconf->min_http )
      {
       #ifdef MOD_GZIP_USES_APACHE_LOGS
       ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:HTTP_LEVEL_TOO_LOW"));
       #endif

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: HTTP protocol version level is TOO LOW", cn);
       mod_gzip_printf( "%s: Exit > return( DECLINED ) >", cn);
       #endif

       return DECLINED;
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: HTTP protocol version level is OK", cn);
       #endif
      }
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Checking for [Accept-Encoding: gzip]", cn );
 #endif

 tablestring = ap_table_get(r->headers_in, "Accept-Encoding");

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->headers_in->Accept-Encoding = [%s]",
                   cn,npp(tablestring));
 #endif

 if ( tablestring )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'Accept-Encoding' field seen...", cn);
    mod_gzip_printf( "%s: Checking for 'gzip' value...", cn);
    #endif

    if ( mod_gzip_stringcontains( (char *)tablestring, "gzip" ) )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: 'gzip' value seen...", cn);
       #endif

       accept_encoding_gzip_seen = 1;
      }
    else
      {
       #ifdef MOD_GZIP_USES_APACHE_LOGS
       ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:NO_GZIP"));
       #endif

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: 'gzip' value NOT seen...", cn);
       mod_gzip_printf( "%s: Exit > return( DECLINED ) >", cn);
       #endif

       return DECLINED;
      }
   }
 else
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:NO_ACCEPT_ENCODING"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'Accept-Encoding' field NOT seen...", cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >", cn);
    #endif

    return DECLINED;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: accept_encoding_gzip_seen = %ld",
                   cn, accept_encoding_gzip_seen );
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf->imap_total_entries = %d", cn,
                 (int) dconf->imap_total_entries );
 #endif

 if ( dconf->imap_total_entries < 1 )
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:NO_ITEMS_DEFINED"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: There are no IMAP entries. Unable to include/exclude",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >", cn);
    #endif

    return DECLINED;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf->imap_total_isreqheader = %d", cn,
                 (int) dconf->imap_total_isreqheader );
 #endif

 if ( dconf->imap_total_isreqheader > 0 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Checking inbound REQUEST header fields...", cn );
    #endif

    t    = (_table      *) r->headers_in;
    elts = (table_entry *) t->a.elts;

    for ( i = 0; i < t->a.nelts; i++ )
       {
        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf( "%s: %3.3d key=[%s] val=[%s]",
        cn,i,npp(elts[i].key),npp(elts[i].val));
        #endif

        tablekey    = elts[i].key;
        tablestring = elts[i].val;

        if (( tablekey && tablestring ))
          {
           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: Checking key[%s] string[%s]",
                                 cn,npp(tablekey),npp(tablestring));
           mod_gzip_printf( "%s: Call mod_gzip_validate1()...",cn);
           #endif

           field_ok =
           mod_gzip_validate1(
           (request_rec   *) r,
           (mod_gzip_conf *) dconf,
           NULL, /* r->filename     (Not used here) */
           NULL, /* r->uri          (Not used here) */
           NULL, /* r->content_type (Not used here) */
           NULL, /* r->handler      (Not used here) */
           (char *) tablekey,    /* (Field key    ) */
           (char *) tablestring, /* (Field string ) */
           MOD_GZIP_REQUEST      /* (Direction    ) */
           );

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: Back mod_gzip_validate1()...",cn);
           mod_gzip_printf( "%s: field_ok = %d",cn,field_ok);
           #endif

           if ( field_ok == MOD_GZIP_IMAP_DECLINED1 )
             {
              #ifdef MOD_GZIP_USES_APACHE_LOGS
              ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:REQ_HEADER_FIELD_EXCLUDED"));
              #endif

              #ifdef MOD_GZIP_DEBUG1
              mod_gzip_printf( "%s: This request is EXCLUDED...",cn);
              mod_gzip_printf( "%s: Exit > return( DECLINED ) >", cn);
              #endif

              return DECLINED;
             }
          }
       }
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: NO CHECK required on inbound REQUEST header fields...", cn );
    #endif
   }
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: 1 ***: r->uri         =[%s]", cn, npp(r->uri ));
 mod_gzip_printf( "%s: 1 ***: r->unparsed_uri=[%s]", cn, npp(r->unparsed_uri ));
 mod_gzip_printf( "%s: 1 ***: r->filename    =[%s]", cn, npp(r->filename ));
 mod_gzip_printf( "%s: 1 ***: r->content_type=[%s]", cn, npp(r->content_type ));
 mod_gzip_printf( "%s: 1 ***: r->handler     =[%s]", cn, npp(r->handler ));
 #endif

 if ( !r->content_type )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'r->content_type' is NULL...",cn);
    mod_gzip_printf( "%s: Performing 'quick lookup'...",cn);
    mod_gzip_printf( "%s: Call mod_gzip_run_handlers(r,RUN_TYPE_CHECKERS)...",cn);
    #endif

    rc = mod_gzip_run_handlers( r, MOD_GZIP_RUN_TYPE_CHECKERS );

    #ifdef MOD_GZIP_DEBUG1

    mod_gzip_printf( "%s: Back mod_gzip_run_handlers(r,RUN_TYPE_CHECKERS)...",cn);

    if ( rc == OK )
      {
       mod_gzip_printf( "%s: rc = %d = OK",cn, rc );
      }
    else if ( rc == DECLINED )
      {
       mod_gzip_printf( "%s: rc = %d = DECLINED",cn, rc );
      }
    else if ( rc == DONE )
      {
       mod_gzip_printf( "%s: rc = %d = DONE",cn, rc );
      }
    else
      {
       mod_gzip_printf( "%s: rc = %d = HTTP_ERROR?",cn, rc );
      }

    #endif
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: 'r->content_type' is VALID already...",cn);
    mod_gzip_printf( "%s: No 'quick lookup' was performed...",cn);
   }
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: 2 ***: r->uri         =[%s]", cn, npp(r->uri ));
 mod_gzip_printf( "%s: 2 ***: r->unparsed_uri=[%s]", cn, npp(r->unparsed_uri ));
 mod_gzip_printf( "%s: 2 ***: r->filename    =[%s]", cn, npp(r->filename ));
 mod_gzip_printf( "%s: 2 ***: r->content_type=[%s]", cn, npp(r->content_type ));
 mod_gzip_printf( "%s: 2 ***: r->handler     =[%s]", cn, npp(r->handler ));
 mod_gzip_printf( "%s: Call mod_gzip_validate1()...",cn);
 #endif

 action_flag =
 mod_gzip_validate1(
 (request_rec   *) r,
 (mod_gzip_conf *) dconf,
 (char *) r->filename,
 (char *) r->uri,
 (char *) r->content_type,
 (char *) r->handler,
 NULL, /* Field key    (Not used here) */
 NULL, /* Field string (Not used here) */
 0     /* Direction    (Not used here) */
 );

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: Back mod_gzip_validate1()...",cn);
 mod_gzip_printf( "%s: action_flag  = %d",cn,action_flag);

 if ( action_flag == MOD_GZIP_IMAP_DYNAMIC1 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_DYNAMIC1",cn);
   }
 else if ( action_flag == MOD_GZIP_IMAP_DYNAMIC2 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_DYNAMIC2",cn);
   }
 else if ( action_flag == MOD_GZIP_IMAP_STATIC1 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_STATIC1",cn);
   }
 else if ( action_flag == MOD_GZIP_IMAP_DECLINED1 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_DECLINED1",cn);
   }
 else
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_??? Unknown action",cn);
   }

 #endif

 if ( action_flag != MOD_GZIP_IMAP_DECLINED1 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: This transaction is a valid candidate...",cn);
    mod_gzip_printf( "%s: Saving current r->handler value [%s] to mod_gzip_r_handler note...",
                      cn, npp(r->handler) );
    #endif

    if ( r->handler )
      {
       ap_table_setn( r->notes,"mod_gzip_r_handler",ap_pstrdup(r->pool,r->handler));
      }
    else
      {
       ap_table_setn( r->notes,"mod_gzip_r_handler",ap_pstrdup(r->pool,"0"));
      }

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Forcing r->handler to be 'mod_gzip_handler'...", cn );
    #endif

    r->handler = "mod_gzip_handler";

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->handler is now = [%s]", cn, npp(r->handler) );
    mod_gzip_printf( "%s: Exit > return( OK ) >", cn );
    mod_gzip_printf( " " );
    #endif

    return OK;
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: This transaction is NOT a valid candidate...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:EXCLUDED"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >", cn );
    mod_gzip_printf( " " );
    #endif

    return DECLINED;
   }
}

#ifdef MOD_GZIP_COMMAND_VERSION_USED

int mod_gzip_do_command(
int            this_command, /* MOD_GZIP_COMMAND_XXXX */
request_rec   *r,            /* Request record */
mod_gzip_conf *dconf         /* Directory config pointer */
)
{
 /* Generic command response transmitter... */

 char tmpbuf[2048]; /* Fill/flush as needed. Don't overflow */
 char *tmp=tmpbuf;
 int  tmplen=0;
 char s1[90];

 #ifdef USE_MOD_GZIP_DEBUG1
 char cn[]="mod_gzip.c: mod_gzip_send_html_command_response()";
 #endif

 /* Start... */

 if ( this_command == MOD_GZIP_COMMAND_VERSION )
   {
    mod_gzip_strcpy(s1,"No");

    if ( dconf )
      {
       if ( dconf->is_on == 1 ) mod_gzip_strcpy(s1,"Yes");
      }

    sprintf( tmp,
    "<html><head><title>mod_gzip status</title></head><body>"
    "mod_gzip is available...<br>\r\n"
    "mod_gzip_version = %s<br>\r\n"
    "mod_gzip_on = %s<br>\r\n"
    "</body></html>",
    mod_gzip_version,
    s1
    );

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"COMMAND:VERSION"));
    #endif
   }
 else
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:INVALID_COMMAND"));
    #endif

    return( DECLINED );
   }

 /* Add the length of the response to the output header... */
 /* The third parameter to ap_table_set() MUST be a string. */

 tmplen = strlen( tmp );

 sprintf( s1, "%d", tmplen );

 ap_table_set( r->headers_out, "Content-Length", s1 );

 /* Make sure the content type matches this response... */

 r->content_type = "text/html";

 /* Start a timer for this return trip... */

 ap_soft_timeout( "mod_gzip: mod_gzip_do_command", r );

 #ifdef MOD_GZIP_COMMANDS_USE_LAST_MODIFIED

 /* Set the 'Last modified' stamp to current time/date... */

 ap_set_last_modified(r);

 /* TODO? Add 'no-cache' option(s) to mod_gzip command responses */
 /* so user doesn't have hit reload to get fresh data? This might */
 /* be necessary for static files that are subject to an Apache */
 /* lookup but mod_gzip command results as sent 'fresh' each */
 /* time no matter what so there doesn't seem to be a need for */
 /* any 'Last modified' information. Just pump a 200 + data and */
 /* then turn and burn... */

 #endif /* MOD_GZIP_COMMANDS_USE_LAST_MODIFIED */

 /* Send the HTTP response header... */

 ap_send_http_header(r);

 /* Send the response BODY... */

 ap_send_mmap( tmp, r, 0, tmplen );

 /* Clean up and exit... */

 ap_kill_timeout(r);

 return OK;

}/* End of mod_gzip_send_html_command_response() */

#endif /* MOD_GZIP_COMMAND_VERSION_USED */


static int mod_gzip_handler( request_rec *r )
{
 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_handler()";
 #endif

 int  rc = DECLINED;
 int  action_flag = 0;

 request_rec *r__next=0;

 mod_gzip_conf *sconf = 0;
 mod_gzip_conf *dconf = 0;

 const char *tablestring;

 const char *s1;
 const char *s2;
 const char *s3;
 const char *s4;

 #ifdef MOD_GZIP_CAN_NEGOTIATE
 struct stat statbuf;
 struct stat statbuf1;
 char  *new_uri;
 char  *new_name;
 int precompressed_send_ok = 1;
 #endif

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_server_now = r->server;

 mod_gzip_printf( " " );

 mod_gzip_printf( "%s: ''''Entry...",cn);
 mod_gzip_printf( "%s: r               = %ld", cn,(long)r);
 mod_gzip_printf( "%s: r->main         = %ld", cn,(long)r->main);
 mod_gzip_printf( "%s: r->next         = %ld", cn,(long)r->next);
 mod_gzip_printf( "%s: r->prev         = %ld", cn,(long)r->prev);
 mod_gzip_printf( "%s: r->unparsed_uri = [%s]",cn,npp(r->unparsed_uri));
 mod_gzip_printf( "%s: r->uri          = [%s]",cn,npp(r->uri));
 mod_gzip_printf( "%s: r->filename     = [%s]",cn,npp(r->filename));
 mod_gzip_printf( "%s: r->handler      = [%s]",cn,npp(r->handler));

 #endif

 if ( r->main ) /* SUBREQUEST */
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->main is TRUE - This is a subrequest...",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: r->main is FALSE",cn);
    mod_gzip_printf( "%s: This is NOT a subrequest in progress...",cn);
    mod_gzip_printf( "%s: OK to continue...",cn);
   }
 #endif

 if ( r->prev ) /* REDIRECT */
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->prev is TRUE - This is a redirection...",cn);
    #endif

    /* This might be a 'directory' index lookup... */

    tablestring = ap_table_get(r->prev->notes, "mod_gzip_running");

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->prev->notes->mod_gzip_running = [%s]",
                      cn,npp(tablestring));
    #endif

    if ( tablestring )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: 'mod_gzip_running' note FOUND",cn);
       #endif

       if ( *tablestring == '1' )
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: 'mod_gzip_running' note value is '1'...",cn);
          #endif

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: ************************************************",cn);
          mod_gzip_printf( "%s: mod_gzip is currently 'running' so we ",cn);
          mod_gzip_printf( "%s: must return DECLINED.",cn);
          mod_gzip_printf( "%s: ************************************************",cn);
          mod_gzip_printf( "%s: IMPORTANT: We must now 'replicate' the note flag",cn);
          mod_gzip_printf( "%s: on this record or next time around r->prev",cn);
          mod_gzip_printf( "%s: note flag check will be FALSE.",cn);
          mod_gzip_printf( "%s: ************************************************",cn);
          #endif

          ap_table_setn(r->notes,"mod_gzip_running",ap_pstrdup(r->pool,"1"));

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: r->notes 'mod_gzip_running' set with value = '1'",cn);
          mod_gzip_printf( "%s: ************************************************",cn);
          #endif

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
          #endif

          return DECLINED;
         }
       #ifdef MOD_GZIP_DEBUG1
       else
         {
          mod_gzip_printf( "%s: 'mod_gzip_running' note value is NOT '1'...",cn);
         }
       #endif
      }
    #ifdef MOD_GZIP_DEBUG1
    else
      {
       mod_gzip_printf( "%s: 'mod_gzip_running' note NOT FOUND",cn);
      }
    #endif
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: r->prev is FALSE",cn);
    mod_gzip_printf( "%s: This is NOT a redirection in progress...",cn);
    mod_gzip_printf( "%s: OK to continue...",cn);
   }
 #endif

 sconf = ( mod_gzip_conf * )
 ap_get_module_config( r->server->module_config, &gzip_module );

 dconf = ( mod_gzip_conf * )
 ap_get_module_config( r->per_dir_config, &gzip_module );


 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf("%s: i'm going to check r->filename",cn);
 #endif

 if(r->filename) {
   #ifdef MOD_GZIP_DEBUG1
   mod_gzip_printf("%s: suffix is %s, filename is %s",cn,dconf->suffix,r->filename);
   #endif

   if(mod_gzip_strendswith(r->filename, dconf->suffix, 1)) {
     #ifdef MOD_GZIP_USES_APACHE_LOGS
     if(r->prev) {
       /* This is a mod_gzip negotiated .gz static file transmit... */
       const char *t = ap_table_get(r->prev->notes,"mod_gzip_result_n");
       ap_table_setn(r->notes,"mod_gzip_result",ap_pstrdup(r->pool,t ? t : "DECLINED:STATIC_GZ_FOUND"));
     }
     else {
       /* This is a direct request from client for a .gz file... */
       ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:FEXT_GZ"));
     }
     #endif

     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: r->filename ends with '%s'...",dconf->suffix);
     mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
     #endif

     return DECLINED;
   }
   #ifdef MOD_GZIP_DEBUG1
   else {
     mod_gzip_printf( "%s: r->filename does NOT end with '%s'...",cn,dconf->suffix);
     mod_gzip_printf( "%s: OK to continue...",cn);
   }
   #endif
 }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->server->server_hostname = [%s]", cn,npp(r->server->server_hostname));
 mod_gzip_printf( "%s: sconf        = %ld", cn,(long)sconf);
 mod_gzip_printf( "%s: sconf->loc   = [%s]",cn,npp(sconf->loc));
 mod_gzip_printf( "%s: sconf->is_on = %ld", cn,(long)sconf->is_on);
 mod_gzip_printf( "%s: dconf        = %ld", cn,(long)dconf);
 mod_gzip_printf( "%s: dconf->loc   = [%s]",cn,npp(dconf->loc));
 mod_gzip_printf( "%s: dconf->is_on = %ld", cn,(long)dconf->is_on);
 #endif

 #ifdef MOD_GZIP_COMMAND_VERSION_USED

 /* NOTE: Certain mod_gzip 'commands' should return a response */
 /* even if mod_gzip is OFF in the current location. Make sure */
 /* the checks for these commands take place BEFORE checking */
 /* the actual mod_gzip on/off status... */

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf->command_version = [%s]",cn,npp(dconf->command_version));
 #endif

 /* Check for mod_gzip commands in the 'r->unparsed_uri' request */
 /* line so the commands can actually be part of query parms that */
 /* follow the '?'. 'r->uri' is simply he URI itself with any/all */
 /* additional query arguments removed already... */

 if ( dconf->command_version[0] != 0 )
   {
    if ( mod_gzip_stringcontains(r->unparsed_uri,dconf->command_version))
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Call mod_gzip_do_command( MOD_GZIP_COMMAND_VERSION, r )...",cn);
       #endif

       /* mod_gzip_do_command() returns the correct command */
       /* response page and (normally) just returns 'OK'... */

       return(
       mod_gzip_do_command(
       MOD_GZIP_COMMAND_VERSION,
       r,
       dconf
       ));
      }
   }

 #endif /* MOD_GZIP_COMMAND_VERSION_USED */

 tablestring = ap_table_get(r->notes, "mod_gzip_r_handler");

 if ( !tablestring )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: r->notes->mod_gzip_r_handler = NOT FOUND",cn);
    mod_gzip_printf( "%s: This transaction will be ignored...",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->notes->mod_gzip_r_handler = FOUND",cn);
 mod_gzip_printf( "%s: r->notes->mod_gzip_r_handler = [%s]",cn,npp(tablestring));
 #endif

 #ifdef MOD_GZIP_USES_APACHE_LOGS
 ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"INIT2"));
 #endif

 if ( !dconf->is_on )
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:OFF2"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'dconf->is_on' is FALSE",cn);
    mod_gzip_printf( "%s: mod_gzip is not turned ON for this location...",cn);
    mod_gzip_printf( "%s: This transaction will be ignored...",cn);
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 if ( *tablestring == '0' )
   {
    r->handler = 0;
   }
 else
   {
    r->handler = tablestring;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->handler set back to = [%s]",cn,npp(r->handler));
 #endif

 /* Verify it (again) in case names have changed... */

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call mod_gzip_validate1()...",cn);
 #endif

 action_flag =
 mod_gzip_validate1(
 (request_rec   *) r,
 (mod_gzip_conf *) dconf,
 (char *) r->filename,
 (char *) r->uri,
 (char *) r->content_type,
 (char *) r->handler,
 NULL, /* Field key    (Not used here  */
 NULL, /* Field string (Not used here) */
 0     /* Direction    (Not used here) */
 );

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: Back mod_gzip_validate1()...",cn);
 mod_gzip_printf( "%s: action_flag  = %d",cn,action_flag);

 if ( action_flag == MOD_GZIP_IMAP_DYNAMIC1 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_DYNAMIC1",cn);
   }
 else if ( action_flag == MOD_GZIP_IMAP_DYNAMIC2 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_DYNAMIC2",cn);
   }
 else if ( action_flag == MOD_GZIP_IMAP_STATIC1 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_STATIC1",cn);
   }
 else if ( action_flag == MOD_GZIP_IMAP_DECLINED1 )
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_DECLINED1",cn);
   }
 else
   {
    mod_gzip_printf( "%s: action_flag  = MOD_GZIP_IMAP_??? Unknown action",cn);
   }

 #endif

 if ( action_flag == MOD_GZIP_IMAP_DECLINED1 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: This transaction is NOT a valid candidate...",cn);
    mod_gzip_printf( "%s: This transaction will be ignored...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:EXCLUDED_BY_HANDLER"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: This transaction is a valid candidate...",cn);
 #endif

 #ifdef MOD_GZIP_CAN_NEGOTIATE

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf->can_negotiate = %d",cn,(int)dconf->can_negotiate);
 #endif

 if ( dconf->can_negotiate == 1 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: dconf->can_negotiate is TRUE...",cn);
    #endif

    /* Check for a static compressed version of the file requested... */

    new_name = ap_pstrcat(r->pool, r->filename, dconf->suffix, NULL);

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call stat(new_name=[%s])...",cn,npp(new_name));
    #endif

    if ( stat( new_name, &statbuf) != 0 )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: .... stat() call FAILED",cn);
       mod_gzip_printf( "%s: OK to continue...",cn);
       #endif
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: .... stat() call SUCCEEDED",cn);
       #endif
       if(stat(r->filename,&statbuf1) == 0) {
         /*
          * create a new precompressed version
          */
         if(!(statbuf1.st_atime <= statbuf.st_atime || statbuf1.st_mtime <= statbuf.st_mtime)) {
           if(dconf->refresh_files) {
             precompressed_send_ok = mod_gzip_compress_file(r,new_name);
           }
           else {
             #ifdef MOD_GZIP_USES_APACHE_LOGS
             ap_table_setn(r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"SEND_AS_IS:FOPEN_FAILED"));
             #endif

             return DECLINED;
           }
         }

         if(precompressed_send_ok) {
           #ifdef MOD_GZIP_DEBUG
           mod_gzip_printf( "%s: Sending precompressed version of file...",cn);
           mod_gzip_printf( "%s: GZ_REDIRECT: START...",cn);
           #endif

           new_name = ap_pstrcat(r->pool, r->uri, dconf->suffix, NULL);

           if( r->args != NULL ) {
             new_uri = ap_pstrcat(r->pool, new_name, "?", r->args, NULL);
           }
           else {
             new_uri = ap_pstrdup(r->pool, new_name);
           }

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: Call ap_internal_redirect(new_uri=[%s])...",
                             cn,npp(new_uri));
           mod_gzip_printf( " " );
           #endif

           ap_internal_redirect(new_uri, r);

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( " " );
           mod_gzip_printf( "%s: Back ap_internal_redirect(new_uri=[%s])...",
                             cn,npp(new_uri));
           mod_gzip_printf( "%s: GZ_REDIRECT: FINISHED...",cn);
           #endif

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: Exit > return( OK ) >",cn);
           #endif

           /* We are about to return OK to end the transaction but go */
           /* ahead and make the mod_gzip final result a DECLINED */
           /* condition since that's what actually happened... */
           
           #ifdef MOD_GZIP_USES_APACHE_LOGS
           ap_table_setn(r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:STATIC_GZ_FOUND"));
           #endif

           return OK;
         }
         else {
           #ifdef MOD_GZIP_USES_APACHE_LOGS
           ap_table_setn(r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"SEND_AS_IS:PRECOMPRESSED_VARIANT_OUTDATED"));
           #endif

           return DECLINED;
         }
       }
      }
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: dconf->can_negotiate is FALSE",cn);
   }
 #endif

 #endif /* MOD_GZIP_CAN_NEGOTIATE */

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call mod_gzip_redir1_handler( r, dconf )...",cn);
 #endif

 rc = (int) mod_gzip_redir1_handler( r, dconf );

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: Back mod_gzip_redir1_handler( r, dconf )...",cn);

 if ( rc == OK )
   {
    mod_gzip_printf( "%s: rc = %d OK", cn, (int) rc);
   }
 else if ( rc == DECLINED )
   {
    mod_gzip_printf( "%s: rc = %d DECLINED", cn, (int) rc );
   }
 else
   {
    mod_gzip_printf( "%s: rc = %d ( HTTP ERROR CODE? )", cn, (int) rc );
   }

 #endif

 if ( rc != OK )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: mod_gzip_redir1_handler() call FAILED...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    ap_table_setn(
    r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"RECOVERY"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_WARNING, r->server,
    "mod_gzip: RECOVERY [%s]", r->the_request );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: RECOVERY_REDIRECT: START...",cn);
    mod_gzip_printf( "%s: Call ap_internal_redirect(r->unparsed_uri=[%s])...",
                      cn,npp(r->unparsed_uri));
    mod_gzip_printf( " " );
    #endif

    ap_internal_redirect( r->unparsed_uri, r );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( " " );
    mod_gzip_printf( "%s: Back ap_internal_redirect(r->unparsed_uri=[%s])...",
                      cn,npp(r->unparsed_uri));
    mod_gzip_printf( "%s: RECOVERY_REDIRECT: FINISHED...",cn);
    #endif

    rc = OK;
   }

 #ifdef MOD_GZIP_USES_APACHE_LOGS

 if ( r->next )
   {
    r__next = r->next;

    s1 = ap_table_get( r->notes, "mod_gzip_result" );
    s2 = ap_table_get( r->notes, "mod_gzip_input_size" );
    s3 = ap_table_get( r->notes, "mod_gzip_output_size" );
    s4 = ap_table_get( r->notes, "mod_gzip_compression_ratio" );

    while( r__next )
      {
       if ( s1 ) ap_table_setn( r__next->notes,"mod_gzip_result",ap_pstrdup(r__next->pool,s1));
       if ( s2 ) ap_table_setn( r__next->notes,"mod_gzip_input_size",ap_pstrdup(r__next->pool,s2));
       if ( s3 ) ap_table_setn( r__next->notes,"mod_gzip_output_size",ap_pstrdup(r__next->pool,s3));
       if ( s4 ) ap_table_setn( r__next->notes,"mod_gzip_compression_ratio",ap_pstrdup(r__next->pool,s4));

       r__next = r__next->next;
      }
   }

 #endif

 #ifdef MOD_GZIP_DEBUG1
 #ifdef MOD_GZIP_DEBUG1_SHOW_REQUEST_RECORD2
 mod_gzip_show_request_record( r, cn );
 #endif
 #endif

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: 1 r->connection->client->outcnt     = %ld",
                   cn,   r->connection->client->outcnt );
 mod_gzip_printf( "%s: 1 r->connection->client->bytes_sent = %ld",
                   cn,   r->connection->client->bytes_sent );
 mod_gzip_printf( "%s: 1 Sum of the 2......................= %ld",
                   cn,   r->connection->client->outcnt +
                         r->connection->client->bytes_sent );
 if ( rc == OK )
   {
    mod_gzip_printf( "%s: Exit > return ( rc = %d OK ) >",cn,(int)rc);
   }
 else if ( rc == DECLINED )
   {
    mod_gzip_printf( "%s: Exit > return ( rc = %d DECLINED ) >",cn,(int)rc);
   }
 else
   {
    mod_gzip_printf( "%s: Exit > return ( rc = %d HTTP_ERROR ) >",cn,(int)rc);
   }

 #endif

 return rc;
}

int mod_gzip_set_defaults1( mod_gzip_conf *cfg )
{
 int i;

 cfg->is_on                  = 0;    
 cfg->is_on_set              = 0;

 cfg->keep_workfiles         = 0;    
 cfg->keep_workfiles_set     = 0;

 cfg->add_header_count       = 0;    
 cfg->add_header_count_set   = 0;

 cfg->dechunk                = 0;    
 cfg->dechunk_set            = 0;

 cfg->min_http               = 0;    
 cfg->min_http_set           = 0;

 cfg->minimum_file_size      = 300;  
 cfg->minimum_file_size_set  = 0;

 cfg->maximum_file_size      = 0;    
 cfg->maximum_file_size_set  = 0;

 cfg->maximum_inmem_size     = 0;    
 cfg->maximum_inmem_size_set = 0;

 #ifdef WIN32
 mod_gzip_strcpy( cfg->temp_dir, "c:\\temp\\" );
 #else
 mod_gzip_strcpy( cfg->temp_dir, "/tmp/" );
 #endif
 cfg->temp_dir_set           = 0;

 cfg->imap_total_entries     = 0;
 cfg->imap_total_ismime      = 0;
 cfg->imap_total_isfile      = 0;
 cfg->imap_total_isuri       = 0;
 cfg->imap_total_ishandler   = 0;
 cfg->imap_total_isreqheader = 0;
 cfg->imap_total_isrspheader = 0;

 for ( i=0; i<MOD_GZIP_IMAP_MAXNAMES; i++ )
    {
     memset( &(cfg->imap[i]), 0, mod_gzip_imap_size );
    }

 #ifdef MOD_GZIP_COMMAND_VERSION_USED
 memset(
 cfg->command_version, 0, MOD_GZIP_COMMAND_VERSION_MAXLEN );
 cfg->command_version_set = 0;
 #endif

 #ifdef MOD_GZIP_CAN_NEGOTIATE
 cfg->can_negotiate     = 0;
 cfg->can_negotiate_set = 0;
 #endif

 cfg->handle_methods    = MOD_GZIP_M_NOT_SET;

 strcpy(cfg->suffix,".gz");
 cfg->suffix_set = 0;

 cfg->send_vary     = 1;
 cfg->send_vary_set = 0;

 cfg->refresh_files     = 0;
 cfg->refresh_files_set = 0;

 return 0;
}

#ifdef REFERENCE
static void *mod_gzip_merge_dconfig(
pool *p,
void *parent_conf,
void *newloc_conf
)
{
 mod_gzip_conf *merged_config = (mod_gzip_conf *) ap_pcalloc(p, sizeof(mod_gzip_conf));
 mod_gzip_conf *pconf         = (mod_gzip_conf *) parent_conf;
 mod_gzip_conf *nconf         = (mod_gzip_conf *) newloc_conf;

 mod_gzip_merge1(
 ( pool          * ) p,
 ( mod_gzip_conf * ) merged_config,
 ( mod_gzip_conf * ) pconf,
 ( mod_gzip_conf * ) nconf
 );

 return (void *) merged_config;
}
#endif

int mod_gzip_merge1(
pool          *p,
mod_gzip_conf *merged_config,
mod_gzip_conf *pconf,
mod_gzip_conf *nconf )
{
 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_merge1():::::::";
 char ch1 = 0; 
 #endif

 char *p1    = 0; 
 char *p2    = 0; 
 int   i     = 0; 
 int   ii    = 0; 
 int   l1    = 0; 
 int   l2    = 0; 
 int   match = 0; 

 int   total             = 0; 
 int   total_ismime      = 0;
 int   total_isfile      = 0;
 int   total_isuri       = 0;
 int   total_ishandler   = 0;
 int   total_isreqheader = 0;
 int   total_isrspheader = 0;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: ",cn); 
 #endif

 #ifdef MOD_GZIP_DEBUG1

 if ( nconf->is_on_set ) 
   {
    merged_config->is_on = nconf->is_on;

    ch1='!'; 
   }
 else 
   {
    merged_config->is_on = pconf->is_on;

    ch1='='; 
   }

 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->is_on              = %ld", cn, ch1, (long) merged_config->is_on );

 #else 

 merged_config->is_on =
 ( nconf->is_on_set) ? nconf->is_on : pconf->is_on;

 #endif 

 #ifdef MOD_GZIP_DEBUG1

 if ( pconf->cmode == nconf->cmode )
   {
    merged_config->cmode = pconf->cmode;

    ch1='='; 
   }
 else 
   {
    merged_config->cmode = MOD_GZIP_CONFIG_MODE_COMBO;

    ch1='!'; 
   }

 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->cmode              = %ld", cn, ch1, (long) merged_config->cmode );

 #else 

 merged_config->cmode =
 (pconf->cmode == nconf->cmode) ? pconf->cmode : MOD_GZIP_CONFIG_MODE_COMBO;

 #endif 

 merged_config->loc = ap_pstrdup( p, nconf->loc );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: .............. : merged_config->loc                = [%s]", cn, npp(merged_config->loc));
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->add_header_count_set ) 
      { merged_config->add_header_count = pconf->add_header_count; ch1='='; }
 else { merged_config->add_header_count = nconf->add_header_count; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->add_header_count   = %ld", cn, ch1, (long) merged_config->add_header_count );
 #else
 merged_config->add_header_count = ( !nconf->add_header_count_set ) ? pconf->add_header_count : nconf->add_header_count;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->keep_workfiles_set ) 
      { merged_config->keep_workfiles = pconf->keep_workfiles; ch1='='; }
 else { merged_config->keep_workfiles = nconf->keep_workfiles; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->keep_workfiles     = %ld", cn, ch1, (long) merged_config->keep_workfiles );
 #else
 merged_config->keep_workfiles = ( !nconf->keep_workfiles_set ) ? pconf->keep_workfiles : nconf->keep_workfiles;
 #endif

 #ifdef MOD_GZIP_CAN_NEGOTIATE
 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->can_negotiate_set )
      { merged_config->can_negotiate = pconf->can_negotiate; ch1='='; }
 else { merged_config->can_negotiate = nconf->can_negotiate; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->can_negotiate      = %ld", cn, ch1, (long) merged_config->can_negotiate );
 #else
 merged_config->can_negotiate = ( !nconf->can_negotiate_set ) ? pconf->can_negotiate : nconf->can_negotiate;
 #endif
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->dechunk_set ) 
      { merged_config->dechunk = pconf->dechunk; ch1='='; }
 else { merged_config->dechunk = nconf->dechunk; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->dechunk            = %ld", cn, ch1, (long) merged_config->dechunk );
 #else
 merged_config->dechunk = ( !nconf->dechunk_set ) ? pconf->dechunk : nconf->dechunk;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->min_http_set ) 
      { merged_config->min_http = pconf->min_http; ch1='='; }
 else { merged_config->min_http = nconf->min_http; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->min_http           = %ld", cn, ch1, (long) merged_config->min_http );
 #else
 merged_config->min_http = ( !nconf->min_http_set ) ? pconf->min_http : nconf->min_http;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->minimum_file_size_set ) 
      { merged_config->minimum_file_size = pconf->minimum_file_size; ch1='='; }
 else { merged_config->minimum_file_size = nconf->minimum_file_size; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->minimum_file_size  = %ld", cn, ch1, (long) merged_config->minimum_file_size );
 #else
 merged_config->minimum_file_size = ( !nconf->minimum_file_size_set ) ? pconf->minimum_file_size : nconf->minimum_file_size;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->maximum_file_size_set ) 
      { merged_config->maximum_file_size = pconf->maximum_file_size; ch1='='; }
 else { merged_config->maximum_file_size = nconf->maximum_file_size; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->maximum_file_size  = %ld", cn, ch1, (long) merged_config->maximum_file_size );
 #else
 merged_config->maximum_file_size = ( !nconf->maximum_file_size_set ) ? pconf->maximum_file_size : nconf->maximum_file_size;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->maximum_inmem_size_set ) 
      { merged_config->maximum_inmem_size = pconf->maximum_inmem_size; ch1='='; }
 else { merged_config->maximum_inmem_size = nconf->maximum_inmem_size; ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->maximum_inmem_size = %ld", cn, ch1, (long) merged_config->maximum_inmem_size );
 #else
 merged_config->maximum_inmem_size = ( !nconf->maximum_inmem_size_set ) ? pconf->maximum_inmem_size : nconf->maximum_inmem_size;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->temp_dir_set ) 
      { mod_gzip_strcpy(merged_config->temp_dir,pconf->temp_dir); ch1='='; }
 else { mod_gzip_strcpy(merged_config->temp_dir,nconf->temp_dir); ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->temp_dir           = [%s]", cn, ch1,npp(merged_config->temp_dir));
 #else
 if ( !nconf->temp_dir_set ) 
      { mod_gzip_strcpy(merged_config->temp_dir,pconf->temp_dir); }
 else { mod_gzip_strcpy(merged_config->temp_dir,nconf->temp_dir); }
 #endif

 #ifdef MOD_GZIP_COMMAND_VERSION_USED
 #ifdef MOD_GZIP_DEBUG1
 if ( !nconf->command_version_set )
      { mod_gzip_strcpy(merged_config->command_version,pconf->command_version); ch1='='; }
 else { mod_gzip_strcpy(merged_config->command_version,nconf->command_version); ch1='!'; }
 mod_gzip_printf( "%s: pconf %c= nconf : merged_config->command_version    = [%s]", cn, ch1,npp(merged_config->command_version));
 #else
 if ( !nconf->command_version_set )
      { mod_gzip_strcpy(merged_config->command_version,pconf->command_version); }
 else { mod_gzip_strcpy(merged_config->command_version,nconf->command_version); }
 #endif
 #endif

 total = 0; 

 /*
  * new config overrides old config
  */
 if(nconf->handle_methods == MOD_GZIP_M_NOT_SET) {
   merged_config->handle_methods = pconf->handle_methods;
 }
 else {
   merged_config->handle_methods = nconf->handle_methods;
 }

 if(!nconf->suffix_set) {
   mod_gzip_strcpy(merged_config->suffix,pconf->suffix);
 }
 else {
   mod_gzip_strcpy(merged_config->suffix,nconf->suffix);
   merged_config->suffix_set = 1;
 }

 if(!nconf->send_vary_set) {
   merged_config->send_vary = pconf->send_vary;
 }
 else {
   merged_config->send_vary     = nconf->send_vary;
   merged_config->send_vary_set = 1;
 }

 if(!nconf->refresh_files_set) {
   merged_config->refresh_files = pconf->refresh_files;
 }
 else {
   merged_config->refresh_files     = nconf->refresh_files;
   merged_config->refresh_files_set = 1;
 }

 for ( i=0; i<nconf->imap_total_entries; i++ )
    {
     memcpy(
     &(merged_config->imap[i]),
     &(nconf->imap[i]),
     mod_gzip_imap_size
     );

     total++; 

     if ( nconf->imap[i].type == MOD_GZIP_IMAP_ISMIME )
       {
        total_ismime++;
       }
     else if ( nconf->imap[i].type == MOD_GZIP_IMAP_ISFILE )
       {
        total_isfile++;
       }
     else if ( nconf->imap[i].type == MOD_GZIP_IMAP_ISURI )
       {
        total_isuri++;
       }
     else if ( nconf->imap[i].type == MOD_GZIP_IMAP_ISHANDLER )
       {
        total_ishandler++;
       }
     else if ( nconf->imap[i].type == MOD_GZIP_IMAP_ISREQHEADER )
       {
        total_isreqheader++;
       }
     else if ( nconf->imap[i].type == MOD_GZIP_IMAP_ISRSPHEADER )
       {
        total_isrspheader++;
       }
    }

 for ( i=0; i<pconf->imap_total_entries; i++ )
    {
     p1 = pconf->imap[i].name;
     l1 = mod_gzip_strlen( p1 );

     match = -1; 

     for ( ii=0; ii<nconf->imap_total_entries; ii++ )
        {
         p2 = nconf->imap[ii].name;
         l2 = nconf->imap[ii].namelen;

         if ( l1 == l2 ) 
           {
            if ( mod_gzip_strncmp( p1, p2, l1 ) == 0 )
              {
               match = ii; 

               break; 
              }
           }
        }

     if ( match != -1 )
       {
       }
     else 
       {
        if ( total < MOD_GZIP_IMAP_MAXNAMES ) 
          {
           memcpy(
           &(merged_config->imap[ total ]),
           &(pconf->imap[i]),
           mod_gzip_imap_size
           );

           total++; 

           if ( pconf->imap[i].type == MOD_GZIP_IMAP_ISMIME )
             {
              total_ismime++;
             }
           else if ( pconf->imap[i].type == MOD_GZIP_IMAP_ISFILE )
             {
              total_isfile++;
             }
           else if ( pconf->imap[i].type == MOD_GZIP_IMAP_ISURI )
             {
              total_isuri++;
             }
           else if ( pconf->imap[i].type == MOD_GZIP_IMAP_ISHANDLER )
             {
              total_ishandler++;
             }
           else if ( pconf->imap[i].type == MOD_GZIP_IMAP_ISREQHEADER )
             {
              total_isreqheader++;
             }
           else if ( pconf->imap[i].type == MOD_GZIP_IMAP_ISRSPHEADER )
             {
              total_isrspheader++;
             }
          }
       }
    }

 merged_config->imap_total_entries     = total;
 merged_config->imap_total_ismime      = total_ismime;
 merged_config->imap_total_isfile      = total_isfile;
 merged_config->imap_total_isuri       = total_isuri;
 merged_config->imap_total_ishandler   = total_ishandler;
 merged_config->imap_total_isreqheader = total_isreqheader;
 merged_config->imap_total_isrspheader = total_isrspheader;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: pconf += nconf : merged_config->imap_total_entries     = %ld", cn, (long) merged_config->imap_total_entries );
 mod_gzip_printf( "%s: pconf += nconf : merged_config->imap_total_ismime      = %ld", cn, (long) merged_config->imap_total_ismime );
 mod_gzip_printf( "%s: pconf += nconf : merged_config->imap_total_isfile      = %ld", cn, (long) merged_config->imap_total_isfile );
 mod_gzip_printf( "%s: pconf += nconf : merged_config->imap_total_isuri       = %ld", cn, (long) merged_config->imap_total_isuri );
 mod_gzip_printf( "%s: pconf += nconf : merged_config->imap_total_ishandler   = %ld", cn, (long) merged_config->imap_total_ishandler );
 mod_gzip_printf( "%s: pconf += nconf : merged_config->imap_total_isreqheader = %ld", cn, (long) merged_config->imap_total_isreqheader );
 mod_gzip_printf( "%s: pconf += nconf : merged_config->imap_total_isrspheader = %ld", cn, (long) merged_config->imap_total_isrspheader );
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: ",cn); 
 #endif

 return 0;
}

static const char *
mod_gzip_set_is_on( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_is_on()";
 #endif

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_server_now = srv;

 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );

 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 #ifdef MOD_GZIP_ALTERNATIVE1

 mgc = ( mod_gzip_conf * )
 ap_get_module_config(parms->server->module_config, &gzip_module);
 #endif

 if ( ( arg[0] == 'Y' )||( arg[0] == 'y' ) )
   {
    mgc->is_on = 1;
   }
 else
   {
    mgc->is_on = 0;
   }

 mgc->is_on_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc             = [%s]", cn, npp(mgc->loc));
 mod_gzip_printf( "%s: srv->is_virtual      = %ld",  cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname = [%s]", cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->cmode           = %ld",  cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: mgc->is_on           = %ld",  cn, (long) mgc->is_on );
 mod_gzip_printf( "%s: mgc->is_on_set       = %ld",  cn, (long) mgc->is_on_set );
 #endif

 return NULL;
}

static const char *
mod_gzip_set_add_header_count( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_add_header_count()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 if ( ( arg[0] == 'Y' )||( arg[0] == 'y' ) )
   {
    mgc->add_header_count = 1;
   }
 else
   {
    mgc->add_header_count = 0;
   }

 mgc->add_header_count_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc                  = [%s]",cn, npp(mgc->loc));
 mod_gzip_printf( "%s: mgc->cmode                = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual           = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname      = [%s]",cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->add_header_count     = %ld", cn,
                (long) mgc->add_header_count );
 mod_gzip_printf( "%s: mgc->add_header_count_set = %ld", cn,
                (long) mgc->add_header_count_set );
 #endif

 return NULL;
}

static const char *
mod_gzip_set_keep_workfiles( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_keep_workfiles()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 if ( ( arg[0] == 'Y' )||( arg[0] == 'y' ) )
   {
    mgc->keep_workfiles = 1;
   }
 else
   {
    mgc->keep_workfiles = 0;
   }

 mgc->keep_workfiles_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc                = [%s]",cn, npp(mgc->loc) );
 mod_gzip_printf( "%s: mgc->cmode              = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual         = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname    = [%s]",cn, npp(srv->server_hostname) );
 mod_gzip_printf( "%s: mgc->keep_workfiles     = %ld", cn,
                (long) mgc->keep_workfiles );
 mod_gzip_printf( "%s: mgc->keep_workfiles_set = %ld", cn,
                (long) mgc->keep_workfiles_set );
 #endif

 return NULL;
}

#ifdef MOD_GZIP_CAN_NEGOTIATE
static const char *
mod_gzip_set_can_negotiate( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_can_negotiate()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 if ( ( arg[0] == 'Y' )||( arg[0] == 'y' ) )
   {
    mgc->can_negotiate = 1;
   }
 else
   {
    mgc->can_negotiate = 0;
   }

 mgc->can_negotiate_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc                = [%s]",cn, npp(mgc->loc) );
 mod_gzip_printf( "%s: mgc->cmode              = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual         = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname    = [%s]",cn, npp(srv->server_hostname) );
 mod_gzip_printf( "%s: mgc->can_negotiate      = %ld", cn,
                (long) mgc->can_negotiate );
 mod_gzip_printf( "%s: mgc->can_negotiate_set  = %ld", cn,
                (long) mgc->can_negotiate_set );
 #endif

 return NULL;
}
#endif

static const char *
mod_gzip_set_dechunk( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_dechunk()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 if ( ( arg[0] == 'Y' )||( arg[0] == 'y' ) )
   {
    mgc->dechunk = 1;
   }
 else
   {
    mgc->dechunk = 0;
   }

 mgc->dechunk_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc                = [%s]",cn, npp(mgc->loc) );
 mod_gzip_printf( "%s: mgc->cmode              = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual         = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname    = [%s]",cn, npp(srv->server_hostname) );
 mod_gzip_printf( "%s: mgc->dechunk            = %ld", cn,
                (long) mgc->dechunk );
 mod_gzip_printf( "%s: mgc->dechunk_set        = %ld", cn,
                (long) mgc->dechunk_set );
 #endif

 return NULL;
}

static const char *
mod_gzip_set_min_http( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_min_http()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 mgc->min_http     = (int) atoi( arg );
 mgc->min_http_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc             = [%s]",cn, npp(mgc->loc));
 mod_gzip_printf( "%s: mgc->cmode           = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual      = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname = [%s]",cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->min_http        = %ld", cn,
                (long) mgc->min_http );
 mod_gzip_printf( "%s: mgc->min_http        = %ld", cn,
                (long) mgc->min_http_set );
 #endif

 return NULL;
}

static const char *
mod_gzip_set_minimum_file_size( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_minimum_file_size()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg));
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 mgc->minimum_file_size     = (long) atol( arg );
 mgc->minimum_file_size_set = 1;

 if ( mgc->minimum_file_size < 300 )
   {
    mgc->minimum_file_size = 300;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc                = [%s]",cn, npp(mgc->loc));
 mod_gzip_printf( "%s: mgc->cmode              = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual         = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname    = [%s]",cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->minimum_file_size  = %ld", cn,
                (long) mgc->minimum_file_size );
 mod_gzip_printf( "%s: mgc->minimum_file_size  = %ld", cn,
                (long) mgc->minimum_file_size_set );
 #endif

 return NULL;
}

static const char *
mod_gzip_set_maximum_file_size( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_maximum_file_size()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg));
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 mgc->maximum_file_size     = (long) atol( arg );
 mgc->maximum_file_size_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc                = [%s]",cn, npp(mgc->loc));
 mod_gzip_printf( "%s: mgc->cmode              = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual         = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname    = [%s]",cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->maximum_file_size  = %ld", cn,
                (long) mgc->maximum_file_size );
 mod_gzip_printf( "%s: mgc->maximum_file_size  = %ld", cn,
                (long) mgc->maximum_file_size_set );
 #endif

 return NULL;
}

static const char *
mod_gzip_set_maximum_inmem_size( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_maximum_inmem_size()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 mgc->maximum_inmem_size     = (long) atol(arg);
 mgc->maximum_inmem_size_set = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc                = [%s]",cn, npp(mgc->loc));
 mod_gzip_printf( "%s: mgc->cmode              = %ld", cn, (long) mgc->cmode );
 mod_gzip_printf( "%s: srv->is_virtual         = %ld", cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname    = [%s]",cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->maximum_inmem_size = %ld", cn,
                (long) mgc->maximum_inmem_size );
 mod_gzip_printf( "%s: mgc->maximum_inmem_size = %ld", cn,
                (long) mgc->maximum_inmem_size_set );
 #endif

 return NULL;
}

static const char *
mod_gzip_set_temp_dir( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_temp_dir()";
 #endif

 int arglen = 0;
 int rc     = 0;

 struct stat sbuf;

 #ifdef WIN32
 char dirsep[]="\\";
 #else
 char dirsep[]="/";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 #endif

 if ( !arg )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ERROR: 'arg' is NULL...", cn );
    mod_gzip_printf( "%s: ERROR: No valid directory supplied.", cn );
    #endif

    return "mod_gzip_temp_dir: ERROR: No valid directory supplied.";
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 arglen = mod_gzip_strlen( arg );

 if ( arglen < 256 )
   {
    mod_gzip_strcpy( mgc->temp_dir, arg );
    mgc->temp_dir_set = 1;

    if ( arglen > 0 )
      {
       if (( arglen == 1 ) && ( *arg == 32 ))
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: Special ONE SPACE pickup seen.", cn );
          mod_gzip_printf( "%s: temp_dir set to NOTHING.", cn );
          #endif

          mod_gzip_strcpy( mgc->temp_dir, "" );
         }
       else
         {
          if ( ( *(mgc->temp_dir+(arglen-1)) != '\\' ) &&
               ( *(mgc->temp_dir+(arglen-1)) != '/'  ) )
            {
             mod_gzip_strcat( mgc->temp_dir, dirsep );
            }

          rc = stat( mgc->temp_dir, &sbuf );

          if ( rc )
            {
             #ifdef MOD_GZIP_DEBUG1
             mod_gzip_printf( "%s: .... stat() call FAILED",cn);
             mod_gzip_printf( "%s: Directory name is not valid.",cn);
             #endif

             return "mod_gzip_temp_dir: ERROR: Directory does not exist.";
            }
          else
            {
             #ifdef MOD_GZIP_DEBUG1
             mod_gzip_printf( "%s: .... stat() call SUCCEEDED",cn);
             mod_gzip_printf( "%s: Directory name appears to be valid.",cn);
             #endif
            }
         }
      }

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: mgc->loc             = [%s]", cn, npp(mgc->loc));
    mod_gzip_printf( "%s: srv->is_virtual      = %ld",  cn, (long)srv->is_virtual );
    mod_gzip_printf( "%s: srv->server_hostname = [%s]", cn, npp(srv->server_hostname));
    mod_gzip_printf( "%s: mgc->cmode           = %ld",  cn, (long) mgc->cmode);
    mod_gzip_printf( "%s: mgc->temp_dir        = [%s]", cn, npp(mgc->temp_dir));
    mod_gzip_printf( "%s: mgc->temp_dir_set    = %d",   cn, mgc->temp_dir_set);
    #endif

    return NULL;
   }
 else
   {
    return "mod_gzip_temp_dir pathname must be less than 256 characters.";
   }
}

static const char *mod_gzip_handle_methods(cmd_parms *parms,void *cfg,char *arg1,char *arg2) {
  mod_gzip_conf *mgc    = (mod_gzip_conf *)cfg;
  int            set[2] = { 0, 0 };

  if(arg1 && arg2) {
    if(strcasecmp(arg1,"GET") == 0) {
      set[0] = 1;
    }
    else if(strcasecmp(arg1,"POST") == 0) {
      set[1] = 1;
    }

    if(strcasecmp(arg2,"GET") == 0) {
      if(set[0]) {
        return "mod_gzip_handle_methods: duplicate method name!";
      }

      set[0] = 1;
    }
    else if(strcasecmp(arg2,"POST") == 0) {
      if(set[1]) {
        return "mod_gzip_handle_methods: duplicate method name!";
      }

      set[1] = 1;
    }

    if(set[0] && set[1]) {
      mgc->handle_methods = MOD_GZIP_M_BOTH;
      return NULL;
    }
    else {
      return "mod_gzip_handle_methods: can only handle GET or POST!";
    }
  }
  else if(arg1) {
    if(strcasecmp(arg1,"GET") == 0) {
      mgc->handle_methods = M_GET;
    }
    else if(strcmp(arg1,"POST") == 0) {
      mgc->handle_methods = M_POST;
    }
    else {
      return "mod_gzip_handle_methods: can only handle GET or POST!";
    }

    return NULL;
  }

  return "mod_gzip_handle_methods: Argument needed!";
}

static const char *mod_gzip_static_suffix(cmd_parms *parms,void *cfg,char *arg1) {
  mod_gzip_conf *mgc = (mod_gzip_conf *)cfg;
  size_t len;

  if(arg1) {
    len = strlen(arg1);
    if(len > MOD_GZIP_MAX_SUFFIX_LEN) {
      return "mod_gzip_static_suffix: suffix to long!";
    }

    mod_gzip_strcpy(mgc->suffix,arg1);
    mgc->suffix_set = 1;
    return NULL;
  }

  return "mod_gzip_static_suffix: Argument needed!";
}

static const char *mod_gzip_send_vary(cmd_parms *parms,void *cfg,char *arg1) {
  mod_gzip_conf *mgc = (mod_gzip_conf *)cfg;

  if(arg1) {
    mgc->send_vary_set = 1;

    if(strcasecmp(arg1,"on") == 0) {
      mgc->send_vary = 1;
    }
    else {
      mgc->send_vary = 0;
    }

    return NULL;
  }

  return "mod_gzip_send_vary: Argument needed!";
}

static const char *mod_gzip_update_static(cmd_parms *parms,void *cfg,char *arg) {
  mod_gzip_conf *mgc = (mod_gzip_conf *)cfg;

  if(arg) {
    if(strcasecmp(arg,"yes") == 0) {
      mgc->refresh_files     = 1;
      mgc->refresh_files_set = 1;

      return NULL;
    }
    else if(strcasecmp(arg,"no") == 0) {
      mgc->refresh_files     = 0;
      mgc->refresh_files_set = 1;

      return NULL;
    }
  }

  return "mod_gzip_update_static: usage: mod_gzip_update_static yes|no";
}

#ifdef MOD_GZIP_COMMAND_VERSION_USED
static const char *
mod_gzip_set_command_version( cmd_parms *parms, void *cfg, char *arg )
{
 mod_gzip_conf *mgc;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_command_version()";
 #endif

 int arglen = 0;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 #endif

 if ( !arg )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ERROR: 'arg' is NULL...", cn );
    mod_gzip_printf( "%s: ERROR: No valid string supplied.", cn );
    #endif

    return "mod_gzip_command_version: ERROR: No valid string supplied.";
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: arg=[%s]", cn, npp(arg) );
 #endif

 mgc = ( mod_gzip_conf * ) cfg;

 arglen = mod_gzip_strlen( arg );

 if ( arglen < MOD_GZIP_COMMAND_VERSION_MAXLEN )
   {
    mod_gzip_strcpy( mgc->command_version, arg );
    mgc->command_version_set = 1;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: mgc->loc                 = [%s]", cn, npp(mgc->loc));
    mod_gzip_printf( "%s: srv->is_virtual          = %ld",  cn, (long)srv->is_virtual );
    mod_gzip_printf( "%s: srv->server_hostname     = [%s]", cn, npp(srv->server_hostname));
    mod_gzip_printf( "%s: mgc->cmode               = %ld",  cn, (long) mgc->cmode);
    mod_gzip_printf( "%s: mgc->command_version     = [%s]", cn, npp(mgc->command_version));
    mod_gzip_printf( "%s: mgc->command_version_set = %d",   cn, mgc->command_version_set);
    #endif

    return NULL;
   }
 else
   {
    return "mod_gzip_command_version string must be less than 128 characters.";
   }
}
#endif

static const char *
mod_gzip_imap_add_item(
cmd_parms     *parms,
mod_gzip_conf *mgc,
char          *a1,
char          *a2,
int            flag1
)
{
 int      x;
 char    *p1;
 int      ignorecase=0;

 int      this_include=flag1;
 int      this_type=0;
 int      this_action=0;
 int      this_direction=0;
 unsigned this_port=0;
 int      this_len1=0;
 regex_t *this_pregex=NULL;

 char    *regex;

 /* Diagnostic only
 #define MOD_GZIP_TEST_REGEX1
 */
 #ifdef  MOD_GZIP_TEST_REGEX1
 char string[129];
 int  regex_error;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_imap_add_item()";
 #endif

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: 1 a1=[%s]", cn, npp(a1));
 mod_gzip_printf( "%s: 1 a2=[%s]", cn, npp(a2));

 mod_gzip_printf( "%s: mgc->imap_total_entries     = %d",
                   cn, mgc->imap_total_entries );
 mod_gzip_printf( "%s: mgc->imap_total_ismime      = %d",
                   cn, mgc->imap_total_ismime );
 mod_gzip_printf( "%s: mgc->imap_total_isfile      = %d",
                   cn, mgc->imap_total_isfile );
 mod_gzip_printf( "%s: mgc->imap_total_isuri       = %d",
                   cn, mgc->imap_total_isuri );
 mod_gzip_printf( "%s: mgc->imap_total_ishandler   = %d",
                   cn, mgc->imap_total_ishandler );
 mod_gzip_printf( "%s: mgc->imap_total_isreqheader = %d",
                   cn, mgc->imap_total_isreqheader );
 mod_gzip_printf( "%s: mgc->imap_total_isrspheader = %d",
                   cn, mgc->imap_total_isrspheader );

 if ( flag1 == 1 )
   {
    mod_gzip_printf( "%s: flag1 = %d = INCLUDE", cn, flag1 );
   }
 else if ( flag1 == 0 )
   {
    mod_gzip_printf( "%s: flag1 = %d = EXCLUDE", cn, flag1 );
   }
 else
   {
    mod_gzip_printf( "%s: flag1 = %d = ??? Unknown value", cn, flag1 );
   }

 #endif

 this_type = MOD_GZIP_IMAP_ISNONE;

 if ( mod_gzip_strnicmp( a1, "mime", 4 ) == 0 )
   {
    this_type = MOD_GZIP_IMAP_ISMIME;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_type = MOD_GZIP_IMAP_ISMIME", cn);
    #endif
   }
 else if ( mod_gzip_strnicmp( a1, "file", 4 ) == 0 )
   {
    this_type = MOD_GZIP_IMAP_ISFILE;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_type = MOD_GZIP_IMAP_ISFILE",cn);
    #endif
   }
 else if ( mod_gzip_strnicmp( a1, "ur", 2 ) == 0 )
   {
    /* Allow user to specify EITHER 'uri' or 'url' for this 'type' */

    this_type = MOD_GZIP_IMAP_ISURI;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_type = MOD_GZIP_IMAP_ISURI",cn);
    #endif
   }
 else if ( mod_gzip_strnicmp( a1, "hand", 4 ) == 0 )
   {
    this_type = MOD_GZIP_IMAP_ISHANDLER;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_type = MOD_GZIP_IMAP_ISHANDLER",cn);
    #endif
   }
 else if ( mod_gzip_strnicmp( a1, "reqh", 4 ) == 0 )
   {
    this_type      = MOD_GZIP_IMAP_ISREQHEADER;
    this_direction = MOD_GZIP_REQUEST;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_type      = MOD_GZIP_IMAP_ISREQHEADER",cn);
    #endif
   }
 else if ( mod_gzip_strnicmp( a1, "rsph", 4 ) == 0 )
   {
    this_type      = MOD_GZIP_IMAP_ISRSPHEADER;
    this_direction = MOD_GZIP_RESPONSE;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_type      = MOD_GZIP_IMAP_ISRSPHEADER",cn);
    #endif
   }

 if ( this_type == MOD_GZIP_IMAP_ISNONE )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_type = ?? UNKNOWN ??",cn);
    mod_gzip_printf( "%s: Exit > return( ERRORSTRING ) >",cn);
    #endif

    return "mod_gzip: ERROR: Valid item types are mime,file,uri,handler,reqheader or rspheader";
   }

 p1 = a2;

 if ( ( this_type == MOD_GZIP_IMAP_ISREQHEADER ) ||
      ( this_type == MOD_GZIP_IMAP_ISRSPHEADER ) )
   {
    while((*p1!=0)&&(*p1!=':')) { p1++; this_len1++; }

    if (*p1==':')
      {
       if ( this_len1 < 1 )
         {
          return "mod_gzip: ERROR: Missing HTTP field name.";
         }

       p1++;
      }
    else
      {
       return "mod_gzip: ERROR: Missing HTTP field name. No colon found.";
      }

    while((*p1!=0)&&(*p1<33)) p1++;
   }

 regex = p1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: regex = [%s]", cn, npp(regex) );
 #endif

 if ( !*regex )
   {
    return "mod_gzip: ERROR: Missing regular expression string.";
   }

 ignorecase = 1;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: ignorecase = %d",cn,ignorecase);
 mod_gzip_printf( "%s: Call ap_pregcomp(%s)...",cn,npp(regex));
 #endif

 this_pregex =
 ap_pregcomp(parms->pool, regex,
 (REG_EXTENDED | REG_NOSUB
 | (ignorecase ? REG_ICASE : 0)));

 if ( this_pregex == NULL )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... ap_pregcomp(%s) FAILED...",cn,npp(regex));
    mod_gzip_printf( "%s: regex 'pre-compile' FAILED...", cn );
    mod_gzip_printf( "%s: Exit > return( ERRORSTRING ) >",cn);
    #endif

    return "mod_gzip: ERROR: Regular expression compile failed.";
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: .... ap_pregcomp(%s) SUCCEEDED...",cn,npp(regex));
 mod_gzip_printf( "%s: regex 'pre-compiled' OK", cn );
 #endif

 #ifdef MOD_GZIP_TEST_REGEX1

 if ( ( this_type == MOD_GZIP_IMAP_ISREQHEADER ) ||
      ( this_type == MOD_GZIP_IMAP_ISRSPHEADER ) )
   {
    mod_gzip_strcpy(
    string,
    "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt; TUCOWS)"
    );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call ap_regexec( regex=[%s], string=[%s] )",
                   cn, npp(regex), npp(string) );
    #endif

    regex_error = ap_regexec(this_pregex, string, 0, (regmatch_t *)NULL,0);

    #ifdef MOD_GZIP_DEBUG1
    if ( regex_error != 0 )
    mod_gzip_printf( "%s: regex_error = %d = NO MATCH!", cn, regex_error );
    else
    mod_gzip_printf( "%s: regex_error = %d = MATCH!", cn, regex_error );
    #endif
   }

 #endif /* MOD_GZIP_TEST_REGEX1 */

 this_action = MOD_GZIP_IMAP_STATIC1;

 #ifdef FUTURE_USE

 if ( ( this_action != MOD_GZIP_IMAP_DYNAMIC1 ) &&
      ( this_action != MOD_GZIP_IMAP_DYNAMIC2 ) &&
      ( this_action != MOD_GZIP_IMAP_STATIC1  ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: this_action = %d = MOD_GZIP_IMAP_??? Unknown action",cn,this_action);
    mod_gzip_printf( "%s: return( mod_gzip: ERROR: Unrecognized item 'action'",cn);
    #endif

    return( "mod_gzip: ERROR: Unrecognized item 'action'" );
   }

 #endif

 if ( mgc->imap_total_entries < MOD_GZIP_IMAP_MAXNAMES )
   {
    if ( mod_gzip_strlen( a2 ) < MOD_GZIP_IMAP_MAXNAMELEN )
      {
       x = mgc->imap_total_entries;

       p1 = a2;

       mod_gzip_strcpy( mgc->imap[x].name, p1 );

       mgc->imap[x].namelen = mod_gzip_strlen( mgc->imap[x].name );

       mgc->imap[x].include   = this_include;
       mgc->imap[x].type      = this_type;
       mgc->imap[x].action    = this_action;
       mgc->imap[x].direction = this_direction;
       mgc->imap[x].port      = this_port;
       mgc->imap[x].len1      = this_len1;
       mgc->imap[x].pregex    = this_pregex;

       mgc->imap_total_entries++;

       if ( this_type == MOD_GZIP_IMAP_ISMIME )
         {
          mgc->imap_total_ismime++;
         }
       else if ( this_type == MOD_GZIP_IMAP_ISFILE )
         {
          mgc->imap_total_isfile++;
         }
       else if ( this_type == MOD_GZIP_IMAP_ISURI )
         {
          mgc->imap_total_isuri++;
         }
       else if ( this_type == MOD_GZIP_IMAP_ISHANDLER )
         {
          mgc->imap_total_ishandler++;
         }
       else if ( this_type == MOD_GZIP_IMAP_ISREQHEADER )
         {
          mgc->imap_total_isreqheader++;
         }
       else if ( this_type == MOD_GZIP_IMAP_ISRSPHEADER )
         {
          mgc->imap_total_isrspheader++;
         }
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: return( mod_gzip: ERROR: Item name is too long",cn);
       #endif

       return( "mod_gzip: ERROR: Item name is too long" );
      }
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: return( mod_gzip: ERROR: Item index is full",cn);
    #endif

    return( "mod_gzip: ERROR: Item index is full" );
   }

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: mgc->imap_total_entries     = %d",
                   cn, mgc->imap_total_entries );
 mod_gzip_printf( "%s: mgc->imap_total_ismime      = %d",
                   cn, mgc->imap_total_ismime );
 mod_gzip_printf( "%s: mgc->imap_total_isfile      = %d",
                   cn, mgc->imap_total_isfile );
 mod_gzip_printf( "%s: mgc->imap_total_isuri       = %d",
                   cn, mgc->imap_total_isuri );
 mod_gzip_printf( "%s: mgc->imap_total_ishandler   = %d",
                   cn, mgc->imap_total_ishandler );
 mod_gzip_printf( "%s: mgc->imap_total_isreqheader = %d",
                   cn, mgc->imap_total_isreqheader );
 mod_gzip_printf( "%s: mgc->imap_total_isrspheader = %d",
                   cn, mgc->imap_total_isrspheader );

 mod_gzip_printf( "%s: Exit > return( NULL ) >",cn);

 #endif

 return NULL;
}

static const char *
mod_gzip_set_item_include( cmd_parms *parms, void *cfg, char *a1, char *a2 )
{
 mod_gzip_conf *mgc;
 char *arg;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_item_include()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: a1=[%s]", cn, npp(a1) );
 mod_gzip_printf( "%s: a2=[%s]", cn, npp(a2) );
 #endif

 arg = a1;

 mgc = ( mod_gzip_conf * ) cfg;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc             = [%s]", cn, npp(mgc->loc));
 mod_gzip_printf( "%s: srv->is_virtual      = %ld",  cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname = [%s]", cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->cmode           = %ld",  cn, (long) mgc->cmode );
 #endif

 return( mod_gzip_imap_add_item( parms, mgc, a1, a2, 1 ) );
}

static const char *
mod_gzip_set_item_exclude( cmd_parms *parms, void *cfg, char *a1, char *a2 )
{
 mod_gzip_conf *mgc;
 char *arg;

 #ifdef MOD_GZIP_DEBUG1
 server_rec *srv = parms->server;
 char cn[]="mod_gzip_set_item_exclude()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = srv;
 mod_gzip_printf( " ");
 mod_gzip_printf( "%s: Entry", cn );
 mod_gzip_printf( "%s: a1=[%s]", cn, npp(a1));
 mod_gzip_printf( "%s: a2=[%s]", cn, npp(a2));
 #endif

 arg = a1;

 mgc = ( mod_gzip_conf * ) cfg;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: mgc->loc             = [%s]", cn, npp(mgc->loc));
 mod_gzip_printf( "%s: srv->is_virtual      = %ld",  cn, (long)srv->is_virtual );
 mod_gzip_printf( "%s: srv->server_hostname = [%s]", cn, npp(srv->server_hostname));
 mod_gzip_printf( "%s: mgc->cmode           = %ld",  cn, (long) mgc->cmode );
 #endif

 return( mod_gzip_imap_add_item( parms, mgc, a1, a2, 0 ) );
}

static void *mod_gzip_create_dconfig(
pool *p,
char *dirspec
)
{
 mod_gzip_conf *cfg;
 char *dname = dirspec;

 cfg = (mod_gzip_conf *) ap_pcalloc(p, sizeof(mod_gzip_conf));

 cfg->cmode = MOD_GZIP_CONFIG_MODE_DIRECTORY;

 dname = (dname != NULL) ? dname : "";

 cfg->loc = ap_pstrcat(p, "DIR(", dname, ")", NULL);

 mod_gzip_set_defaults1( (mod_gzip_conf *) cfg );

 return (void *) cfg;
}

static void *mod_gzip_merge_dconfig(
pool *p,
void *parent_conf,
void *newloc_conf
)
{
 mod_gzip_conf *merged_config = (mod_gzip_conf *) ap_pcalloc(p, sizeof(mod_gzip_conf));
 mod_gzip_conf *pconf         = (mod_gzip_conf *) parent_conf;
 mod_gzip_conf *nconf         = (mod_gzip_conf *) newloc_conf;

 mod_gzip_merge1(
 ( pool          * ) p,
 ( mod_gzip_conf * ) merged_config,
 ( mod_gzip_conf * ) pconf,
 ( mod_gzip_conf * ) nconf
 );

 return (void *) merged_config;
}

static void *mod_gzip_create_sconfig(
pool       *p,
server_rec *s
)
{
 mod_gzip_conf *cfg;
 char *sname = s->server_hostname;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_server_now = s;
 #endif

 cfg = (mod_gzip_conf *) ap_pcalloc(p, sizeof(mod_gzip_conf));

 cfg->cmode = MOD_GZIP_CONFIG_MODE_SERVER;

 sname = (sname != NULL) ? sname : "";

 cfg->loc = ap_pstrcat(p, "SVR(", sname, ")", NULL);

 mod_gzip_set_defaults1( (mod_gzip_conf *) cfg );

 return (void *) cfg;
}

static void *mod_gzip_merge_sconfig(
pool *p,
void *parent_conf,
void *newloc_conf
)
{
 mod_gzip_conf *merged_config = (mod_gzip_conf *) ap_pcalloc(p, sizeof(mod_gzip_conf));
 mod_gzip_conf *pconf         = (mod_gzip_conf *) parent_conf;
 mod_gzip_conf *nconf         = (mod_gzip_conf *) newloc_conf;

 mod_gzip_merge1(
 ( pool          * ) p,
 ( mod_gzip_conf * ) merged_config,
 ( mod_gzip_conf * ) pconf,
 ( mod_gzip_conf * ) nconf
 );

 return (void *) merged_config;
}

static const command_rec mod_gzip_cmds[] =
{
 {"mod_gzip_on", mod_gzip_set_is_on, NULL, OR_OPTIONS, TAKE1,
  "Yes=mod_gzip will handle requests. No=mod_gzip is disabled."},
 {"mod_gzip_add_header_count", mod_gzip_set_add_header_count, NULL, OR_OPTIONS, TAKE1,
  "Yes=Add header byte counts to Common Log Format output total(s)."},
 {"mod_gzip_keep_workfiles", mod_gzip_set_keep_workfiles, NULL, OR_OPTIONS, TAKE1,
  "Yes=Keep any work files used. No=Automatically delete any work files used."},
 {"mod_gzip_dechunk", mod_gzip_set_dechunk, NULL, OR_OPTIONS, TAKE1,
  "Yes=Allow removal of 'Transfer-encoding: chunked' when necessary."},
 {"mod_gzip_min_http", mod_gzip_set_min_http, NULL, OR_OPTIONS, TAKE1,
  "Minimum HTTP protocol value to support. 1000 = HTTP/1.0  1001 = HTTP/1.1"},
 {"mod_gzip_minimum_file_size", mod_gzip_set_minimum_file_size, NULL, OR_OPTIONS, TAKE1,
  "Minimum size ( bytes ) of a file eligible for compression"},
 {"mod_gzip_maximum_file_size", mod_gzip_set_maximum_file_size, NULL, OR_OPTIONS, TAKE1,
  "Maximum size ( bytes ) of a file eligible for compression"},
 {"mod_gzip_maximum_inmem_size", mod_gzip_set_maximum_inmem_size, NULL, OR_OPTIONS, TAKE1,
  "Maximum size ( bytes ) to use for in-memory compression."},
 {"mod_gzip_temp_dir", mod_gzip_set_temp_dir, NULL, OR_OPTIONS, TAKE1,
  "The directory to use for work files and compression cache"},
 {"mod_gzip_item_include", mod_gzip_set_item_include, NULL, OR_OPTIONS, TAKE2,
  "\r\nARG1=[mime,handler,file,uri,reqheader,rspheader] \r\nARG2=[Name of item to INCLUDE in list of things that should be compressed]"},
 {"mod_gzip_item_exclude", mod_gzip_set_item_exclude, NULL, OR_OPTIONS, TAKE2,
  "\r\nARG1=[mime,handler,file,uri,reqheader,rspheader] \r\nARG2=[Name of item to EXCLUDE from list of things that should be compressed]"},
 #ifdef MOD_GZIP_COMMAND_VERSION_USED
 {"mod_gzip_command_version", mod_gzip_set_command_version, NULL, OR_OPTIONS, TAKE1,
  "User defined pickup string to use for mod_gzip version command."},
 #endif
 #ifdef MOD_GZIP_CAN_NEGOTIATE
 {"mod_gzip_can_negotiate", mod_gzip_set_can_negotiate, NULL, OR_OPTIONS, TAKE1,
  "Yes=Negotiate/send static compressed versions of files  No=Do not negotiate."},
 #endif
 { "mod_gzip_handle_methods", mod_gzip_handle_methods, NULL, OR_OPTIONS, TAKE12,
   "mod_gzip_handle_methods GET|POST [GET|POST]\n" },
 { "mod_gzip_static_suffix", mod_gzip_static_suffix, NULL, OR_OPTIONS, TAKE1,
   "mod_gzip_static_suffix suffix" },
 { "mod_gzip_send_vary", mod_gzip_send_vary, NULL, OR_OPTIONS, TAKE1,
   "mod_gzip_send_vary on|off" },
 { "mod_gzip_update_static", mod_gzip_update_static, NULL, OR_OPTIONS, TAKE1,
   "mod_gzip_update_static yes|no" },
 {NULL}
};

static const handler_rec mod_gzip_handlers[] =
{
 {"mod_gzip_handler", mod_gzip_handler},
 {CGI_MAGIC_TYPE,     mod_gzip_handler},
 {"cgi-script",       mod_gzip_handler},
 {"*",                mod_gzip_handler},
 {NULL}
};

module MODULE_VAR_EXPORT gzip_module =
{
 STANDARD_MODULE_STUFF,
 mod_gzip_init,
 mod_gzip_create_dconfig,
 mod_gzip_merge_dconfig,
 mod_gzip_create_sconfig,
 mod_gzip_merge_sconfig,
 mod_gzip_cmds,
 mod_gzip_handlers,
 NULL,
 NULL,
 NULL,
 NULL,
 mod_gzip_type_checker,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL,
 NULL
};

#ifdef NETWARE
int main(int argc, char *argv[]) 
{
    ExitThread(TSR_THREAD, 0);
}
#endif

long mod_gzip_send(
char        *buf,
long         buflen,
request_rec *r
)
{
 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_send()";
 #endif

 int  bytes_to_send    = 0;
 int  bytes_sent       = 0;
 long bytes_left       = buflen;
 long total_bytes_sent = 0;

 char *p1=buf;
 int   p1maxlen=4096; 

 #ifdef MOD_GZIP_DEBUG1
 #ifdef MOD_GZIP_DEBUG1_SEND1
 mod_gzip_printf("%s: Entry...",cn);
 mod_gzip_printf("%s: buf    = %ld",cn,(long)buf);
 mod_gzip_printf("%s: buflen = %ld",cn,(long)buflen);
 mod_gzip_printf("%s: r      = %ld",cn,(long)r);
 #endif
 #endif

 if ( !buf    ) return 0;
 if ( !buflen ) return 0;
 if ( !r      ) return 0;

 for (;;) 
    {
     if ( bytes_left <= 0 )
       {
        break;
       }

     bytes_to_send = p1maxlen; 

     if ( bytes_to_send > bytes_left )
       {
        bytes_to_send = bytes_left; 
       }

     #ifdef MOD_GZIP_DEBUG1
     #ifdef MOD_GZIP_DEBUG1_SEND1
     mod_gzip_printf("%s: Call ap_rwrite(bytes_to_send=%d)...",cn,bytes_to_send);
     #endif
     #endif

     bytes_sent =
     ap_rwrite(
     p1,
     bytes_to_send,
     (request_rec *) r
     );

     #ifdef MOD_GZIP_DEBUG1
     #ifdef MOD_GZIP_DEBUG1_SEND1
     mod_gzip_printf("%s: Back ap_rwrite(bytes_to_send=%d)...",cn,bytes_to_send);
     mod_gzip_printf("%s: bytes_sent = %d",cn,bytes_sent);
     #endif
     #endif

     if ( bytes_sent > 0 )
       {
        total_bytes_sent += bytes_sent;
        bytes_left       -= bytes_sent;
        p1               += bytes_sent;
       }
     else
       {
        break;
       }
    }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf("%s: Done > return( total_bytes_sent = %ld ) >",
                          cn, (long) total_bytes_sent);
 #endif

 return( total_bytes_sent );
}

int mod_gzip_redir1_handler(
request_rec   *r,
mod_gzip_conf *dconf
)
{
 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_redir1_handler()";
 #endif

 int rc          = 0;
 int status      = 0;
 int pid         = 0;
 int save_socket = 0;

 int   dconf__keep_workfiles = 0;
 char *dconf__temp_dir       = 0;

 char tempfile_redir1[ MOD_GZIP_MAX_PATH_LEN + 2 ];

 #if defined(WIN32) || defined(NETWARE)
 int save_flags = 0;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( " " );
 mod_gzip_printf( "%s: Entry...",cn);
 #endif

 tempfile_redir1[0] = 0;

 dconf__keep_workfiles = dconf->keep_workfiles;
 dconf__temp_dir       = dconf->temp_dir;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->proxyreq           = %d",   cn, (int) r->proxyreq );
 mod_gzip_printf( "%s: dconf__keep_workfiles = %d",   cn, (int) dconf__keep_workfiles );
 mod_gzip_printf( "%s: dconf__temp_dir       = [%s]", cn, npp(dconf__temp_dir));
 #endif

 ap_table_setn( r->notes,
 "mod_gzip_running",ap_pstrdup(r->pool,"1"));

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->notes->mod_gzip_running set to '1'",cn);
 #endif

 pid = getpid();

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Saving 'r->connection->client->fd' value to 'save_socket' stack variable...",cn);
 #endif

 save_socket = (int) r->connection->client->fd;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: 'r->connection->client->fd' saved to 'save_socket' stack variable",cn);
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Creating 'tempfile_redir1' string now...",cn);
 #endif

 mod_gzip_create_unique_filename(
 dconf__temp_dir,
 (char *) tempfile_redir1,
 MOD_GZIP_MAX_PATH_LEN
 );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: tempfile_redir1 = [%s]",cn,npp(tempfile_redir1));
 mod_gzip_printf( "%s: Call mod_gzip_dyn1_getfdo1(%s)...",cn,npp(tempfile_redir1));
 #endif

 status = mod_gzip_dyn1_getfdo1( r, tempfile_redir1 );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back mod_gzip_dyn1_getfdo1(%s)...",cn,npp(tempfile_redir1));
 #endif

 if ( status != OK )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back mod_gzip_dyn1_getfdo1(%s)...",cn,npp(tempfile_redir1));
    mod_gzip_printf( "%s: .... mod_gzip_dyn1_getfdo1() call FAILED",cn);
    mod_gzip_printf( "%s: status = %d",cn,status);
    #endif

    #ifdef WIN32
    ap_log_error( "",0,APLOG_NOERRNO|APLOG_WARNING, r->server,
    "mod_gzip: ERROR: CreateFile(%s) in dyn1_getfdo1",tempfile_redir1);
    #else
    ap_log_error( "",0,APLOG_NOERRNO|APLOG_WARNING, r->server,
    "mod_gzip: ERROR: fopen(%s) in dyn1_getfdo1",tempfile_redir1);
    #endif

    ap_log_error( "",0,APLOG_NOERRNO|APLOG_WARNING, r->server,
    "mod_gzip: ERROR: %s",mod_gzip_check_permissions);

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,
    "mod_gzip_result",ap_pstrdup(r->pool,"DECLINED:DYN1_OPENFAIL_BODY"));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back mod_gzip_dyn1_getfdo1(%s)...",cn,npp(tempfile_redir1));
    mod_gzip_printf( "%s: .... mod_gzip_dyn1_getfdo1() call SUCCEEDED",cn);
    #endif
   }

 #if defined(WIN32) || defined(NETWARE)

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: WINSOCK: Saves/restores B_SOCKET flag as well...",cn);
 mod_gzip_printf( "%s: WINSOCK: Saving 'r->connection->client->flags' value to 'save_flags' stack variable...",cn);
 #endif

 save_flags = (int) r->connection->client->flags;

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags = %ld",  cn, (long) r->connection->client->flags );

 if ( r->connection->client->flags & B_SOCKET )
   {
    mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags & B_SOCKET is TRUE",cn);
   }
 else
   {
    mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags & B_SOCKET is FALSE",cn);
   }

 #endif

 if ( r->connection->client->flags & B_SOCKET )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: WINSOCK: Clearing B_SOCKET flag now....", cn);
    mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags &= ~B_SOCKET", cn);
    #endif

    r->connection->client->flags &= ~B_SOCKET;
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: WINSOCK: B_SOCKET flag not present...", cn);
    mod_gzip_printf( "%s: WINSOCK: No action was taken...", cn);
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags = %ld",  cn, (long) r->connection->client->flags );

 if ( r->connection->client->flags & B_SOCKET )
   {
    mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags & B_SOCKET is TRUE",cn);
   }
 else
   {
    mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags & B_SOCKET is FALSE",cn);
   }

 #endif

 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call ap_internal_redirect(r->unparsed_uri=[%s])...",
                   cn,npp(r->unparsed_uri));
 mod_gzip_printf( " " );
 #endif

 ap_internal_redirect( r->unparsed_uri, r );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( " " );
 mod_gzip_printf( "%s: Back ap_internal_redirect(r->unparsed_uri=[%s])...",
                   cn,npp(r->unparsed_uri));
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Before... ap_rflush()...",cn);
 mod_gzip_printf( "%s: r->connection->client->outcnt     = %ld",
             cn,(long) r->connection->client->outcnt );
 mod_gzip_printf( "%s: r->connection->client->bytes_sent = %ld",
             cn,(long) r->connection->client->bytes_sent );
 mod_gzip_printf( "%s: Call..... ap_rflush()...",cn);
 #endif

 ap_rflush(r);

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back..... ap_rflush()...",cn);
 mod_gzip_printf( "%s: After.... ap_rflush()...",cn);
 mod_gzip_printf( "%s: r->connection->client->outcnt     = %ld",
             cn,(long) r->connection->client->outcnt );
 mod_gzip_printf( "%s: r->connection->client->bytes_sent = %ld",
             cn,(long) r->connection->client->bytes_sent );
 #endif

 #ifdef WIN32

 if ( r->connection->client->hFH )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: WIN32: Call CloseHandle( r->connection->client->hFH )...",cn);
    #endif

    CloseHandle( r->connection->client->hFH );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: WIN32: Back CloseHandle( r->connection->client->hFH )...",cn);
    #endif

    r->connection->client->hFH = 0;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: WIN32: r->connection->client->hFH reset to ZERO",cn);
    #endif
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: WIN32: r->connection->client->hFH already closed.",cn);
    mod_gzip_printf( "%s: WIN32: No CloseFile() call was necessary at this point.",cn);
    #endif
   }

 #else

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: UNIX: Call close( r->connection->client->fd )...",cn);
 #endif

 close( r->connection->client->fd );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: UNIX: Back close( r->connection->client->fd )...",cn);
 #endif

 #endif

 r->connection->client->fd = (int) save_socket;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: 'r->connection->client->fd' RESTORED from 'save_socket' stack variable",cn);
 #endif

 #if defined(WIN32) || defined(NETWARE)

 r->connection->client->flags = (int) save_flags;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags RESTORED from 'save_flags' stack variable...",cn);
 #endif

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags = %ld",  cn, (long) r->connection->client->flags );

 if ( r->connection->client->flags & B_SOCKET )
   {
    mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags & B_SOCKET is TRUE",cn);
   }
 else
   {
    mod_gzip_printf( "%s: WINSOCK: r->connection->client->flags & B_SOCKET is FALSE",cn);
   }

 #endif

 #endif

 r->connection->client->bytes_sent = 0;
 r->connection->client->outcnt     = 0;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Connection byte counts have been RESET...",cn);
 mod_gzip_printf( "%s: r->connection->client->outcnt     = %ld",
                   cn, r->connection->client->outcnt );
 mod_gzip_printf( "%s: r->connection->client->bytes_sent = %ld",
                   cn, r->connection->client->bytes_sent );

 mod_gzip_printf( "%s: r->bytes_sent = %ld",cn,(long)r->bytes_sent);

 if ( r->next )
   {
    mod_gzip_printf( "%s: r->next->bytes_sent = %ld",cn,(long)r->next->bytes_sent);
   }
 if ( r->prev )
   {
    mod_gzip_printf( "%s: r->prev->bytes_sent = %ld",cn,(long)r->prev->bytes_sent);
   }

 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call mod_gzip_sendfile2(tempfile_redir1=[%s])...",
                   cn, npp(tempfile_redir1));
 #endif

 rc = (int)
 mod_gzip_sendfile2(
 r,
 dconf,
 tempfile_redir1
 );

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: Back mod_gzip_sendfile2(tempfile_redir1=[%s])...",
                   cn, npp(tempfile_redir1));

 if ( rc == OK )
   {
    mod_gzip_printf( "%s: rc = %d OK", cn, (int) rc);
   }
 else if ( rc == DECLINED )
   {
    mod_gzip_printf( "%s: rc = %d DECLINED", cn, (int) rc );
   }
 else
   {
    mod_gzip_printf( "%s: rc = %d ( HTTP ERROR CODE? )", cn, (int) rc );
   }

 #endif

 if ( rc != OK )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: mod_gzip_sendfile2() call FAILED",cn);
    #endif
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: mod_gzip_sendfile2() call SUCCEEDED",cn);
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->connection->client->outcnt     = %ld",
                   cn, r->connection->client->outcnt );
 mod_gzip_printf( "%s: r->connection->client->bytes_sent = %ld",
                   cn, r->connection->client->bytes_sent );
 mod_gzip_printf( "%s: Sum of the 2..................... = %ld",
                   cn, r->connection->client->outcnt +
                       r->connection->client->bytes_sent );
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: FINAL CLEANUP...",cn);
 mod_gzip_printf( "%s: dconf__keep_workfiles = %d",
                   cn, dconf__keep_workfiles );
 #endif

 if ( !dconf__keep_workfiles )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call mod_gzip_delete_file(tempfile_redir1=[%s])...",
                      cn, npp(tempfile_redir1));
    #endif

    mod_gzip_delete_file( r, tempfile_redir1 );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back mod_gzip_delete_file(tempfile_redir1=[%s])...",
                      cn, npp(tempfile_redir1));
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Exit > return( OK ) >",cn,(int)rc);
 #endif

 return OK;
}

int mod_gzip_dyn1_getfdo1(
request_rec *r,
char        *filename
)
{
 int status      = OK;
 int temp_fd     = 0;
 int open_failed = 0;

 #ifdef WIN32
 HANDLE temp_fdhan;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_dyn1_getfdo1()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...",cn);
 mod_gzip_printf( "%s: filename=[%s]",cn,npp(filename));
 #endif

 #ifdef MOD_GZIP_DYN1_GETFDO1_ERROR_TEST1

 status = DECLINED;
 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: ** TEST ** 'status' forced to 'DECLINED'...",cn);
 #endif
 return DECLINED;
 #endif

 #ifdef WIN32

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: WIN32: Call CreateFile(filename=[%s],GENERIC_WRITE, FILE_SHARE_WRITE )...",
                   cn, npp(filename));
 #endif

 temp_fdhan =
 CreateFile(
 filename,
 GENERIC_WRITE,
 FILE_SHARE_WRITE,
 NULL,
 CREATE_ALWAYS,
 FILE_ATTRIBUTE_NORMAL,
 NULL
 );

 if ( temp_fdhan == INVALID_HANDLE_VALUE )
   {
    open_failed = 1;
   }

 #else

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: UNIX: Call open(filename=[%s],O_RDWR|O_CREAT|O_TRUNC,S_IRWXU)...",
                   cn, npp(filename));
 #endif

 if ((temp_fd = open(filename,O_RDWR|O_CREAT|O_TRUNC,S_IRWXU)) == -1)
   {
    open_failed = 1;
   }

 #endif

 if ( open_failed )
   {
    #ifdef MOD_GZIP_DEBUG1

    #ifdef WIN32
    mod_gzip_printf( "%s: WIN32: .... CreateFile() call FAILED", cn );
    mod_gzip_printf( "%s: WIN32: temp_fd = %d", cn, temp_fd );
    #else
    mod_gzip_printf( "%s: UNIX: .... open() call FAILED", cn );
    mod_gzip_printf( "%s: UNIX: temp_fd = %d", cn, temp_fd );
    #endif

    #endif

    ap_log_rerror(APLOG_MARK, APLOG_NOERRNO|APLOG_ERR, r,
    "mod_gzip: ERROR: Couldn't create a file descriptor at HTTP : %s", filename);

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( HTTP_INTERNAL_SERVER_ERROR ) >",cn);
    #endif

    return HTTP_INTERNAL_SERVER_ERROR;
   }

 #ifdef MOD_GZIP_DEBUG1

 #ifdef WIN32

 mod_gzip_printf( "%s: WIN32: .... CreateFile() call SUCCEEDED", cn );
 mod_gzip_printf( "%s: WIN32: temp_fdhan = (WIN32 HANDLE) %d", cn, (int) temp_fdhan );

 #else

 mod_gzip_printf( "%s: UNIX: .... open() call SUCCEEDED", cn );
 mod_gzip_printf( "%s: UNIX: temp_fd = (UNIX int) %d", cn, temp_fd );

 #endif

 #endif

 #ifdef WIN32

 r->connection->client->fd  = (int) temp_fdhan;
 r->connection->client->hFH = (HANDLE) temp_fdhan;

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: WIN32: r->connection->client->fd    = (int   ) %d",  cn, (int ) r->connection->client->fd );
 mod_gzip_printf( "%s: WIN32: r->connection->client->hFH   = (HANDLE) %ld", cn, (long) r->connection->client->hFH );
 mod_gzip_printf( "%s: WIN32: r->connection->client->flags = %ld",  cn, (long) r->connection->client->flags );

 if ( r->connection->client->flags & B_SOCKET )
   {
    mod_gzip_printf( "%s: WIN32: r->connection->client->flags & B_SOCKET is TRUE",cn);
   }
 else
   {
    mod_gzip_printf( "%s: WIN32: r->connection->client->flags & B_SOCKET is FALSE",cn);
   }

 #endif

 #else

 r->connection->client->fd = temp_fd;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: UNIX: r->connection->client->fd = %d", cn, r->connection->client->fd );
 #endif

 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Exit > return( status=%d ) >", cn, status );
 #endif

 return status;
}

long mod_gzip_sendfile1(
request_rec *r,
char        *input_filename,
FILE        *ifh_passed,
long         starting_offset
)
{
 FILE *ifh;
 int   rc;
 int   err;
 int   bytesread;
 int   byteswritten;
 long  total_byteswritten=0;

 #define   MOD_GZIP_SENDFILE1_BUFFER_SIZE 4096
 char tmp[ MOD_GZIP_SENDFILE1_BUFFER_SIZE + 16 ];

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_sendfile1()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...",cn);
 mod_gzip_printf( "%s: r               = %ld", cn,(long)r);
 mod_gzip_printf( "%s: input_filename  = [%s]",cn,npp(input_filename));
 mod_gzip_printf( "%s: ifh_passed      = %ld", cn,(long) ifh_passed);
 mod_gzip_printf( "%s: starting_offset = %ld", cn,(long) starting_offset);
 #endif

 if ( !r ) return 0;
 if ( ( !ifh_passed ) && ( !input_filename ) ) return 0;

 if ( ifh_passed ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'ifh_passed' is valid",cn);
    mod_gzip_printf( "%s: 'ifh' set to 'ifh_passed'...",cn);
    mod_gzip_printf( "%s: fopen() was NOT called...",cn);
    #endif

    ifh = ifh_passed;
   }
 else 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'ifh_passed' was NULL...",cn);
    mod_gzip_printf( "%s: Call fopen(%s)...",cn,npp(input_filename));
    #endif

    ifh = fopen( input_filename, "rb" ); 

    if ( !ifh ) 
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: .... fopen() FAILED",cn);
       mod_gzip_printf( "%s: Exit > return( 0 ) >",cn);
       #endif

       return 0;
      }

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... fopen() SUCCEEDED",cn);
    #endif
   }

 if ( starting_offset > -1 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call fseek(ifh,starting_offset=%ld,0)...",
                      cn, (long) starting_offset );
    #endif

    rc = fseek( ifh, starting_offset, 0 );

    if ( rc != 0 ) 
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: .... fseek() FAILED",cn);
       mod_gzip_printf( "%s: Exit > return( 0 ) >",cn);
       #endif

       return 0;
      }
    #ifdef MOD_GZIP_DEBUG1
    else
      {
       mod_gzip_printf( "%s: .... fseek() SUCCEEDED",cn);
      }
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: sizeof( tmp ) = %d",cn,sizeof(tmp));
 mod_gzip_printf( "%s: MOD_GZIP_SENDFILE1_BUFFER_SIZE = %d",
               cn,(int)MOD_GZIP_SENDFILE1_BUFFER_SIZE);
 mod_gzip_printf( "%s: Sending file contents now...",cn);
 #endif

 for (;;)
    {
     bytesread = fread( tmp, 1, MOD_GZIP_SENDFILE1_BUFFER_SIZE, ifh );

     #ifdef MOD_GZIP_DEBUG1
     #ifdef MOD_GZIP_DEBUG1_SENDFILE1
     mod_gzip_printf( "%s: Back fread(): bytesread=%d",cn,bytesread);
     #endif
     #endif

     if ( bytesread < 1 ) break; 

     byteswritten = (int)
     mod_gzip_send( tmp, bytesread, r );

     if ( byteswritten > 0 )
       {
        total_byteswritten += byteswritten;
       }

     #ifdef MOD_GZIP_DEBUG1
     #ifdef MOD_GZIP_DEBUG1_SENDFILE1
     mod_gzip_printf( "%s: byteswritten = %d",cn,(int)byteswritten);
     #endif
     #endif

     if ( byteswritten != bytesread )
       {
        err = errno;

        #ifdef FUTURE_USE
        #if defined(WIN32) || defined(NETWARE)
        err = WSAGetLastError();
        #else  
        err = errno;
        #endif 
        #endif 

        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf( "%s: TRANSMIT ERROR: bytesread=%d byteswritten=%d err=%d",
        cn,(int)bytesread,(int)byteswritten,(int)err );
        #endif

        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf( "%s: Breaking out of transmit loop early...",cn);
        #endif

        break; 
       }
    }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Done sending file contents...",cn);
 mod_gzip_printf( "%s: total_byteswritten = %ld",cn,total_byteswritten);
 #endif

 if ( !ifh_passed )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'ifh_passed' was NULL so close the",cn);
    mod_gzip_printf( "%s: input file that was opened at the",cn);
    mod_gzip_printf( "%s: start of this routine...",cn);
    mod_gzip_printf( "%s: Call fclose(%s)...",cn,npp(input_filename));
    #endif

    fclose( ifh );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back fclose(%s)...",cn,npp(input_filename));
    #endif
   }
 else 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'ifh_passed' was VALID on entry.",cn);
    mod_gzip_printf( "%s: No call to fclose() was made.",cn);
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Exit > return( total_byteswritten = %ld ) >",
                   cn, (long) total_byteswritten );
 #endif

 return total_byteswritten;
}

int mod_gzip_sendfile2(
request_rec   *r,
mod_gzip_conf *dconf,
char          *input_filename
)
{
 FILE *ifh=0;
 FILE *ofh=0;
 int   ofh_used=0;

 int   i=0;
 int   rc=1;
 int   err=0;
 int   final_rc=1;
 int   linecount=0;
 int   bytesleft=0;
 int   bytesread=0;
 int   bytestoread=0;
 int   skip_advance=0;
 int   byteswritten=0;
 int   bytestowrite=0;
 long  total_bytes_sent=0;
 int   valid_char_count=0;
 int   total_bytes_left_to_copy=0;

 /*
  * TODO: This is a brain-teaser to solve.
  *
  * gcc UNIX compiler will report the following 'ok_to_send'
  * flag as no longer being 'used' inside this function but
  * if it is removed or even commented out then Apache GP faults
  * at runtime when logic enters this function ( but only if
  * MOD_GZIP_DEBUG1 flag is OFF at compile time ?? ).
  *
  * There is no 'macro' anywhere that bears this name and
  * there doesn't seem to be any reason for this GP fault.
  *
  * If this 'ok_to_send' variable is removed everything is fine
  * for Win32... it is only UNIX gcc compiler that reports no
  * warning but will still GP fault at runtime.
  *
  * It's a mystery. Can anyone solve it?
  */

 int ok_to_send = 1; /* This MUST remain or UNIX 'GP faults' ??? */

 #ifdef MOD_GZIP_DEBUG1
 int   total_bytes_copied=0;
 #endif

 struct stat sbuf;

 #define   MOD_GZIP_SENDFILE2_BUFFER_SIZE 4099
 char tmp[ MOD_GZIP_SENDFILE2_BUFFER_SIZE + 16 ];

 #define MOD_GZIP_LINE_BUFFER_SIZE 2048
 /*char lbuf[ MOD_GZIP_LINE_BUFFER_SIZE + 16 ];*/
 char *lbuf = malloc(MOD_GZIP_LINE_BUFFER_SIZE + 16);
 int   lbuf_reser = 1;

 #define MOD_GZIP_DEBUG1_SENDFILE2

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_sendfile2()";
 #endif

 char *sp    = 0; 
 char *p1    = 0;
 int   p1len = 0;
 char *p2    = lbuf;
 int   p2len = 0;
 char *p3    = 0;

 long hbytes_in    = 0; 
 long bbytes_in    = 0; 
 long bbytes_out   = 0; 
 long bbytes_total = 0; 

 int  action_flag  = 0; 
 int  header_done  = 0; 
 int  body_done    = 0; 
 int  te_seen      = 0; 
 int  te_chunked   = 0; 
 int  send_as_is   = 0; 
 int  resp_code    = 0; 
 int  ce_seen      = 0; 
 int  ct_seen      = 0; 
 char ct_value[ 256 ];  

 int   field_ok        = 0; 
 int   fields_excluded = 0; 
 char *fieldkey        = 0; 
 char *fieldstring     = 0; 

 char output_filename1[256]; 

 long raw_input_length = 0; 

 #define CHUNKE_GET_HEXSTRING  1
 #define CHUNKE_WAIT_REAL_EOL1 2
 #define CHUNKE_GET_FOOTER     3
 #define CHUNKE_GET_REAL_DATA  4

 #define CHUNKE_HEXSTRING_MAXLEN 10

 int   chunke_count           = 1;
 char *chunke_errstr          = NULL;
 int   chunke_state           = CHUNKE_GET_HEXSTRING;
 int   chunke_nextstate       = 0;
 long  chunke_realdata_length = 0;
 long  chunke_realdata_read   = 0;
 int   chunke_hexstring_oset  = 0;
 char  chunke_hexstring[ CHUNKE_HEXSTRING_MAXLEN + 1 ];

 #ifdef CHUNKE_USES_OUTPUT_BUFFER
 char *chunke_obufstart  = lbuf; 
 char *chunke_obuf       = chunke_obufstart;
 int   chunke_obuflen    = 0;
 int   chunke_obuflenmax = MOD_GZIP_LINE_BUFFER_SIZE; 
 #endif

 int   dconf__dechunk        = 0; 
 int   dconf__keep_workfiles = 0; 
 char *dconf__temp_dir       = 0; 

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...",cn);
 #endif

 if ( !r              ) return DECLINED;
 if ( !dconf          ) return DECLINED;
 if ( !input_filename ) return DECLINED;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r = %ld",cn,(long)r);
 mod_gzip_printf( "%s: r->proxyreq    = %d",  cn,(int) r->proxyreq );
 mod_gzip_printf( "%s: input_filename = [%s]",cn,npp(input_filename));
 #endif

 ct_value[0] = 0; 

 dconf__dechunk        = dconf->dechunk;
 dconf__keep_workfiles = dconf->keep_workfiles;
 dconf__temp_dir       = dconf->temp_dir;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf__dechunk        = %d",   cn, (int) dconf__dechunk );
 mod_gzip_printf( "%s: dconf__keep_workfiles = %d",   cn, (int) dconf__keep_workfiles );
 mod_gzip_printf( "%s: dconf__temp_dir       = [%s]", cn, npp(dconf__temp_dir));
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call stat(%s)...",cn,npp(input_filename));
 #endif

 rc = stat( input_filename, &sbuf );

 if ( rc ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... stat() call FAILED",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"STAT_FAILED"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: stat(%s) in sendfile2", input_filename );

    ap_log_error( "",0,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: %s",mod_gzip_check_permissions);

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 else 
   {
    raw_input_length = (long) sbuf.st_size;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... stat() call SUCCEEDED",cn);
    mod_gzip_printf( "%s: sbuf.st_size     = %ld",cn,(long)sbuf.st_size);
    mod_gzip_printf( "%s: raw_input_length = %ld",cn,(long)raw_input_length);
    #endif

    if ( sbuf.st_size < 1 )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: ERROR: The input file is EMPTY",cn);
       mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
       #endif

       #ifdef MOD_GZIP_USES_APACHE_LOGS
       ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"CAP_FILE_EMPTY"));
       #endif

       ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
       "mod_gzip: EMPTY FILE [%s] in sendfile2", input_filename );

       ap_log_error( "",0,APLOG_NOERRNO|APLOG_ERR, r->server,
       "mod_gzip: %s",mod_gzip_check_permissions);

       return DECLINED;
      }
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call fopen(%s)...",cn,npp(input_filename));
 #endif

 ifh = fopen( input_filename, "rb" ); 

 if ( !ifh ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... fopen() FAILED",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"CAP_FOPEN_FAILED"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: fopen(%s) in sendfile2", input_filename);

    ap_log_error( "",0,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: %s",mod_gzip_check_permissions);

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: .... fopen() SUCCEEDED",cn);
 mod_gzip_printf( "%s: sizeof( tmp ) = %d",cn,sizeof(tmp));
 mod_gzip_printf( "%s: MOD_GZIP_SENDFILE2_BUFFER_SIZE = %d",
               cn,(int)MOD_GZIP_SENDFILE2_BUFFER_SIZE);
 mod_gzip_printf( "%s: Processing header now...",cn);
 #endif

 for (;;)
    {
     bytesread = fread( tmp, 1, MOD_GZIP_SENDFILE2_BUFFER_SIZE, ifh );

     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: HEADER: %5.5d: Back fread(): bytesread=%d",
                       cn,linecount,bytesread);
     #endif

     if ( bytesread < 1 ) break; 

     p1    = tmp;
     p1len = 0;

     for ( i=0; i<bytesread; i++ )
        {
         if ( *p1 == 10 )
           {
            *p2 = 0; 

            linecount++; 

            if ( valid_char_count < 1 )
              {
               #ifdef MOD_GZIP_DEBUG1
               mod_gzip_printf( "%s: HEADER: %5.5d: lbuf=[CR/LF]",
                                 cn,linecount);
               #endif

               p1++;         
               p1len++;      
               hbytes_in++;  

               header_done = 1; 

               break; 
              }
            else 
              {
               #ifdef MOD_GZIP_DEBUG1
               mod_gzip_printf( "%s: HEADER: %5.5d: lbuf=[%s]",
                                 cn,linecount,lbuf);
               #endif

               if ( linecount == 1 )
                 {
                  p3 = lbuf; 

                  while((*p3!=0)&&(*p3<33)) p3++; 
                  while((*p3!=0)&&(*p3>32)) p3++; 
                  while((*p3!=0)&&(*p3<33)) p3++; 

                  #ifdef MOD_GZIP_DEBUG1
                  mod_gzip_printf( "%s: HEADER: %5.5d: * p3=[%s]",
                                    cn,linecount,npp(p3));
                  #endif

                  if ( *p3 != 0 )
                    {
                     resp_code = (int) atoi( p3 );
                    }

                  #ifdef MOD_GZIP_DEBUG1
                  mod_gzip_printf( "%s: HEADER: %5.5d: * resp_code = %d",
                                    cn,linecount,resp_code);
                  #endif
                 }

               else if ( lbuf[0] == 'T' )
                 {
                  if ( mod_gzip_strnicmp(lbuf,"Transfer-Encoding:",18)==0)
                    {
                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: HEADER: %5.5d: * 'Transfer-Encoding:' seen",
                                       cn,linecount);
                     #endif

                     te_seen = 1; 

                     if ( mod_gzip_stringcontains( lbuf, "chunked" ) )
                       {
                        #ifdef MOD_GZIP_DEBUG1
                        mod_gzip_printf( "%s: HEADER: %5.5d: * 'Transfer-Encoding: chunked' seen",
                                          cn,linecount);
                        #endif

                        te_chunked = 1; 
                       }
                    }
                 }

               else if ( lbuf[0] == 'C' )
                 {
                  if ( mod_gzip_strnicmp(lbuf,"Content-Encoding:",17)==0)
                    {
                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: HEADER: %5.5d: * 'Content-Encoding:' seen",
                                       cn,linecount);
                     #endif

                     ce_seen = 1; 
                    }

                  else if ( mod_gzip_strnicmp(lbuf,"Content-Type:",13)==0)
                    {
                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: HEADER: %5.5d: * 'Content-Type:' seen",
                                       cn,linecount);
                     #endif

                     ct_seen = 1; 

                     p3 = lbuf; 

                     while((*p3!=0)&&(*p3<33)) p3++; 
                     while((*p3!=0)&&(*p3>32)) p3++; 
                     while((*p3!=0)&&(*p3<33)) p3++; 

                     if ( p2len < 230 ) 
                       {
                        mod_gzip_strcpy( ct_value, p3 );
                       }
                     else 
                       {
                        sprintf( ct_value, "%-230.230s", p3 );
                       }

                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: HEADER: %5.5d: * ct_value=[%s]",
                                       cn,linecount,npp(ct_value));
                     #endif
                    }
                 }

                if ( ( fields_excluded < 1 ) &&
                     ( dconf->imap_total_isrspheader > 0 ) )
                  {
                   #ifdef MOD_GZIP_DEBUG1
                   mod_gzip_printf( "%s: dconf->imap_total_isrspheader = %d", cn,
                                   (int) dconf->imap_total_isrspheader );
                   mod_gzip_printf( "%s: Checking RESPONSE header field...", cn );
                   #endif

                   p3 = lbuf; 

                   while((*p3!=0)&&(*p3<33)) p3++; 
                   while((*p3!=0)&&(*p3>32)) p3++; 
                   while((*p3!=0)&&(*p3<33)) p3++; 

                   fieldkey    = lbuf; 
                   fieldstring = p3;   

                   #ifdef MOD_GZIP_DEBUG1
                   mod_gzip_printf( "%s: Call mod_gzip_validate1()...",cn);
                   #endif

                   field_ok =
                   mod_gzip_validate1(
                   (request_rec   *) r,
                   (mod_gzip_conf *) dconf,
                   NULL, /* r->filename     (Not used here) */
                   NULL, /* r->uri          (Not used here) */
                   NULL, /* r->content_type (Not used here) */
                   NULL, /* r->handler      (Not used here) */
                   (char *) fieldkey,     /* Field key */
                   (char *) fieldstring,  /* Field string */
                   MOD_GZIP_RESPONSE      /* Direction */
                   );

                   #ifdef MOD_GZIP_DEBUG1
                   mod_gzip_printf( "%s: Back mod_gzip_validate1()...",cn);
                   mod_gzip_printf( "%s: field_ok = %d",cn,field_ok);
                   #endif

                   if ( field_ok == MOD_GZIP_IMAP_DECLINED1 )
                     {
                      fields_excluded++; 
                     }
                  }
              }

            p2    = lbuf;
            p2len = 0;

            valid_char_count = 0;
           }
         else 
           {
            if ( *p1 > 32 ) valid_char_count++;

            if(p2len >= lbuf_reser * MOD_GZIP_LINE_BUFFER_SIZE) {
              lbuf_reser += 1;
              lbuf        = realloc(lbuf,lbuf_reser * MOD_GZIP_LINE_BUFFER_SIZE + 16);
              p2          = lbuf + p2len;
            }

            if(*p1 != 13) {
              *p2++ = *p1;
              p2len++;
            }
           }

         p1++;        
         p1len++;     
         hbytes_in++; 
        }

     if ( header_done ) break;
    }

 bbytes_total      = raw_input_length - hbytes_in;

 #ifdef CHUNKE_USES_OUTPUT_BUFFER
 chunke_obuf       = lbuf;
 chunke_obufstart  = lbuf;
 chunke_obuflenmax = lbuf_reser;
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Done processing header...",cn);
 mod_gzip_printf( "%s: header_done     = %d",cn,header_done);
 mod_gzip_printf( "%s: fields_excluded = %d",cn,fields_excluded);
 mod_gzip_printf( "%s: bytesread       = %d",cn,bytesread);
 mod_gzip_printf( "%s: p1len           = %d",cn,p1len);
 mod_gzip_printf( "%s: resp_code       = %d (HTTP response code)",cn,resp_code);
 mod_gzip_printf( "%s: hbytes_in       = %ld (Total HEADER bytes read)",cn,(long)hbytes_in);
 mod_gzip_printf( "%s: bbytes_total    = %ld (Total BODY bytes left)",cn,(long)bbytes_total);
 mod_gzip_printf( "%s: te_seen         = %d (Transfer-Encoding:)",cn,te_seen);
 mod_gzip_printf( "%s: te_chunked      = %d (Transfer-Encoding: chunked)",cn,te_chunked);
 mod_gzip_printf( "%s: ce_seen         = %d (Content-Encoding:)",cn,ce_seen);
 mod_gzip_printf( "%s: ct_seen         = %d (Content-Type:)",cn,ct_seen);
 mod_gzip_printf( "%s: ct_value        = [%s]",cn,npp(ct_value));
 mod_gzip_printf( "%s: dconf__dechunk  = %ld",cn,(long)dconf__dechunk);
 #endif

 if ( !header_done )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ERROR: 'header_done' flag is NOT SET",cn);
    mod_gzip_printf( "%s: No valid HTTP 'End of header' was found...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"NO_HTTP_EOH"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: Invalid HTTP response header for r->the_request[%s] in sendfile2", r->the_request);
    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: Invalid HTTP response header in FILE [%s] in sendfile2",input_filename);

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 if ( !resp_code )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ERROR: 'resp_code' value is NOT SET",cn);
    mod_gzip_printf( "%s: No valid HTTP response code was found...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"NO_HTTP_RESP_CODE"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: No valid HTTP response code for r->the_request[%s] in sendfile2", r->the_request);
    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: No valid HTTP response code in FILE [%s] in sendfile2",input_filename);

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: --------------------------------------------------",cn);
 mod_gzip_printf( "%s: Checking for various 'send as is' conditions...",cn);
 mod_gzip_printf( "%s: --------------------------------------------------",cn);
 #endif

 #ifdef MOD_GZIP_USES_APACHE_LOGS
 mod_gzip_strcpy( lbuf, "SEND_AS_IS");
 #endif

 if ( resp_code != 200 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: resp_code is NOT '200'...",cn);
    mod_gzip_printf( "%s: Issuing send_as_is++",cn);
    #endif

    send_as_is++;

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    mod_gzip_strcat( lbuf, ":NO_200");
    #endif
   }

 if ( ( !send_as_is ) && ( fields_excluded > 0 ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'fields_excluded' = %d ( More than ZERO )",
                       cn, fields_excluded );
    mod_gzip_printf( "%s: Issuing send_as_is++",cn);
    #endif

    send_as_is++;

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    mod_gzip_strcat( lbuf, ":RESPONSE_FIELD_EXCLUDED");
    #endif
   }

 if ( ( !send_as_is ) && ( bbytes_total < 1 ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: bbytes_total is less than 1",cn);
    mod_gzip_printf( "%s: There is no valid BODY data.",cn);
    mod_gzip_printf( "%s: Issuing send_as_is++",cn);
    #endif

    send_as_is++;

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    mod_gzip_strcat( lbuf, ":NO_BODY");
    #endif
   }

 if ( ( !send_as_is ) && ( ( te_seen == 1 ) && ( te_chunked == 0 ) ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'Transfer-Encoding:' is present but 'type' is UNKNOWN",cn);
    mod_gzip_printf( "%s: Issuing send_as_is++",cn);
    #endif

    send_as_is++;

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    mod_gzip_strcat( lbuf, ":UNKNOWN_TE_VALUE");
    #endif
   }

 if ( ( !send_as_is ) && ( ce_seen == 1 ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'Content-Encoding:' is already present...",cn);
    mod_gzip_printf( "%s: Issuing send_as_is++",cn);
    #endif

    send_as_is++;

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    mod_gzip_strcat( lbuf, ":HAS_CE");
    #endif
   }

 if ( ( !send_as_is ) && ( ct_seen != 1 ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'Content-Type:' response field NOT PRESENT...",cn);
    mod_gzip_printf( "%s: Issuing send_as_is++",cn);
    #endif

    send_as_is++;

    #ifdef MOD_GZIP_USES_APACHE_LOGS
    mod_gzip_strcat( lbuf, ":NO_CONTENT_TYPE_IN_RESPONSE_HEADER");
    #endif
   }
 else if ( !send_as_is ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'Content-Type:' response field is PRESENT",cn);
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: dconf->imap_total_ismime = %d", cn,
                    (int) dconf->imap_total_ismime );
    #endif

    if ( dconf->imap_total_ismime > 0 )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Call mod_gzip_validate1(ct_value=[%s])...",
                         cn,npp(ct_value));
       #endif

       action_flag =
       mod_gzip_validate1(
       (request_rec   *) r,
       (mod_gzip_conf *) dconf,
       NULL,     /* r->filename  (Not used here) */
       NULL,     /* r->uri       (Not used here) */
       ct_value, /* Content type (Used         ) */
       NULL,     /* r->handler   (Not used here) */
       NULL,     /* Field key    (Not used here) */
       NULL,     /* Field string (Not used here) */
       0         /* Direction    (Not used here) */
       );

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Back mod_gzip_validate1(ct_value=[%s])...",
                         cn,npp(ct_value));
       mod_gzip_printf( "%s: action_flag  = %d",cn,action_flag);
       #endif

       if ( action_flag != MOD_GZIP_IMAP_DECLINED1 )
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: This 'Content-Type:' is NOT EXCLUDED",cn);
          #endif
         }
       else
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: This 'Content-Type:' is EXCLUDED",cn);
          mod_gzip_printf( "%s: Issuing send_as_is++",cn);
          #endif

          send_as_is++;

          #ifdef MOD_GZIP_USES_APACHE_LOGS
          mod_gzip_strcat( lbuf, ":RESPONSE_CONTENT_TYPE_EXCLUDED");
          #endif
         }
      }
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: --------------------------------------------------",cn);
 mod_gzip_printf( "%s: send_as_is   = %d",cn,send_as_is);
 mod_gzip_printf( "%s: --------------------------------------------------",cn);
 #endif

 if ( send_as_is > 0 ) 
   {
    #ifdef MOD_GZIP_USES_APACHE_LOGS
    ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,lbuf));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Sending response 'as is'...",cn);
    mod_gzip_printf( "%s: Issuing 'goto mod_gzip_sendfile2_send_as_is'...",cn);
    #endif

    goto mod_gzip_sendfile2_send_as_is;
   }

 if ( !te_seen )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call fclose(%s)...",cn, npp(input_filename));
    #endif

    fclose( ifh );

    ifh = 0; 

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back fclose(%s)...",cn,npp(input_filename));
    mod_gzip_printf( "%s: Call mod_gzip_encode_and_transmit()...",cn);
    #endif

    rc =
    mod_gzip_encode_and_transmit(
    r,              
    dconf,          
    input_filename, 
    1,              
    bbytes_total,   
    0,              
    hbytes_in,      
    ""              
    );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back mod_gzip_encode_and_transmit()...",cn);
    mod_gzip_printf( "%s: rc = %d",cn,rc);
    #endif

    if ( rc == DECLINED )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: rc = DECLINED (FAILURE)",cn);
       mod_gzip_printf( "%s: Sending response 'as is'...",cn);
       mod_gzip_printf( "%s: Issuing 'goto mod_gzip_sendfile2_send_as_is'...",cn);
       #endif

       goto mod_gzip_sendfile2_send_as_is;
      }

    else 
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: rc = OK (SUCCESS)",cn);
       mod_gzip_printf( "%s: Call goto mod_gzip_sendfile2_cleanup...",cn,rc);
       #endif

       final_rc = rc; 

       goto mod_gzip_sendfile2_cleanup;
      }
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: * TRANSFER ENCODING DE-CHUNKING OPTION",cn);
 mod_gzip_printf( "%s: dconf__dechunk = %ld",cn,(long)dconf__dechunk);
 #endif

 if ( dconf__dechunk ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: dconf__dechunk = YES",cn);
    mod_gzip_printf( "%s: BODY data 'de-chunking' option is ON...",cn);
    #endif
   }
 else 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: dconf__dechunk = NO",cn);
    mod_gzip_printf( "%s: BODY data 'de-chunking' option is OFF...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    ap_table_setn( r->notes,"mod_gzip_result",
    ap_pstrdup(r->pool,"SEND_AS_IS:DECHUNK_OPTION_IS_OFF"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: DECHUNK option is OFF in sendfile2");

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: Cannot compress chunked response for [%s]",
    r->the_request);

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: ** Uncompressed responses that use 'Transfer-encoding: chunked'");

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: ** must be 'de-chunked' before they can be compressed." );

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: ** Turn DECHUNK option ON for this response category." );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Sending response 'as is'...",cn);
    mod_gzip_printf( "%s: Issuing 'goto mod_gzip_sendfile2_send_as_is'...",cn);
    #endif

    goto mod_gzip_sendfile2_send_as_is;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: De-chunking the body data now...",cn);
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Creating 'output_filename1' string now...",cn);
 #endif

 mod_gzip_create_unique_filename(
 dconf__temp_dir,
 (char *) output_filename1,
 MOD_GZIP_MAX_PATH_LEN
 );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: output_filename1 = [%s]",cn,npp(output_filename1));
 mod_gzip_printf( "%s: Call OUTPUT fopen(%s)...",cn,npp(output_filename1));
 #endif

 ofh = fopen( output_filename1, "wb" );

 if ( !ofh ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... OUTPUT fopen() FAILED",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    ap_table_setn( r->notes,"mod_gzip_result",
    ap_pstrdup(r->pool,"SEND_AS_IS:FOPEN_FAILED"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: fopen(%s) for OUTPUT in sendfile2", output_filename1 );

    ap_log_error( "",0,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: %s",mod_gzip_check_permissions);

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Sending response 'as is'...",cn);
    mod_gzip_printf( "%s: Issuing 'goto mod_gzip_sendfile2_send_as_is'...",cn);
    #endif

    goto mod_gzip_sendfile2_send_as_is;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: .... OUTPUT fopen() SUCCEEDED",cn);
 #endif

 ofh_used = 1; 

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call fseek(ifh,0,0)...",cn );
 #endif

 rc = fseek( ifh, 0, 0 );

 if ( rc != 0 ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... fseek(ifh,0,0) FAILED",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    ap_table_setn( r->notes,"mod_gzip_result",
    ap_pstrdup(r->pool,"SEND_AS_IS:FSEEK_FAILED"));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: fseek(ifh,0,0) in sendfile2" );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Sending response 'as is'...",cn);
    mod_gzip_printf( "%s: Issuing 'goto mod_gzip_sendfile2_send_as_is'...",cn);
    #endif

    goto mod_gzip_sendfile2_send_as_is;
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: .... fseek(ifh,0,0) SUCCEEDED",cn);
   }
 #endif

 total_bytes_left_to_copy = hbytes_in;

 #ifdef MOD_GZIP_DEBUG1
 total_bytes_copied = 0;
 mod_gzip_printf( "%s: Copying %ld header bytes now...",
                   cn,(long)total_bytes_left_to_copy);
 #endif

 while( total_bytes_left_to_copy > 0 )
    {
     if ( total_bytes_left_to_copy < MOD_GZIP_SENDFILE2_BUFFER_SIZE )
       {
        bytestoread = total_bytes_left_to_copy;
       }
     else
       {
        bytestoread = MOD_GZIP_SENDFILE2_BUFFER_SIZE;
       }

     bytesread    = fread ( tmp, 1, bytestoread, ifh );
     byteswritten = fwrite( tmp, 1, bytesread,   ofh );

     total_bytes_left_to_copy -= byteswritten;

     #ifdef MOD_GZIP_DEBUG1
     total_bytes_copied += byteswritten;
     #endif
    }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: %ld header bytes have been copied...",
                   cn,(long)total_bytes_copied);
 #endif

 for (;;) 
    {
     p1 = tmp; 

     bytesread = fread( p1, 1, MOD_GZIP_SENDFILE2_BUFFER_SIZE, ifh );

     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: Back fread(): bytesread=%d",cn,bytesread);
     #endif

     if ( bytesread < 1 ) break; 

     bbytes_in += bytesread; 
     bytesleft  = bytesread; 

     if ( te_chunked ) 
       {
        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf( "%s: 'te_chunked' flag is TRUE...",cn);
        mod_gzip_printf( "%s: Filtering chunked data...",cn);
        #endif

        sp = p1; 

        while ( bytesleft > 0 )
          {
           switch( chunke_state )
             {
              case CHUNKE_GET_HEXSTRING:

                   if ((*sp==13)||(*sp==10)||(*sp==';'))
                     {
                      chunke_hexstring[chunke_hexstring_oset]=0;

                      #ifdef MOD_GZIP_CHUNKE_DIAG1
                      mod_gzip_printf("chunke: %5.5ld chunke_hexstring=[%s]\n",
                                       chunke_count, npp(chunke_hexstring) );
                      #endif

                      chunke_realdata_length = (long)
                      strtol(chunke_hexstring,&chunke_errstr,16);

                      #ifdef MOD_GZIP_CHUNKE_DIAG1
                      mod_gzip_printf("chunke: %5.5ld realdata_length= 0x%X %ld\n",
                                 chunke_count, chunke_realdata_length,
                                               chunke_realdata_length );
                      #endif

                      if ( chunke_realdata_length < 1 )
                        {
                         #ifdef MOD_GZIP_CHUNKE_DIAG1
                         mod_gzip_printf("chunke: %5.5ld END OF CHUNKED DATA\n",
                                          chunke_count);
                         #endif
                        }

                      chunke_realdata_read = 0;

                      if ( *sp == 10 ) 
                        {
                         if ( chunke_realdata_length == 0 )
                           {
                            chunke_state = CHUNKE_GET_FOOTER;
                           }
                         else 
                           {
                            chunke_state = CHUNKE_GET_REAL_DATA;
                           }
                        }
                      else 
                        {
                         chunke_state = CHUNKE_WAIT_REAL_EOL1;

                         if ( chunke_realdata_length == 0 )
                           {
                            chunke_nextstate = CHUNKE_GET_FOOTER;
                           }
                         else 
                           {
                            chunke_nextstate = CHUNKE_GET_REAL_DATA;
                           }
                        }
                     }

                   else 
                     {
                      if ( ( chunke_hexstring_oset <
                             CHUNKE_HEXSTRING_MAXLEN ) &&
                           ( *sp > 32 ) )
                        {
                         chunke_hexstring[
                         chunke_hexstring_oset++] = *sp;

                         #ifdef MOD_GZIP_CHUNKE_DIAG1
                         chunke_hexstring[
                         chunke_hexstring_oset ] = 0;
                         #endif
                        }

                      #ifdef MOD_GZIP_CHUNKE_DIAG1
                      mod_gzip_printf("chunke: %5.5ld chunke_hexstring is now [%s]\n",
                                       chunke_count, npp(chunke_hexstring) );
                      #endif
                     }

                   break;

              case CHUNKE_WAIT_REAL_EOL1:

                   if ( *sp == 10 )
                     {
                      #ifdef MOD_GZIP_CHUNKE_DIAG1
                      mod_gzip_printf("chunke: %5.5ld Real EOL seen...\n",
                                       chunke_count );
                      #endif

                      chunke_state = chunke_nextstate;
                     }

                   break;

              case CHUNKE_GET_FOOTER:

                   if ( *sp == 10 )
                     {
                      #ifdef MOD_GZIP_CHUNKE_DIAG1
                      mod_gzip_printf("chunke: %5.5ld FOOTER EOL seen...\n",
                                       chunke_count );
                      #endif
                     }

                   break;

              case CHUNKE_GET_REAL_DATA:

                   #ifdef CHUNKE_USES_OUTPUT_BUFFER

                   *chunke_obuf++ = *sp;
                    chunke_obuflen++;

                   if ( chunke_obuflen >= chunke_obuflenmax )
                     {
                      byteswritten =
                      fwrite(
                      chunke_obufstart,
                      1,
                      chunke_obuflen,
                      ofh
                      );

                      if ( byteswritten > 0 )
                        {
                         bbytes_out += byteswritten;
                        }

                      chunke_obuf    = chunke_obufstart;
                      chunke_obuflen = 0;
                     }

                   chunke_realdata_read++;

                   #else 

                   bytestowrite = bytesleft; 

                   if ( ( chunke_realdata_read + bytesleft ) >
                          chunke_realdata_length )
                     {
                      bytestowrite =
                      chunke_realdata_length - chunke_realdata_read;
                     }

                   byteswritten =
                   fwrite(
                   sp,
                   1,
                   bytestowrite,
                   ofh
                   );

                   if ( byteswritten > 0 )
                     {
                      sp                   += byteswritten;
                      bytesleft            -= byteswritten;
                      bbytes_out           += byteswritten;
                      chunke_realdata_read += byteswritten;

                      skip_advance = 1;
                     }

                   #endif 

                   if ( chunke_realdata_read >=
                        chunke_realdata_length )
                     {
                      #ifdef CHUNKE_USES_OUTPUT_BUFFER

                      if ( chunke_obuflen > 0  )
                        {
                         byteswritten =
                         fwrite(
                         chunke_obufstart,
                         1,
                         chunke_obuflen,
                         ofh
                         );

                         if ( byteswritten > 0 )
                           {
                            bbytes_out += byteswritten;
                           }

                         chunke_obuf    = chunke_obufstart;
                         chunke_obuflen = 0;
                        }

                      #endif 

                      #ifdef MOD_GZIP_CHUNKE_DIAG1
                      mod_gzip_printf("chunke: %5.5ld DONE reading CHUNK data...\n",
                                 chunke_count );
                      mod_gzip_printf("chunke: %5.5ld realdata_length = %ld\n",
                                 chunke_count, chunke_realdata_length );
                      mod_gzip_printf("chunke: %5.5ld realdata_read   = %ld\n",
                                 chunke_count, chunke_realdata_read );
                      mod_gzip_printf("chunke: %5.5ld Increasing 'chunke_count' to %d\n",
                                 chunke_count, chunke_count + 1 );
                      mod_gzip_printf("chunke: %5.5ld Advancing to CHUNKE_WAIT_REAL_EOL1...\n",
                                 chunke_count );
                      #endif

                      chunke_count++;

                      chunke_hexstring[0]    = 0;
                      chunke_hexstring_oset  = 0;
                      chunke_realdata_length = 0;
                      chunke_realdata_read   = 0;

                      chunke_state     = CHUNKE_WAIT_REAL_EOL1;
                      chunke_nextstate = CHUNKE_GET_HEXSTRING;
                     }

                   break;

              default: break;
             }

           if ( skip_advance ) 
             {
              skip_advance = 0; 
             }
           else 
             {
              sp++;        
              bytesleft--; 
             }
          }

        #ifdef FUTURE_USE
        chunke_buffer_scan_done: ; 
        #endif

        #ifdef MOD_GZIP_CHUNKE_DIAG1
        mod_gzip_printf("chunke: %5.5ld Out of next buffer scan loop\n",
                   chunke_count );
        mod_gzip_printf("chunke: %5.5ld realdata_length = %ld\n",
                   chunke_count, chunke_realdata_length );
        mod_gzip_printf("chunke: %5.5ld realdata_read   = %ld\n",
                   chunke_count, chunke_realdata_read );
        mod_gzip_printf("chunke: %5.5ld realdata_left   = %ld\n",
                   chunke_count, chunke_realdata_length - chunke_realdata_read);
        mod_gzip_printf("chunke: %5.5ld Looping back for more input data...\n",
                   chunke_count );
        #endif
       }

     else 
       {
        byteswritten =
        fwrite(
        p1,
        1,
        bytesread,
        ofh
        );

        if ( byteswritten > 0 )
          {
           bbytes_out += byteswritten; 
          }

        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf( "%s: byteswritten = %d",cn,(int)byteswritten);
        #endif

        if ( byteswritten != bytesread )
          {
           err = errno;

           #ifdef FUTURE_USE
           #if defined(WIN32) || defined(NETWARE)
           err = WSAGetLastError();
           #else  
           err = errno;
           #endif 
           #endif 

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: TRANSMIT ERROR: bytesread=%d byteswritten=%d err=%d",
           cn,(int)bytesread,(int)byteswritten,(int)err );
           #endif

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: Breaking out of transmit loop early...",cn);
           #endif

           body_done = 1; 
           break;         
          }
       }

     if ( body_done ) break;
    }

 bbytes_total = bbytes_out;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Done processing BODY...",cn);
 mod_gzip_printf( "%s: Call fclose(ofh)...",cn);
 #endif

 fclose( ofh ); ofh = 0;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back fclose(ofh)...",cn);
 mod_gzip_printf( "%s: bbytes_in    = %ld (Total BODY bytes read)",cn,(long)bbytes_in);
 mod_gzip_printf( "%s: bbytes_out   = %ld (Total BODY bytes written)",cn,(long)bbytes_out);
 mod_gzip_printf( "%s: bbytes_total = %ld (Same as bbytes_out)",cn,(long)bbytes_total);
 #endif

 if ( bbytes_total > 0 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call fclose(%s)...",cn, npp(input_filename));
    #endif

    fclose( ifh ); ifh = 0;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back fclose(%s)...",cn, npp(input_filename));
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call mod_gzip_encode_and_transmit()...",cn);
    #endif

    rc =
    mod_gzip_encode_and_transmit(
    r,                
    dconf,            
    output_filename1, 
    1,                
    bbytes_total,     
    0,                
    hbytes_in,        
    "DECHUNK:"        
    );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back mod_gzip_encode_and_transmit()...",cn);
    mod_gzip_printf( "%s: rc = %d",cn,rc);
    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: dconf__keep_workfiles = %d",
                      cn, dconf__keep_workfiles );
    #endif

    if ( !dconf__keep_workfiles ) 
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Call mod_gzip_delete_file(output_filename1=[%s])...",
                         cn, npp(output_filename1));
       #endif

       mod_gzip_delete_file( r, output_filename1 );

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Back mod_gzip_delete_file(output_filename1=[%s])...",
                         cn, npp(output_filename1));
       #endif
      }

    if ( rc == DECLINED )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: rc = DECLINED (FAILURE)",cn);
       mod_gzip_printf( "%s: Sending response 'as is'...",cn);
       mod_gzip_printf( "%s: Issuing 'goto mod_gzip_sendfile2_send_as_is'...",cn);
       #endif

       goto mod_gzip_sendfile2_send_as_is;
      }

    else 
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: rc = OK (SUCCESS)",cn);
       mod_gzip_printf( "%s: Call goto mod_gzip_sendfile2_cleanup...",cn,rc);
       #endif

       final_rc = rc; 

       goto mod_gzip_sendfile2_cleanup;
      }
   }

 else 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ERROR: bbytes_total is ZERO",cn);
    mod_gzip_printf( "%s: ERROR: Original response must be sent 'as is'",cn);
    mod_gzip_printf( "%s: Issuing 'goto mod_gzip_sendfile2_send_as_is'...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    ap_table_setn( r->notes,"mod_gzip_result",
    ap_pstrdup(r->pool,"SEND_AS_IS:BODY_MISSING"));
    #endif

    goto mod_gzip_sendfile2_send_as_is;
   }

 mod_gzip_sendfile2_send_as_is: ;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: * SEND 'AS IS'...",cn);
 mod_gzip_printf( "%s: * label entry point: mod_gzip_sendfile2_send_as_is",cn);
 mod_gzip_printf( "%s: Sending response 'as is'...",cn);
 #endif

 if ( !ifh )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Input file was closed.",cn);
    mod_gzip_printf( "%s: Re-opening input_filename[%s]...",
                      cn, npp(input_filename));
    #endif

    ifh = fopen( input_filename, "rb" ); 

    if ( !ifh ) 
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: .... fopen() FAILED",cn);
       #endif

       ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
       "mod_gzip: fopen(%s) on REOPEN in sendfile2", input_filename );

       final_rc = DECLINED;

       goto mod_gzip_sendfile2_cleanup;
      }

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... fopen() SUCCEEDED",cn);
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call mod_gzip_sendfile1()...",cn);
 #endif

 total_bytes_sent = (long)
 mod_gzip_sendfile1(
 r,    
 NULL, 
 ifh,  
 0     
 );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back mod_gzip_sendfile1()...",cn);
 mod_gzip_printf( "%s: .... total_bytes_sent = %ld",cn,(long)total_bytes_sent);
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call mod_gzip_flush_and_update_counts()...",cn);
 #endif

 mod_gzip_flush_and_update_counts(
 r,
 dconf,
 hbytes_in,                   
 total_bytes_sent - hbytes_in 
 );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back mod_gzip_flush_and_update_counts()...",cn);
 #endif

 final_rc = rc; 

 mod_gzip_sendfile2_cleanup: ;

 free(lbuf);

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: * FINAL CLEANUP",cn);
 mod_gzip_printf( "%s: * label entry point: mod_gzip_sendfile2_cleanup",cn);
 mod_gzip_printf( "%s: dconf__keep_workfiles = %ld",cn,(long)dconf__keep_workfiles);
 mod_gzip_printf( "%s: ifh = %ld (Input  file handle)",cn,(long)ifh);
 #endif

 if ( ifh )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Input file is still OPEN...",cn );
    mod_gzip_printf( "%s: Call fclose(%s)...",cn, npp(input_filename));
    #endif

    fclose( ifh ); ifh = 0;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back fclose(%s)...",cn,npp(input_filename));
    #endif
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: Input file is already CLOSED...",cn );
    mod_gzip_printf( "%s: NO CALL MADE TO fclose(%s)",cn,npp(input_filename));
   }
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Caller must delete input_filename=[%s]",
                   cn, npp(input_filename));
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: ofh_used = %ld (Output file usage flag)",cn,(long)ofh_used);
 mod_gzip_printf( "%s: ofh      = %ld (Output file handle)",cn,(long)ofh);
 #endif

 if ( ofh_used ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: 'ofh_used' is TRUE",cn );
    #endif

    if ( ofh ) 
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Output file is still OPEN...",cn );
       mod_gzip_printf( "%s: Call fclose(output_filename1=[%s])...",
                         cn, npp(output_filename1));
       #endif

       fclose( ofh ); ofh = 0;

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Back fclose(output_filename1=[%s])...",
                         cn, npp(output_filename1));
       #endif
      }
    #ifdef MOD_GZIP_DEBUG1
    else
      {
       mod_gzip_printf( "%s: 'ofh' is NULL. File is already CLOSED.",cn );
      }
    #endif

    if ( !dconf__keep_workfiles )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: 'dconf__keep_workfiles' is FALSE",cn );
       mod_gzip_printf( "%s: Call mod_gzip_delete_file(output_filename1=[%s])...",
                         cn, npp(output_filename1));
       #endif

       mod_gzip_delete_file( r, output_filename1 );

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Back mod_gzip_delete_file(output_filename1=[%s])...",
                         cn, npp(output_filename1));
       #endif
      }

    #ifdef MOD_GZIP_DEBUG1
    else
      {
       mod_gzip_printf( "%s: 'dconf__keep_workfiles' is TRUE.",cn );
       mod_gzip_printf( "%s: Keeping output_filename1=[%s]",
                         cn, npp(output_filename1));
      }
    #endif

    ofh_used = 0; 
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: 'ofh_used' is FALSE",cn );
    mod_gzip_printf( "%s: Output file was NOT USED",cn );
   }
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: final_rc was......: %d",cn,final_rc);
 #endif

 final_rc = OK;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: final_rc is now...: %d",cn,final_rc);
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Exit > return( final_rc = %d ) >",cn,final_rc);
 #endif

 return final_rc; 
}

long mod_gzip_send_header(
request_rec *r,
char        *input_filename,
long         content_length
)
{
 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_send_header()";
 #endif

 FILE *ifh=0;

 int i;
 int bytesread=0;
 int ok_to_send=0;
 int valid_char_count=0;

 #define   MOD_GZIP_SEND_HEADER_BUFFER_SIZE 4096
 char tmp[ MOD_GZIP_SEND_HEADER_BUFFER_SIZE + 16 ];

 #define MOD_GZIP_LINE_BUFFER_SIZE 2048
 char lbuf[ MOD_GZIP_LINE_BUFFER_SIZE + 16 ];

 char *p1;
 int   p1len = 0;

 char *p2    = lbuf;
 int   p2len = 0;

 int  send_header = 0; 
 int  header_done = 0; 
 int  te_seen     = 0; 
 int  te_chunked  = 0; 
 int  ce_seen     = 0; 

 long hbytes_in   = 0; 
 long hbytes_out  = 0; 

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...",cn);
 mod_gzip_printf( "%s: input_filename = [%s]",cn,npp(input_filename));
 mod_gzip_printf( "%s: content_length = %ld", cn,(long)content_length);
 #endif

 if ( !r              ) return 0;
 if ( !input_filename ) return 0;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call fopen(%s)...",cn,npp(input_filename));
 #endif

 ifh = fopen( input_filename, "rb" ); 

 if ( !ifh ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: .... fopen() FAILED",cn);
    mod_gzip_printf( "%s: Exit > return( 0 ) >",cn);
    #endif

    return( 0 ); 
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: .... fopen() SUCCEEDED",cn);
 mod_gzip_printf( "%s: sizeof( tmp ) = %d",cn,sizeof(tmp));
 mod_gzip_printf( "%s: MOD_GZIP_SEND_HEADER_BUFFER_SIZE = %d",
               cn,(int)MOD_GZIP_SEND_HEADER_BUFFER_SIZE);
 mod_gzip_printf( "%s: Processing header now...",cn);
 #endif

 send_header = 1;

 for (;;)
    {
     bytesread = fread( tmp, 1, MOD_GZIP_SEND_HEADER_BUFFER_SIZE, ifh );

     #ifdef MOD_GZIP_DEBUG1
     mod_gzip_printf( "%s: HEADER: Back fread(): bytesread=%d",cn,bytesread);
     #endif

     if ( bytesread < 1 ) break; 

     p1    = tmp;
     p1len = 0;

     for ( i=0; i<bytesread; i++ )
        {
         if ( *p1 == 10 )
           {
            *p2 = 0; 

            if ( valid_char_count < 1 )
              {
               p1++;         
               p1len++;      
               hbytes_in++;  

               sprintf( lbuf, "Content-Encoding: gzip" );

               #ifdef MOD_GZIP_DEBUG1
               mod_gzip_printf( "%s: HEADER: ADDING: lbuf=[%s]",cn,npp(lbuf));
               #endif

               mod_gzip_strcat( lbuf, "\r\n" );

               if ( send_header )
                 {
                  hbytes_out += mod_gzip_send(lbuf,mod_gzip_strlen(lbuf),r);
                 }

               sprintf( lbuf, "Content-Length: %ld",(long)content_length);

               #ifdef MOD_GZIP_DEBUG1
               mod_gzip_printf( "%s: HEADER: ADDING: lbuf=[%s]",cn,npp(lbuf));
               #endif

               mod_gzip_strcat( lbuf, "\r\n" );

               if ( send_header )
                 {
                  hbytes_out += mod_gzip_send(lbuf,mod_gzip_strlen(lbuf),r);
                 }

               #ifdef MOD_GZIP_DEBUG1
               mod_gzip_printf( "%s: HEADER: ADDING: lbuf=[CR/LF]",cn);
               #endif

               if ( send_header )
                 {
                  hbytes_out += mod_gzip_send("\r\n",2,r);
                 }

               header_done = 1; 

               break; 
              }
            else 
              {
               ok_to_send = 1; 

               if ( lbuf[0] == 'T' )
                 {
                  if ( mod_gzip_strnicmp(lbuf,"Transfer-Encoding:",18)==0)
                    {
                     #ifdef MOD_GZIP_DEBUG1
                     mod_gzip_printf( "%s: HEADER: * 'Transfer-Encoding:' seen",cn);
                     #endif

                     te_seen = 1; 

                     if ( mod_gzip_stringcontains( lbuf, "chunked" ) )
                       {
                        #ifdef MOD_GZIP_DEBUG1
                        mod_gzip_printf( "%s: HEADER: * 'Transfer-Encoding: chunked' seen",cn);
                        #endif

                        te_chunked = 1; 
                        ok_to_send = 0; 
                       }
                    }
                 }

               #ifdef FUTURE_USE
               else if ( lbuf[0] == 'E' )
                 {
                  if ( mod_gzip_strnicmp(lbuf,"ETag:",5)==0)
                    {
                     ok_to_send = 0; 
                    }
                 }
               #endif

               else if ( lbuf[0] == 'C' )
                 {
                  if ( mod_gzip_strnicmp(lbuf,"Content-Encoding:",17)==0)
                    {
                     ce_seen = 1; 
                    }
                  else if ( mod_gzip_strnicmp(lbuf,"Content-Length:",15)==0)
                    {
                     ok_to_send = 0; 
                    }
                 }

               if ( ok_to_send )
                 {
                  #ifdef MOD_GZIP_DEBUG1
                  mod_gzip_printf( "%s: HEADER: Sending lbuf=[%s]",cn,npp(lbuf));
                  #endif

                  *p2++ = 13; p2len++;
                  *p2++ = 10; p2len++;
                  *p2++ = 0;

                  if ( send_header )
                    {
                     hbytes_out += mod_gzip_send( lbuf, p2len, r );
                    }
                 }
               #ifdef MOD_GZIP_DEBUG1
               else
                 {
                  #ifdef MOD_GZIP_DEBUG1
                  mod_gzip_printf( "%s: HEADER: NOSEND: lbuf=[%s]",cn,npp(lbuf));
                  #endif
                 }
               #endif
              }

            p2    = lbuf;
            p2len = 0;

            valid_char_count = 0;
           }
         else 
           {
            if ( *p1 > 32 ) valid_char_count++;

            if (( p2len < MOD_GZIP_LINE_BUFFER_SIZE )&&( *p1 != 13 ))
              {
               *p2++ = *p1;
               p2len++;
              }
           }

         p1++;        
         p1len++;     
         hbytes_in++; 
        }

     if ( header_done ) break;
    }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Done processing header...",cn);
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call fclose(%s)...",cn,npp(input_filename));
 #endif

 fclose( ifh ); ifh = 0;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back fclose(%s)...",cn,npp(input_filename));
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: p1len        = %d",cn,p1len);
 mod_gzip_printf( "%s: hbytes_in    = %ld (Total HEADER bytes read)",cn,(long)hbytes_in);
 mod_gzip_printf( "%s: hbytes_out   = %ld (Total HEADER bytes sent)",cn,(long)hbytes_out);
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Exit > return( hbytes_out = %d ) >",cn,hbytes_out);
 #endif

 return (long) hbytes_out; 
}

FILE *mod_gzip_open_output_file(
request_rec *r,
char *output_filename,
int  *rc
)
{
 FILE *ifh;

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_open_output_file():::";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...",cn);
 mod_gzip_printf( "%s: output_filename=[%s]",cn,npp(output_filename));
 #endif

 ifh = fopen( output_filename, "rb" ); 

 if ( !ifh ) 
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ERROR: Cannot open file [%s]",
                      cn,npp(output_filename));
    #endif

    ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
    "mod_gzip: Cannot re-open output_filename=[%s]",
    output_filename );

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    ap_table_setn(
    r->notes,"mod_gzip_result",ap_pstrdup(r->pool,"SEND_AS_IS:WORK_OPENFAIL"));

    #endif 

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( NULL ) >",cn);
    #endif

    *rc = DECLINED; 

    return NULL;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: File is now open...",cn);
 mod_gzip_printf( "%s: Exit > return( FILE *ifh ) >",cn);
 #endif

 *rc = OK; 

 return ifh; 
}

int mod_gzip_flush_and_update_counts(
request_rec   *r,
mod_gzip_conf *dconf,
long           total_header_bytes_sent,
long           total_body_bytes_sent
)
{
 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_flush_and_update_counts()";
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry",cn);
 mod_gzip_printf( "%s: total_header_bytes_sent = %ld",
              cn,(long)total_header_bytes_sent);
 mod_gzip_printf( "%s: total_body_bytes_sent   = %ld",
              cn,(long)total_body_bytes_sent);
 mod_gzip_printf( "%s: total_bytes_sent (Sum)  = %ld",
              cn,(long)total_header_bytes_sent +
                       total_body_bytes_sent );
 mod_gzip_printf( "%s: dconf->add_header_count = %d",
              cn,(int )dconf->add_header_count );
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Before... ap_rflush()...",cn);
 mod_gzip_printf( "%s: r->connection->client->outcnt     = %ld",
             cn,(long) r->connection->client->outcnt );
 mod_gzip_printf( "%s: r->connection->client->bytes_sent = %ld",
             cn,(long) r->connection->client->bytes_sent );
 mod_gzip_printf( "%s: Call..... ap_rflush()...",cn);
 #endif

 ap_rflush(r);

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back..... ap_rflush()...",cn);
 mod_gzip_printf( "%s: After.... ap_rflush()...",cn);
 mod_gzip_printf( "%s: r->connection->client->outcnt     = %ld",
             cn,(long) r->connection->client->outcnt );
 mod_gzip_printf( "%s: r->connection->client->bytes_sent = %ld",
             cn,(long) r->connection->client->bytes_sent );
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf->add_header_count = %ld",
              cn,(long)dconf->add_header_count);
 #endif

 if ( dconf->add_header_count )
   {
    r->connection->client->bytes_sent =
    total_header_bytes_sent + total_body_bytes_sent;
   }
 else 
   {
    r->connection->client->bytes_sent = total_body_bytes_sent;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: After count update...",cn);
 mod_gzip_printf( "%s: r->connection->client->outcnt     = %ld",
             cn,(long) r->connection->client->outcnt );
 mod_gzip_printf( "%s: r->connection->client->bytes_sent = %ld",
             cn,(long) r->connection->client->bytes_sent );
 mod_gzip_printf( "%s: Exit > return( 1 ) >",cn);
 #endif

 return 1;
}

int mod_gzip_encode_and_transmit(
request_rec   *r,
mod_gzip_conf *dconf,
char          *source,
int            source_is_a_file,
long           input_size,
int            nodecline,
long           header_length,
char          *result_prefix_string
)
{
 char *prefix_string = result_prefix_string;

 GZP_CONTROL   gzc;
 GZP_CONTROL*  gzp = &gzc;

 int   rc                = 0;
 int   err               = 0;
 FILE *ifh               = 0;
 int   bytesread         = 0;
 long  byteswritten      = 0;
 long  output_size       = 0;
 long  compression_ratio = 0;
 char *gz1_ismem_obuf    = 0;
 int   finalize_stats    = 1;
 long  output_offset     = 0;

 long  total_bytes_sent             = 0;
 long  total_header_bytes_sent      = 0;
 long  total_compressed_bytes_sent  = 0;
 int   gz1_ismem_obuf_was_allocated = 0;

 #define MOD_GZIP_LARGE_BUFFER_SIZE 4000

 char tmp[ MOD_GZIP_LARGE_BUFFER_SIZE + 2 ];

 char actual_content_encoding_name[] = "gzip";

 char dummy_result_prefix_string[] = "";

 #ifdef MOD_GZIP_DEBUG1
 char scratch2[90];
 #endif

 #ifdef MOD_GZIP_DEBUG1
 char cn[]="mod_gzip_encode_and_transmit()";
 #endif

 #ifdef MOD_GZIP_USES_APACHE_LOGS
 char log_info[90];
 #endif

 char *dconf__temp_dir           = 0;
 int   dconf__keep_workfiles     = 0;
 long  dconf__minimum_file_size  = 300;
 long  dconf__maximum_file_size  = 0;
 long  dconf__maximum_inmem_size = 0;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Entry...", cn);
 #endif

 /*
  * Initialize the GZP control deck on the stack with some
  * safe default values. As of this writing the filename and
  * scratch buffers do not need to be fully reset on entry
  * so there is no need to suffer the overhead of a full
  * 'memset( gzp, 0, sizeof( GZP_CONTROL )' call.
  */

 gzp->decompress           = 0;
 gzp->input_ismem          = 0;
 gzp->input_ismem_ibuf     = 0;
 gzp->input_ismem_ibuflen  = 0;
 gzp->input_filename[0]    = 0;
 gzp->input_offset         = header_length;
 gzp->output_ismem         = 0;
 gzp->output_ismem_obuf    = 0;
 gzp->output_ismem_obuflen = 0;
 gzp->output_filename[0]   = 0;
 gzp->result_code          = 0;
 gzp->bytes_out            = 0;

 if ( dconf )
   {
    dconf__keep_workfiles     = dconf->keep_workfiles;
    dconf__minimum_file_size  = dconf->minimum_file_size;
    dconf__maximum_file_size  = dconf->maximum_file_size;
    dconf__maximum_inmem_size = dconf->maximum_inmem_size;
    dconf__temp_dir           = dconf->temp_dir;
   }

 #ifdef MOD_GZIP_DEBUG1

 mod_gzip_printf( "%s: dconf__keep_workfiles     = %d",  cn, (int) dconf__keep_workfiles );
 mod_gzip_printf( "%s: dconf__temp_dir           = [%s]",cn, npp(dconf__temp_dir));
 mod_gzip_printf( "%s: dconf__minimum_file_size  = %ld", cn, (long) dconf__minimum_file_size );
 mod_gzip_printf( "%s: dconf__maximum_file_size  = %ld", cn, (long) dconf__maximum_file_size );
 mod_gzip_printf( "%s: dconf__maximum_inmem_size = %ld", cn, (long) dconf__maximum_inmem_size );

 mod_gzip_printf( "%s: source_is_a_file = %d",  cn, source_is_a_file );
 mod_gzip_printf( "%s: nodecline        = %d",  cn, nodecline );
 mod_gzip_printf( "%s: header_length    = %ld", cn, header_length );

 if ( source_is_a_file )
   {
    mod_gzip_printf( "%s: source = [%s]", cn, npp(source));
   }
 else
   {
    mod_gzip_printf( "%s: source = MEMORY BUFFER", cn );
   }

 mod_gzip_printf( "%s: input_size = %ld", cn,(long)input_size);

 #endif

 #ifdef MOD_GZIP_USES_APACHE_LOGS

 if ( !prefix_string )
   {
    prefix_string = dummy_result_prefix_string;
   }

 sprintf( log_info,"%sOK", prefix_string );

 ap_table_setn(
 r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

 sprintf( log_info,"%d", (int) input_size );
 ap_table_setn( r->notes,"mod_gzip_input_size",ap_pstrdup(r->pool,log_info));

 #endif

 if ( input_size < 1 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: ERROR: Input source has no valid length.",cn);
    mod_gzip_printf( "%s: This request will not be processed...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    sprintf( log_info,"%sDECLINED:NO_ILEN", prefix_string );

    ap_table_setn(
    r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf__minimum_file_size  = %ld",
            cn, (long) dconf__minimum_file_size );
 #endif

 if ( input_size < (long) dconf__minimum_file_size )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Source does not meet the minimum size requirement...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    sprintf( log_info,"%sDECLINED:TOO_SMALL", prefix_string );

    ap_table_setn(
    r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Source meets the minimum size requirement.",cn);
    mod_gzip_printf( "%s: Assuming OK to proceed...",cn);
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf__maximum_file_size = %ld",
            cn, (long) dconf__maximum_file_size );
 #endif

 if ( ( dconf__maximum_file_size > 0 ) &&
      ( input_size > (long) dconf__maximum_file_size ) )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Source exceeds the maximum size limit...",cn);
    #endif

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    sprintf( log_info,"%sDECLINED:TOO_BIG", prefix_string );

    ap_table_setn(
    r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

    #endif

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Source does not exceed the maximum size limit.",cn);
    mod_gzip_printf( "%s: Assuming OK to proceed...",cn);
    #endif
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: dconf__maximum_inmem_size = %ld",
            cn, (long) dconf__maximum_inmem_size );
 #endif

 if ( source_is_a_file )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Input source is file[%s]",cn,npp(source));
    #endif

    mod_gzip_strcpy( gzp->input_filename, source );

    gzp->input_ismem         = 0;
    gzp->input_ismem_ibuf    = 0;
    gzp->input_ismem_ibuflen = 0;
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Input source is a MEMORY BUFFER",cn);
    #endif

    gzp->input_ismem         = 1;
    gzp->input_ismem_ibuf    = source;
    gzp->input_ismem_ibuflen = input_size;
   }

 gzp->decompress = 0;

 if ( dconf__maximum_inmem_size > (long) 60000L )
   {
    /* TODO: Some OS'es will have a 'malloc()' problem if the */
    /* in-memory size is greater than 64k so for now just set */
    /* 60k as the fixed upper limit. Expand this later. */

    /* NOTE: Testing has shown that for responses greater than */
    /* 60k or so the 'swap to disk' option SHOULD be used, anyway. */
    /* MOST responses will be far less than 60k. */

    dconf__maximum_inmem_size = (long) 60000L;
   }

 if ( input_size < (long) dconf__maximum_inmem_size )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Input source is small enough for in-memory compression.",cn);
    #endif

    *gzp->output_filename = 0;
     gzp->output_ismem    = 1;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Call malloc( input_size + 1000 = %ld )...",
                     cn,(long)(input_size+1000));
    #endif

    gz1_ismem_obuf = (char *) malloc( input_size + 1000 );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back malloc( input_size + 1000 = %ld )...",
                     cn,(long)(input_size+1000));
    #endif

    if ( !gz1_ismem_obuf )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: ERROR: Cannot allocate GZP memory...",cn);
       mod_gzip_printf( "%s: Defaulting to output file method... ",cn);
       #endif

       gzp->output_ismem = 0;
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: ( %ld + 1000 ) bytes allocated OK",cn,(long)input_size);
       #endif

       gz1_ismem_obuf_was_allocated = 1;

       /* TODO: This probably isn't necessary and just wastes time... */
       memset( gz1_ismem_obuf, 0, ( input_size + 1000 ) );

       gzp->output_ismem_obuf    = gz1_ismem_obuf;
       gzp->output_ismem_obuflen = input_size + 1000;
      }
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: Input source is too large for in-memory compression.",cn);
   }
 #endif

 if ( gzp->output_ismem != 1 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Ouput target is a FILE...",cn);
    #endif

    mod_gzip_create_unique_filename(
    dconf__temp_dir,
    (char *) gzp->output_filename,
    MOD_GZIP_MAX_PATH_LEN
    );

    gzp->output_ismem         = 0;
    gz1_ismem_obuf            = 0;
    gzp->output_ismem_obuf    = 0;
    gzp->output_ismem_obuflen = 0;
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: gzp->decompress      = %d"  ,cn,gzp->decompress);
 mod_gzip_printf( "%s: gzp->input_ismem     = %d",  cn,gzp->input_ismem);
 mod_gzip_printf( "%s: gzp->output_ismem    = %d",  cn,gzp->output_ismem);
 mod_gzip_printf( "%s: gzp->input_filename  = [%s]",cn,npp(gzp->input_filename));
 mod_gzip_printf( "%s: gzp->input_offset    = %ld", cn,gzp->input_offset);
 mod_gzip_printf( "%s: gzp->output_filename = [%s]",cn,npp(gzp->output_filename));
 mod_gzip_printf( "%s: Call gzp_main(r,gzp)...",cn);
 #endif

 rc = gzp_main( r, gzp );

 output_size = (long) gzp->bytes_out;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back gzp_main(r,gzp)...",cn);
 mod_gzip_printf( "%s: input_size     = %ld",cn,(long)input_size);
 mod_gzip_printf( "%s: output_size    = %ld",cn,(long)output_size);
 mod_gzip_printf( "%s: gzp->bytes_out = %ld",cn,(long)gzp->bytes_out);
 mod_gzip_printf( "%s: Bytes saved    = %ld",cn,
                 (long)input_size-gzp->bytes_out );
 #endif

 compression_ratio = 0;

 if ( ( input_size  > 0 ) &&
      ( output_size > 0 ) )
   {
    compression_ratio = 100 - (int)
    ( output_size * 100L / input_size );
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Compression    = %ld percent",cn,
          (long) compression_ratio );
 #endif

 #ifdef MOD_GZIP_USES_APACHE_LOGS

 sprintf( log_info,"%d", (int) output_size );
 ap_table_setn( r->notes,"mod_gzip_output_size",ap_pstrdup(r->pool,log_info));

 sprintf( log_info,"%d", (int) compression_ratio );
 ap_table_setn( r->notes,"mod_gzip_compression_ratio",ap_pstrdup(r->pool,log_info));

 #endif

 if ( output_size < 1 )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Compressed version has no length.",cn);
    mod_gzip_printf( "%s: Sending the original version uncompressed...",cn);
    #endif

    finalize_stats = 0;

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    sprintf( log_info,"%sDECLINED:NO_OLEN", prefix_string );

    ap_table_setn(
    r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

    #endif

    if ( gz1_ismem_obuf )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: gz1_ismem_obuf is still a VALID pointer",cn);
       mod_gzip_printf( "%s: gz1_ismem_obuf_was_allocated = %d",
                    cn,(int) gz1_ismem_obuf_was_allocated );
       #endif

       if ( gz1_ismem_obuf_was_allocated )
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: Call free( gz1_ismem_obuf )...",cn);
          #endif

          free( gz1_ismem_obuf );

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: Back free( gz1_ismem_obuf )...",cn);
          #endif

          gz1_ismem_obuf = 0;
          gz1_ismem_obuf_was_allocated = 0;
         }
       else {
         #ifdef MOD_GZIP_DEBUG1
         mod_gzip_printf("%s: Output source was a WORKFILE...",cn);
         mod_gzip_printf("%s: Closing workfile [%s]...",cn,npp(gzp->output_filename));

         mod_gzip_printf("%s: dconf__keep_workfiles = %d",cn, dconf__keep_workfiles);
         #endif

         if(!dconf__keep_workfiles) {
           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: Deleting workfile [%s]...",cn,npp(gzp->output_filename));
           #endif

           #ifdef WIN32
           DeleteFile( gzp->output_filename );
           #else
           unlink( gzp->output_filename );
           #endif
         }
         else {
         #ifdef MOD_GZIP_DEBUG1
         mod_gzip_printf( "%s: Keeping workfile [%s]...",cn,npp(gzp->output_filename));
         #endif
         }
       }
 
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
       #endif

      }


    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }

 if ( output_size > input_size )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Compressed version is larger than original.",cn);
    mod_gzip_printf( "%s: Sending the original version uncompressed...",cn);
    #endif

    finalize_stats = 0;

    #ifdef MOD_GZIP_USES_APACHE_LOGS

    sprintf( log_info,"%sDECLINED:ORIGINAL_SMALLER", prefix_string );

    ap_table_setn(
    r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

    #endif

    if ( gz1_ismem_obuf )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: gz1_ismem_obuf is still a VALID pointer",cn);
       mod_gzip_printf( "%s: gz1_ismem_obuf_was_allocated = %d",
                    cn,(int) gz1_ismem_obuf_was_allocated );
       #endif

       if ( gz1_ismem_obuf_was_allocated )
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: Call free( gz1_ismem_obuf )...",cn);
          #endif

          free( gz1_ismem_obuf );

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: Back free( gz1_ismem_obuf )...",cn);
          #endif

          gz1_ismem_obuf = 0;
          gz1_ismem_obuf_was_allocated = 0;
         }
      }

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
    #endif

    return DECLINED;
   }
 #ifdef MOD_GZIP_DEBUG1
 else
   {
    mod_gzip_printf( "%s: Compressed version is smaller than original.",cn);
    mod_gzip_printf( "%s: Sending the compressed version...",cn);
   }
 #endif

 if ( !gzp->output_ismem )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Re-opening compressed output file [%s]...",
             cn, npp(gzp->output_filename));
    #endif

    ifh = mod_gzip_open_output_file( r, gzp->output_filename, &rc );

    if ( !ifh )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: ERROR: Cannot re-open file [%s]",
                cn,npp(gzp->output_filename));
       #endif

       #ifdef MOD_GZIP_USES_APACHE_LOGS

       sprintf( log_info,"%sDECLINED:REOPEN_FAILED", prefix_string );

       ap_table_setn(
       r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

       #endif

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Exit > return( DECLINED ) >",cn);
       #endif

       return DECLINED;
      }

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Workfile re-opened OK...",cn);
    #endif
   }

 /* TODO: This isn't really necessary? */
 r->content_encoding = actual_content_encoding_name;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: r->content_encoding is now [%s]",
               cn, npp(r->content_encoding));
 #endif

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Starting transmit phase...",cn);
 mod_gzip_printf( "%s: output_offset   = %ld",cn, (long) output_offset );
 #endif

 /* Send the response header... */

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Call mod_gzip_send_header(source=%s)",cn,npp(source));
 #endif

 total_header_bytes_sent = (int)
 mod_gzip_send_header(
 r,
 source,
 output_size
 );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back mod_gzip_send_header(source=%s)",cn,npp(source));
 mod_gzip_printf( "%s: total_header_bytes_sent = %d",cn,rc);
 #endif

 total_compressed_bytes_sent = 0;

 /* Send the compressed data.. */

 if ( gzp->output_ismem )
   {
    #ifdef MOD_GZIP_DEBUG1

    mod_gzip_printf( "%s: Sending in-memory output buffer...",cn);
    mod_gzip_printf( "%s: output_size   = %ld",cn,(long)output_size);
    mod_gzip_printf( "%s: output_offset = %ld",cn,(long)output_offset);

    #ifdef  MOD_GZIP_DUMP_JUST_BEFORE_SENDING
    mod_gzip_hexdump( gz1_ismem_obuf, output_size );
    #endif

    mod_gzip_printf( "%s: Call mod_gzip_send( gz1_ismem_obuf+output_offset=%ld, output_size=%ld )...",
                     cn, (long) output_offset, (long) output_size );
    #endif

    byteswritten = (long)
    mod_gzip_send( gz1_ismem_obuf+output_offset, output_size, r );

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Back mod_gzip_send( gz1_ismem_obuf+output_offset=%ld, output_size=%ld )...",
                     cn, (long) output_offset, (long) output_size );
    mod_gzip_printf( "%s: byteswritten = %ld",cn,(long)byteswritten);
    #endif

    if ( byteswritten > 0 )
      {
       total_compressed_bytes_sent = byteswritten;
      }

    if ( byteswritten != output_size )
      {
       err = errno;

       #ifdef FUTURE_USE
       #if defined(WIN32) || defined(NETWARE)
       err = WSAGetLastError();
       #else
       err = errno;
       #endif
       #endif

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: TRANSMIT ERROR: output_size=%ld byteswritten=%ld err=%d",
       cn,(long)output_size,(long)byteswritten,(int)err );
       #endif

       #ifdef MOG_GZIP_DEBUG1

       mod_gzip_log_comerror( r, "mod_gzip: TRANSMIT_ERROR:", err );

       #else

       ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
       "mod_gzip: TRANSMIT_ERROR:ISMEM:%d",(int)err);

       #endif

       #ifdef MOD_GZIP_USES_APACHE_LOGS

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_translate_comerror( err, scratch2 );
       sprintf( log_info,"%sTRANSMIT_ERROR:ISMEM:%d:%s", prefix_string, (int) err, scratch2 );
       #else
       sprintf( log_info,"%sTRANSMIT_ERROR:ISMEM:%d", prefix_string, (int) err );
       #endif

       ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

       #endif
      }
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: sizeof( tmp )              = %d",cn,sizeof(tmp));
    mod_gzip_printf( "%s: MOD_GZIP_LARGE_BUFFER_SIZE = %d",cn,(int)MOD_GZIP_LARGE_BUFFER_SIZE);
    mod_gzip_printf( "%s: Transmit buffer size       = %d",cn,sizeof(tmp));
    mod_gzip_printf( "%s: Sending output file...",cn);
    #endif

    if ( output_offset > 0 )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: output_offset = %ld",cn,(long)output_offset);
       mod_gzip_printf( "%s: Call fseek(ifh,%ld,1)...",cn,(long)output_offset);
       #endif

       fseek( ifh, (long) output_offset, 1 );

       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Back fseek(ifh,%ld,1)...",cn,(long)output_offset);
       #endif
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: output_offset = %ld = ZERO",cn,(long)output_offset);
       mod_gzip_printf( "%s: No fseek() call required before transmit.",cn);
       #endif
      }

    for (;;)
       {
        bytesread = fread( tmp, 1, MOD_GZIP_LARGE_BUFFER_SIZE, ifh );

        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf( "%s: Back fread(): bytesread=%d",cn,bytesread);
        #endif

        if ( bytesread < 1 ) break;

        byteswritten = (long)
        mod_gzip_send( tmp, bytesread, r );

        #ifdef MOD_GZIP_DEBUG1
        mod_gzip_printf( "%s: byteswritten = %ld",cn,(long)byteswritten);
        #endif

        if ( byteswritten > 0 )
          {
           total_compressed_bytes_sent += byteswritten;
          }

        if ( byteswritten != bytesread )
          {
           err = errno;

           #ifdef FUTURE_USE
           #if defined(WIN32) || defined(NETWARE)
           err = WSAGetLastError();
           #else
           err = errno;
           #endif
           #endif

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: TRANSMIT ERROR: bytesread=%ld byteswritten=%ld err=%d",
           cn,(long)bytesread,(long)byteswritten,(int)err );
           #endif

           #ifdef MOG_GZIP_DEBUG1

           mod_gzip_log_comerror( r, "mod_gzip: TRANSMIT_ERROR:", err );

           #else

           ap_log_error( APLOG_MARK,APLOG_NOERRNO|APLOG_ERR, r->server,
           "mod_gzip: TRANSMIT_ERROR:%d",(int)err);

           #endif

           #ifdef MOD_GZIP_USES_APACHE_LOGS

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_translate_comerror( err, scratch2 );
           sprintf( log_info,"%sTRANSMIT_ERROR:%d:%s", prefix_string, (int) err, scratch2 );
           #else
           sprintf( log_info,"%sTRANSMIT_ERROR:%d", prefix_string, (int) err );
           #endif

           ap_table_setn( r->notes,"mod_gzip_result",ap_pstrdup(r->pool,log_info));

           #endif

           #ifdef MOD_GZIP_DEBUG1
           mod_gzip_printf( "%s: Breaking out of transmit loop early...",cn);
           #endif

           break;
          }

       }/* End for(;;) loop that transmits workfile... */

   }/* End 'else' */

 /* Flush the output and update counts... */

 total_bytes_sent =
 total_header_bytes_sent +
 total_compressed_bytes_sent;

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Done Sending compressed data...",cn);
 mod_gzip_printf( "%s: total_header_bytes_sent     = %ld",
              cn,(long)total_header_bytes_sent);
 mod_gzip_printf( "%s: total_compressed_bytes_sent = %ld",
              cn,(long)total_compressed_bytes_sent);
 mod_gzip_printf( "%s: total_bytes_sent (Sum)      = %ld",
              cn,(long)total_bytes_sent);
 mod_gzip_printf( "%s: Call mod_gzip_flush_and_update_counts()...",cn);
 #endif

 mod_gzip_flush_and_update_counts(
 r,
 dconf,
 total_header_bytes_sent,
 total_compressed_bytes_sent
 );

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Back mod_gzip_flush_and_update_counts()...",cn);
 #endif

 /* Cleanup... */

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Cleanup phase START...",cn);
 #endif

 if ( gzp->output_ismem )
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Output source was MEMORY...",cn);
    #endif

    if ( gz1_ismem_obuf )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: gz1_ismem_obuf is still VALID...",cn);
       #endif

       if ( gz1_ismem_obuf_was_allocated )
         {
          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: gz1_ismem_obuf_was_allocated = TRUE",cn);
          mod_gzip_printf( "%s: Call free( gz1_ismem_obuf )...",cn);
          #endif

          free( gz1_ismem_obuf );

          #ifdef MOD_GZIP_DEBUG1
          mod_gzip_printf( "%s: Back free( gz1_ismem_obuf )...",cn);
          #endif

          gz1_ismem_obuf = 0;
          gz1_ismem_obuf_was_allocated = 0;
         }
      }
   }
 else
   {
    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: Output source was a WORKFILE...",cn);
    mod_gzip_printf( "%s: Closing workfile [%s]...",cn,npp(gzp->output_filename));
    #endif

    fclose( ifh );
    ifh = 0;

    #ifdef MOD_GZIP_DEBUG1
    mod_gzip_printf( "%s: dconf__keep_workfiles = %d",
                      cn, dconf__keep_workfiles );
    #endif

    if ( !dconf__keep_workfiles )
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Deleting workfile [%s]...",
                cn, npp(gzp->output_filename));
       #endif

       #ifdef WIN32
       DeleteFile( gzp->output_filename );
       #else
       unlink( gzp->output_filename );
       #endif
      }
    else
      {
       #ifdef MOD_GZIP_DEBUG1
       mod_gzip_printf( "%s: Keeping workfile [%s]...",
                         cn, npp(gzp->output_filename));
       #endif
      }
   }

 #ifdef MOD_GZIP_USES_APACHE_LOGS

 if ( finalize_stats )
   {
    sprintf( log_info,"%d", (int) output_size );
    ap_table_setn( r->notes,"mod_gzip_output_size",ap_pstrdup(r->pool,log_info));

    sprintf( log_info,"%d", (int) compression_ratio );
    ap_table_setn( r->notes,"mod_gzip_compression_ratio",ap_pstrdup(r->pool,log_info));
   }

 #endif

 if ( r->server->loglevel == APLOG_DEBUG )
   {
    ap_log_error( "",0,APLOG_NOERRNO|APLOG_DEBUG, r->server,
    "mod_gzip: r->uri=[%s] OK: Bytes In:%ld Out:%ld Compression: %ld pct.",
    r->uri,
    (long) input_size,
    (long) output_size,
    (long) compression_ratio
    );
   }

 #ifdef MOD_GZIP_DEBUG1
 mod_gzip_printf( "%s: Exit > return( OK ) >",cn);
 #endif

 return OK;
}

char *mod_gzip_generate_vary_header(mod_gzip_conf *cfg,struct pool *p) {
  int i = 0;
  char name[MOD_GZIP_IMAP_MAXNAMELEN + 2];
  array_header *ary = ap_make_array(p,cfg->imap_total_isreqheader+1,sizeof(char *));

  *((const char **)ap_push_array(ary)) = ap_pstrdup(p,"Accept-Encoding");

  for(i=0;i<cfg->imap_total_entries;i++) {
    if(cfg->imap[i].type == MOD_GZIP_IMAP_ISREQHEADER) {
      mod_gzip_strncpy(name,cfg->imap[i].name,strstr(cfg->imap[i].name,":") - cfg->imap[i].name - 1);
      *((const char **)ap_push_array(ary)) = ap_pstrdup(p,name);
    }
  }

  return ap_array_pstrcat(p,ary,',');
}

int mod_gzip_compress_file(request_rec *r,char *dest) {
  GZP_CONTROL   gzc;
  int rc;

  gzc.decompress           = 0;
  gzc.input_ismem          = 0;
  gzc.input_ismem_ibuf     = 0;
  gzc.input_ismem_ibuflen  = 0;
  gzc.input_filename[0]    = 0;
  gzc.input_offset         = 0;
  gzc.output_ismem         = 0;
  gzc.output_ismem_obuf    = 0;
  gzc.output_ismem_obuflen = 0;
  gzc.output_filename[0]   = 0;
  gzc.result_code          = 0;
  gzc.bytes_out            = 0;

  mod_gzip_strcpy(gzc.input_filename, r->filename);
  mod_gzip_strcpy(gzc.output_filename,dest);

  rc = gzp_main(r,&gzc);

  #ifdef MOD_GZIP_USES_APACHE_LOGS
  if(gzc.bytes_out > 0) {
    ap_table_setn(r->notes,"mod_gzip_result_n",ap_pstrdup(r->pool,"OK:PRECOMPRESSED_VARIANT_UPDATED"));

    if (r->server->loglevel == APLOG_NOTICE) {
      ap_log_error("",0,APLOG_NOERRNO|APLOG_NOTICE,r->server,"mod_gzip: updated %s with %s",dest,r->filename);
    }
  }
  #endif

  return (int)gzc.bytes_out;
}

/* eof */
