/*
 *  Copyright (C) 2004 Steve Harris
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  $Id: method.c,v 1.1.1.1 2004/08/07 22:21:02 theno23 Exp $
 */

#include <stdio.h>

#include "lo_types_internal.h"
#include "lo/lo.h"

void lo_method_pp(lo_method m)
{
    lo_method_pp_prefix(m, "");
}

void lo_method_pp_prefix(lo_method m, const char *p)
{
    printf("%spath:      %s\n", p, m->path);
    printf("%stypespec:  %s\n", p, m->typespec);
    printf("%shandler:   %p\n", p, m->handler);
    printf("%suser-data: %p\n", p, m->user_data);
}

/* vi:set ts=8 sts=4 sw=4: */
