/***************************************************************************
 $RCSfile: bankparams.h,v $
                             -------------------
    cvs         : $Id: bankparams.h,v 1.16 2003/07/02 10:18:03 cstim Exp $
    begin       : Sat Jun 08 2002
    copyright   : (C) 2001 by Martin Preuss
    email       : openhbci@aquamaniac.de

 ***************************************************************************
 *                                                                         *
 *   This library is free software; you can redistribute it and/or         *
 *   modify it under the terms of the GNU Lesser General Public            *
 *   License as published by the Free Software Foundation; either          *
 *   version 2.1 of the License, or (at your option) any later version.    *
 *                                                                         *
 *   This library is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU     *
 *   Lesser General Public License for more details.                       *
 *                                                                         *
 *   You should have received a copy of the GNU Lesser General Public      *
 *   License along with this library; if not, write to the Free Software   *
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston,                 *
 *   MA  02111-1307  USA                                                   *
 *                                                                         *
 ***************************************************************************/


#ifndef BANKPARAMS_H
#define BANKPARAMS_H

#include <string>
#include <list>
using namespace std;
#include <openhbci/bpdjob.h>




namespace HBCI {

#ifndef DOXYGEN_HIDE
/**
 * @short Stores all information of one set of BPD (bank parameter data).
 */
class DLLIMPORT bpd {
    friend class SEGInstituteParameter;
private:
    int _version;
    int _country;
    string _instituteCode; /* BLZ */
    string _name;
    list<int> _languages;
    list<int> _supportedVersions;
    int _maxmsgsize;
    int _maxdifferentactions;

public:
    bpd();
    ~bpd();

    int version() const { return _version;};
    void setVersion(int i) { _version=i;};

    int country() const { return _country;};
    void setCountry(int c) { _country=c;};

    const string &instituteCode() const { return _instituteCode;};
    void setInstituteCode(const string &c) { _instituteCode=c;};

    const string &name() const { return _name;};
    void setName(const string &s) { _name=s;};

    const list<int> &languages() const { return _languages;};
    void addLanguage(int l) { _languages.push_back(l);};

    const list<int> &supportedVersions() const 
	{ return _supportedVersions;};
    void addVersion(int i) { _supportedVersions.push_back(i);};

    int maxMessageSize() const { return _maxmsgsize;};
    void setMaxMessageSize(int i) { _maxmsgsize=i;};

    int maxDifferentActions() const { return _maxdifferentactions;};
    void setMaxDifferentActions(int i) { _maxdifferentactions=i;};

};


/** 
 * @short Stores all information of one set of BPD communication data
 * (bank parameter data).  
*/
class DLLIMPORT bpdCom {
    friend class SEGComParameter;
private:
    int _language;
    int _type;
    string _addr;
    string _suffix;
    string _filter;
    int _filterVersion;

public:
    bpdCom();
    ~bpdCom();

    /**
     *
     */
    const int language() const { return _language;};
    void setLanguage(int l) { _language=l;};

    /**
     * Supported type of protocolstack:
     * 1 == T-Online (ETSI 300 072); 2 == TCP/IP
     */
    int type() const { return _type;};
    void setType(int i) { _type=i;};

    /** 
     * Communication address. Depends on type of protocol stack: 
     * If T-Online, addr is the address of the Gateway as a number.
     * If TCP/IP, addr is the IP address of the HBCI server in 
     * dotted notation, e.g. "123.123.123.123".
     */
    const string &addr() const { return _addr;};
    void setAddr(const string &s) { _addr=s;};

    /**
     * Suffix of the communication address. Depends on type of protocol stack:
     * If T-Online, suffix is the region code of the service.
     * If TCP/IP, this is ignored.
     */
    const string &suffix() const { return _suffix;};
    void setSuffix(const string &s) { _suffix=s;};

    /** 
     * Filter mechanism. If the transport stack needs a conversion
     * from 8bit- to 7bit-characters (as is the case for TCP/IP,
     * according to HBCI spec), this parameter specifies which filter
     * to use. Can be:
     * "MIM" == MIME Base 64
     * "UUE" == Uuencode / Uudecode
     */
    const string &filter() const { return _filter;};
    void setFilter(const string &s) { _filter=s;};

    /** Version number of the filter, if one was specified.
     */
    int filterVersion() const { return _filterVersion;};
    void setFilterVersion(int i) { _filterVersion=i;};

};


#endif /* DOXYGEN_HIDE */


/**
 * @short Stores all information of one set of BPD (bank parameter data).
 *
 * This class holds the "Bank Parameter Daten" of one bank, as sent to
 * us by this bank. This is all information we have about the
 * institute (except the keys).
 *
 * This class should only be visible inside OpenHBCI -- all external
 * applications are only supposed to use the interface class Bank.
 *
 * @author Martin Preuss<martin@libchipcard.de>, mostly reorganized and copied from Fabian */
class DLLIMPORT bankParams {
    friend class JOBDialogInit;
protected:
    bpd _bpd;
    bpdCom _bpdcom;
    list<bpdJob> _supportedJobs;

public:
    bankParams();
    bankParams(int country, const string &code, const string &server);
    bankParams(bpd b, bpdCom c, list<bpdJob> j);
    bankParams(const bankParams &p);
    ~bankParams();

    int version() const { return _bpd.version();};
    void setVersion(int i) { _bpd.setVersion(i);};

    int countryCode() const { return _bpd.country();};
    void setCountryCode(int i) { _bpd.setCountry(i);};

    const string &instituteCode() const { return _bpd.instituteCode();};
    void setInstituteCode(const string &s) { _bpd.setInstituteCode(s);};

    const string &name() const { return _bpd.name();};
    void setName(const string &s) { _bpd.setName(s);};

    const list<int> &languages() const { return _bpd.languages();};
    void addLanguage(int l) { _bpd.addLanguage(l);};

    const list<int> &supportedVersions() const 
	{ return _bpd.supportedVersions();};
    void addVersion(int i) { _bpd.addVersion(i);};

    int maxMessageSize() const { return _bpd.maxMessageSize();};
    void setMaxMessageSize(int i) { _bpd.setMaxMessageSize(i);};

    int maxDifferentActions() const { return _bpd.maxDifferentActions();};
    void setMaxDifferentActions(int i) { _bpd.setMaxDifferentActions(i);};

    /**
     *
     */
    const int language() const { return _bpdcom.language();};
    void setLanguage(int l) {_bpdcom.setLanguage(l);};

    /**
     * Supported type of protocolstack:
     * 1 == T-Online (ETSI 300 072); 2 == TCP/IP
     */
    int type() const { return _bpdcom.type();};
    void setType(int i) { _bpdcom.setType(i);};

    /**
     * Communication address. Depends on type of protocol stack:
     * If T-Online, addr is the address of the Gateway as a number.
     * If TCP/IP, addr is the IP address of the HBCI server in
     * dotted notation, e.g. "123.123.123.123".
     */
    const string &addr() const { return _bpdcom.addr();};
    void setAddr(const string &s) { _bpdcom.setAddr(s);};

    /**
     * Suffix of the communication address. Depends on type of protocol stack:
     * If T-Online, suffix is the region code of the service.
     * If TCP/IP, this is ignored.
     */
    const string &suffix() const { return _bpdcom.suffix();};
    void setSuffix(const string &s) { _bpdcom.setSuffix(s);};

    /**
     * Filter mechanism. If the transport stack needs a conversion
     * from 8bit- to 7bit-characters (as is the case for TCP/IP,
     * according to HBCI spec), this parameter specifies which filter
     * to use. Can be:
     * "MIM" == MIME Base 64
     * "UUE" == Uuencode / Uudecode
     */
    const string &filter() const { return _bpdcom.filter();};
    void setFilter(const string &s) { _bpdcom.setFilter(s);};

    /** Version number of the filter, if one was specified.
     */
    int filterVersion() const { return _bpdcom.filterVersion();};
    void setFilterVersion(int i) { _bpdcom.setFilterVersion(i);};

    /**
     * List of supported jobs.
     */
    const list<bpdJob> &supportedJobs() const { return _supportedJobs;};
    void addJob(bpdJob j) {_supportedJobs.push_back(j);};

    /**
     * Searches for a job which matches the given criteria.
     */
    const bpdJob *findJob(const string &segname, 
			  int minv=0, int maxv=9999) const;
};


} /* namespace HBCI */

#endif



