/* linkif.pike v1.0
   ========================
   Copyright  1999 Magnus Bck <baeck@swipnet.se>

   Makes the tag content a link with the specified characteristics
   if, and only if, the given conditions are met. Otherwise, the 
   contents will appear like normal text.

   Distributed under the GPL General Public License.
*/

constant thread_safe = 1;

#include <module.h>
inherit "module";
inherit "roxenlib";

void create()
{
  defvar("prop_attribs", 
	 "name,hreflang,type,rel,rev,charset,id,class,lang,title,style,"
	 "shape,coords,onfocus,onblur,onclick,ondblclick,onmousedown,"
	 "onmouseup,onmouseover,onmousemove,onmouseout,onkeypress,"
	 "onkeydown,onkeyup,target,tabindex,accesskey", 
	 "Propagated attributes", 
	 TYPE_STRING,
	 "Attributes that are to be propagated to the anchor tag,"
	 "should it be needed.\n"
	 );
}

int matches(string regexp, string s, int useregexp)
{ 
  if (useregexp)
    return Regexp(regexp)->match(s);
  else
    return regexp == s;
}

string get_basename(string filename)
{
  if (filename == "")
    return filename;
  for (int i = strlen(filename) - 1; i >= 0; i--)
  {
    if (filename[i] == '/')
    {
      if (i == (strlen(filename) - 1))
	return "./";
      else
	return filename[(i + 1)..(strlen(filename) - 1)];
    }
  }
  return filename;
}

string container_linkif(string name, mapping args,
			string contents, object id)
{
  if (!args->href)
    return contents;
  int eval = 1;

  /* Start evaluating the conditions */
  if (args->useragent)
    eval &= !matches(args->useragent, id->client*" ", args->regexp);
  if (args->file)
    eval &= !matches(args->file, get_basename((id->raw / " ")[1]), 
		     args->regexp);
  if (args->url)
    eval &= !matches(args->url, (id->raw / " ")[1], args->regexp);
  if (args->realfile)
    eval &= !matches(args->realfile, get_basename(id->not_query), 
		     args->regexp);
  if (args->realurl)
    eval &= !matches(args->realurl, id->not_query, args->regexp);
  if (args->referer)
    eval &= !matches(args->referer, id->referer, args->regexp);
  if (args->supports)
    eval &= !id->supports[args->supports];

  if ((eval && !args->not) || (!eval && args->not))
      return contents;
  string ret = "<a href=\"" + args->href + "\"";

  /* Add any other attributes that should be propagated to the anchor tag */
  foreach (replace(query("prop_attribs") / ",", " ", ""), string attr)
  {
    if (args[attr])
      ret += " " + attr + "=\"" + args[attr] + "\"";
  }
  ret += ">" + contents + "</a>";
  return ret;
}

array register_module()
{
  return ({
    MODULE_PARSER, "Conditional linking",
      "Makes the tag content a link with the specified characteristics "
      "if, and only if, the given conditions are met. Otherwise, the "
      "contents will appear like normal text. For details and syntax, "
      "see the <a href=\"http://www.jpl.nu/~magnus/roxen/linkif.html\">"
      "home page</a>.\n",
      0, 1 });
}

mapping query_container_callers()
{
  return ([ "linkif":container_linkif, ]);
}
