// This is a roxen module.

string cvs_version = "$Id: tex.pike,v 0.4 1997/02/12 22:48:28 werner Exp werner $";

string copyright = "<BR>Copyright &copy; 1997" +
		   "<A HREF=http://math1.uibk.ac.at/tex.html>Werner Benger</A>";

#include <module.h>
inherit "module";
inherit "roxenlib";

#define DEFAULT_FONT "16/b&h_lucidabright-demibold-i"
#define DEFAULT_PATH "fonts/"

private string	cache = "/tmp/Roxen.TeX.cache/";

//
// ROXEN Config-Interface
//
void create()
{
  defvar("textag", "LATEX", "TeX HTML Tag", TYPE_STRING, 
	 "The name of the HTML TAG to use TeX commands.");

  defvar("mountpoint", "/latex/", "Mount point", TYPE_LOCATION, 
	 "TeX location in filesystem.");

  defvar("texbin", "/opt/teTeX/bin/", "Path for TeX binaries ", TYPE_DIR, 
	 "This is the directory containing the TeX and dvips executables.");

  defvar("texbinary", "latex", "TeX program name", TYPE_STRING, 
	 "The name of the TeX binary to execute (tex, latex, amslatex, latex2e etc.)");

  defvar("eps2tgif", "/usr/local/gnu/bin/eps2tgif", 
	 "Postscript to GIF Converter", TYPE_FILE, 
	 "Program for conversion of Embedded Postscript to gif.<P>"
	 "You might try <A HREF=ftp://math1.uibk.ac.at/pub/tex-module/eps2tgif>"
	 "ftp://math1.uibk.ac.at/pub/tex-module/eps2tgif</A>.<BR>"
	 "Don't forget to set the variables $gs and $togif in this script to "
	 "your local requirements." );

  defvar("smoothing", "2", "Default smoothing factor", TYPE_STRING, 
	 "The default smoothing factor if none is given explicitely in the TeX Tag."
	 "Greater values give better image quality, but result in bigger images and slower"
	 "image generation.");

  defvar("texheader", "\\documentclass{article}\n\\usepackage{amstex}\n\\pagestyle{empty}\n\\begin{document}\n\\[",
	 "TeX Header", TYPE_TEXT_FIELD, 
	 "Header for temporary TeX files enclosing mathematical formulas.");

  defvar("textrailer", "\\]\n\\end{document}\n",
	 "TeX Trailer", TYPE_TEXT_FIELD, 
	 "Trailer for temporary TeX files enclosing mathematical formulas.");

  defvar("fontpath", DEFAULT_PATH, "Error message font path", TYPE_DIR, "");
  defvar("defaultfont", DEFAULT_FONT, "Error message default font", TYPE_FILE, "");
}

//
// Module Definition
//
mixed *register_module()
{
  return ({ MODULE_LOCATION | MODULE_PARSER,
    "TeX Mathematics Tag", 
    "This is the <A HREF=http://math1.uibk.ac.at/tex.html>TeX Mathematics Module</A>.<P>"
    "It adds a new tag &lt;" + QUERY(textag) + "&gt; which may contain mathematic formulas "
    "in TeX syntax. "
"<P>Optional parameters: <PRE>"
"scale=1.5        scaling of TeX output\n"
"smooth=2.0       smoothing factor of TeX image\n"
"align=...        as in IMG SRC tag\n"
"border=...       as in IMG SRC tag\n"
"fg=...           foreground color\n"
"bg=...           background color\n"
"</PRE>"
    });
}

string tex_tag(string tag, mapping args, string TeXtext, object request_id,
                object file, mapping defs)
{
string  TeXencoded = replace(TeXtext,
	({ "\t", "\n", "\000", "/"  , " ",    "%" ,  "?"  ,"="  ,"+"  , "$"  }), 
        ({ "$20","$20",""    , "$2F", "$20", "$25", "$3F","$3D","$2B", "$$"  })
		            );

	while( search(TeXencoded,"$20$20")>=0 )
		TeXencoded = replace(TeXencoded, "$20$20", "$20" );

	return "<IMG SRC=\"" + query("mountpoint") 
		+ TeXencoded 
		+ "/" + (args->scale?args->scale:"1.0")
		+ "/" + (args->smooth?args->smooth:query("smoothing"))
		+ "/" + (args->bg? replace( args->bg, ({"#"}),({"$"}) ) :"$FFFFFF")
		+ "/" + (args->fg? replace( args->fg, ({"#"}),({"$"}) ) :"" )
		+ "\" ALT=\""+TeXtext+"\" "+
	        (args->align?"ALIGN="+args->align:"") +
	        (args->border?"BORDER="+args->border:"") + ">";
}

void	got_tex_data(object to, string d)
{
	to->write( d );
}

mapping http_gif_stream(object from)
{
	return ([ "file":from, "type":"image/gif", "len":-1, ]);
}

//
// Evaluation of the mount location encoding.
// The TeX programs are called in a subprocess, while the
// main routine immediatly returns to Roxen.
// The subprocess writes the image data to a cache file.
// If this file exists on the next call with same parameters,
// its contents are put into the cache lookup table.
// On the third call with the same parameters, the contents
// of the cache lookup table are returned immediatly.
//
mapping find_file( string text, object id )
{
	if (strlen(text) < 1)
	{
		return http_string_answer(
		"<HTML>\n<HEAD><TITLE>The Roxen TeX Module</TITLE></HEAD>\n"
		"<BODY LINK=#FF0000 ALINK=#FF0000 VLINK=#FF0000>\n"
		"<H1>This is the mount location of the "
		"<A HREF=\"http://www.roxen.com/\">"
		"<img border=0 alt=\"Roxen\" src=\"/internal-roxen-roxen\"></A> TeX Modul </H1>\n"
		"<P><H4>" + cvs_version + "</H4>\n"
		"<P><BIG>It enables the use of mathematical formulas in the HTML code, please "
		"have a look to <P>\n<CENTER><A HREF=\"http://math1.uibk.ac.at/tex.html\">"
		"http://math1.uibk.ac.at/tex.html</A></CENTER>\n<P> for more info.</BIG>\n"
		"<P><HR><P>\n"
		"This location calls <TT><B>" + query("texbinary") + "</B></TT> to provide the "
		"<TT><B>&lt;" + query("textag") + "&gt;</B></TT> HTML tag.\n"
		"</BODY>\n</HTML>\n",
		"text/html");
	}

string	cachefile, response;
	if (response = cache_lookup("tex", text))
		return http_string_answer(response, "image/gif");

string	h = (string)hash(text) + (string)hash(reverse(text));
object	gif;
	gif = File();
	cachefile = cache + h + ".gif";
	response = cachefile;

	if (gif->open(cachefile, "r"))
	{
		response = gif->read(0x7fffffff);
		cache_set("tex", text, response);
		gif->close();
		destruct(gif);
		return http_string_answer( response, "image/gif" );
	}

object 	toServer = File(),
	pipe     = toServer->pipe();
	if(!pipe) error("TeX module failed. (couldn't create pipe)\n");

	if (fork())
	{		// parent process

		destruct(toServer);
		if(id->data || id->misc->len)
		{
			pipe->write(id->data);
			id->my_fd->set_nonblocking(got_tex_data, 0, 0);
			id->my_fd->set_id( pipe );
		}

		pipe->set_id(pipe);

		return http_gif_stream(pipe);
	}

//
// Code executed from here on runs as subprocess of Roxen.
// From here on, everything written to the File `toServer'
// is interpreted as part of an gif file.
//
int	gid = getegid(),
	uid = geteuid();

	setuid(0);
	setgid( gid );
	setuid( uid );

string	font = query("defaultfont");
	if (font[0] != '/') font = query("fontpath") + font;
 
object	fnt = Font();
  	if (!fnt->load(font))
     		perror("Could not load font \"" + font + "\"\n");

	cd("/tmp");

//
//	Creating temporary TeX file...
//
object	tex = File();
string	prefix = "/tmp/Roxen." + h;
	if (!tex->open(prefix + ".tex", "wc"))
	{
		destruct(tex);
		toServer->write( fnt->write(
		  "TeX Modul Error: Can't write to temporary file `" + prefix + ".tex' !")
			->invert()->togif(255,255,255) ); 

		exit(2);
	}
	tex->write("\\batchmode\n");
	tex->write( query("texheader")  );

float	scale = 1.0;
int	smooth = query("smoothing");
string	bg = "#FFFFFF",
	fg = "#000000";

string	*params = explode( text, "/" );

string	texencoded = params[0];
	if (sizeof(params)>1) sscanf( params[1], "%f", scale);
	if (sizeof(params)>2) sscanf( params[2], "%d", smooth);
	if (sizeof(params)>3) bg = params[3];
	if (sizeof(params)>4) fg = params[4];

	fg = replace(fg, ( {"$"} ), ( {"#"} ) );
	bg = replace(bg, ( {"$"} ), ( {"#"} ) );

string  texcommand = replace(texencoded,
        ({ "$2F", "$20", "$25", "$3F", "$3D","$2B", "$$" }) ,
	({ "/"  , " ",    "%" ,  "?"  ,"="  ,"+"  , "$"  }) );

	tex->write( texcommand );
	tex->write( query("textrailer") );
	tex->close();
	destruct(tex);

//
// 	Calling TeX...
//
string	texout = popen( query("texbin") + query("texbinary") + " " + prefix + ".tex");

	if (!file_stat(prefix + ".dvi"))
	{
		toServer->write( fnt->write(
		  "TeX Modul Error: Can't find temporary dvi file `" + prefix + ".dvi' !")
			->invert()->togif(255,255,255) ); 

		exit(1);
	}

//
//	Calling dvips...
//
string	dvips = popen(  query("texbin") + "dvips " + prefix + ".dvi -E -o " + prefix + ".ps");

	if (!file_stat(prefix + ".ps"))
	{
		toServer->write( fnt->write(
		  "TeX Modul Error: Can't find temporary postscript file `" + prefix + ".ps' !")
			->invert()->togif(255,255,255) ); 

		exit(1);
	}

//
//	Calling eps2tgif...
//
string	img = popen( query("eps2tgif")
			 + " -s" + scale 
			 + " -t " + smooth 
			 + " -f '" + fg + "'"
			 + " -b '" + bg + "'"
			 + " < " + prefix + ".ps");

	if (gif->open(cachefile, "wc"))
	{
		gif->write(img);
		gif->close();
	}
	destruct(gif);


	rm(prefix+".tex");
	rm(prefix+".log");
	rm(prefix+".dvi");
	rm(prefix+".aux");
	rm(prefix+".ps");

	toServer->write(img);
	exit(0);
}

string query_location() { return query("mountpoint"); }

string query_name() 
{ 
	return sprintf("TeX Module: <I>" + upper_case(QUERY(textag)) + "</I>");
}

mapping query_container_callers()
{
//
//	How to make a `dynamic' HTML Tag?????
//
//string	s = QUERY(textag);
//	if (strlen(s)<1) s = "latex";
//
//    	return ( [ s:tex_tag ]);
//	return ( [ QUERY(textag):tex_tag ]);
	return ( ["latex":tex_tag ]);
}

void	start()
{
	::start();
 	mkdir(cache);
	system("chmod a+rxw " + cache);
}
