#include <stdio.h>

#include "wnlib.h"
#include "wnswap.h"
#include "wnrnd.h"
#include "wnrndd.h"

#include "wnanl.h"


#define SIZE  2000


local double problem[SIZE][SIZE];
local int solution[SIZE];
local double new_ob,old_ob;
local int i1,i2;


local double eval_solution(void)
{
  int i;
  double sum;

  sum = 0.0;

  for(i=0;i<SIZE;++i)
  {
    sum += problem[i][solution[i]];
  }

  return(sum);
}


local double evaluate_random_mutation(void)
{
  i1 = wn_random_mod_int(SIZE);

  do
  {
    i2 = wn_random_mod_int(SIZE);
  }
  while(i1 == i2);

  return(problem[i1][solution[i2]]+problem[i2][solution[i1]]
	 -problem[i1][solution[i1]]-problem[i2][solution[i2]]);
}


local void accept_mutation(void)
{
  wn_swap(solution[i1],solution[i2],int);
}


local void reject_mutation(void)
{
}


local void checkpoint(void)
{
  static int count=0;

  /*
  */
  if(count%100 == 0)
  {
    wn_anneal_std_checkpoint_print();

    printf("checkpoint: ob=%lf\n",eval_solution());
  }

  ++count;
}


main()
{
  int i,j;

  wn_gpmake("no_free");

  wn_seed_random_number_generator(1);

  for(i=0;i<SIZE;++i)
  for(j=0;j<SIZE;++j)
  {
    problem[i][j] = wn_random_double_between(0.0,1.0);
  }

  for(i=0;i<SIZE;++i)
  {
    solution[i] = i;
  }

  wn_anneal((evaluate_random_mutation),
	    (accept_mutation),(reject_mutation),
	    (checkpoint),
	    SIZE,SIZE*100,100);
  /*
  wn_anneal_from_temperature((evaluate_random_mutation),
	    (accept_mutation),(reject_mutation),
	    (checkpoint),
	    SIZE,(SIZE*SIZE)/2,100,0.0);
  */
  printf("checkpoint: ob=%lf\n",eval_solution());
}
