/*
 * Copyright (c) 2001-2003 Shiman Associates Inc. All Rights Reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS
 * BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN
 * ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
 * CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
 * SOFTWARE.
 *
 */
/*
 * $Id: fd_device.c,v 1.2 2003/06/26 21:06:56 rocko Exp $
 *
 * Copyright (c) 2000, 2001 by Shiman Associates Inc. and Sun
 * Microsystems, Inc. All Rights Reserved.
 *
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation
 * files (the "Software"), to deal in the Software without
 * restriction, including without limitation the rights to use, copy,
 * modify, merge, publish, distribute, sublicense, and/or sell copies
 * of the Software, and to permit persons to whom the Software is
 * furnished to do so, subject to the following conditions: The above
 * copyright notice and this permission notice shall be included in
 * all copies or substantial portions of the Software.
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT.  IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT
 * HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
 * WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
 * DEALINGS IN THE SOFTWARE.
 *
 * Except as contained in this notice, the names of the authors or
 * copyright holders shall not be used in advertising or otherwise to
 * promote the sale, use or other dealings in this Software without
 * prior written authorization from the authors or copyright holders,
 * as applicable.
 *
 * All trademarks and registered trademarks mentioned herein are the
 * property of their respective owners. No right, title or interest in
 * or to any trademark, service mark, logo or trade name of the
 * authors or copyright holders or their licensors is granted.
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include "mas/mas_dpi.h"
#include "anx_internal.h"

int
open_audio_device_fd( struct anx_state* state, char* filename )
{
    int playback_only = FALSE;
    int fd;

    /* first, try to open the audio device for non-blocking IO.
       This'll give us a useful error if another application has already
       grabbed the device */
    if (( fd = open (filename, O_RDWR|O_NDELAY )) < 0 )
    {
        masc_log_message( MAS_VERBLVL_INFO, "anx: [info] Couldn't open audio device for recording and playback.");
        /* failing full duplex open, try just opening the device for
           playback */
        if (( fd = open (filename, O_WRONLY|O_NDELAY )) < 0 )
        {
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] *****************************************************");
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] Can't even open the audio device \"%s\" for playback!", filename);
            masc_log_message( MAS_VERBLVL_WARNING, "anx: [error] ** Another program may be using the audio device.");
            masc_log_message( MAS_VERBLVL_WARNING, "anx: [error] ** Check the audio device configuration and close any sound-producing programs.");
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] *****************************************************");
            return mas_error(MERR_FILE_CANNOT_OPEN);
        }
        playback_only = TRUE;
        masc_log_message( MAS_VERBLVL_INFO, "anx: [info] audio device open for playback only.");
    }

    if ( !playback_only )
        masc_log_message( MAS_VERBLVL_INFO, "anx: [info] audio device open for simultaneous recording and playback.");

    /* If we get here, we can try to do a blocking IO open.  THIS WILL
       BE PHASED OUT - the current code requires blocking IO! */
    close( fd );
    
    if ( playback_only )
    {
        if (( fd = open (filename, O_WRONLY )) < 0 )
        {
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] Can't open the audio device \"%s\" for playback!", filename);
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] *****************************************************");
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] Can't even open the audio device \"%s\" for playback!", filename);
            masc_log_message( MAS_VERBLVL_WARNING, "anx: [error] ** Another program may be using the audio device.");
            masc_log_message( MAS_VERBLVL_WARNING, "anx: [error] ** Check the audio device configuration and close any sound-producing programs.");
            masc_log_message( MAS_VERBLVL_ERROR, "anx: *****************************************************");
            return mas_error(MERR_FILE_CANNOT_OPEN);
        }
        masc_log_message( MAS_VERBLVL_INFO, "anx: [info] audio device open for playback only.");
    }
    else /* should be capable of read/write operation */
    {
        if (( fd = open (filename, O_RDWR )) < 0 )
        {
            masc_log_message( MAS_VERBLVL_INFO, "anx: [info] Couldn't open audio device for recording and playback.");
            /* possibly redundant, but give opening for playback only
               another shot... */
            if (( fd = open (filename, O_WRONLY )) < 0 )
            {
                masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] Can't even open the audio device \"%s\" for playback!", filename);
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] *****************************************************");
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] Can't even open the audio device \"%s\" for playback!", filename);
            masc_log_message( MAS_VERBLVL_WARNING, "anx: [error] ** Another program may be using the audio device.");
            masc_log_message( MAS_VERBLVL_WARNING, "anx: [error] ** Check the audio device configuration and close any sound-producing programs.");
            masc_log_message( MAS_VERBLVL_ERROR, "anx: [error] *****************************************************");
                return mas_error(MERR_FILE_CANNOT_OPEN);
            }
            masc_log_message( MAS_VERBLVL_INFO, "anx: [info] audio device open for playback only.");
            playback_only = TRUE;
        }
        if ( !playback_only )
            masc_log_message( MAS_VERBLVL_INFO, "anx: [info] audio device open for simultaneous recording and playback.");
    }

    /* We are error-free at this point.  Set the full duplex flag on
       the device state appropriately */
    if ( !playback_only )
        state->is_full_duplex = TRUE;
    else
        state->is_full_duplex = FALSE;

    return fd;
}
