#ifndef HIGHSCORE_MENU_H
#define HIGHSCORE_MENU_H

#include "Menu.h"

class HighscoreMenu : public Menu
{
    MENU_SINGLETON(Highscore);

  public:
    void eventShow();
    void eventHide();

    inline void setInsertEntryOnShow(bool enable)
    {
        m_insertEntryOnShow = enable;
    }

  protected:

    void do_insertEntryAndShow();
    void do_onlyShow();
    
    void fillUpHighscoreEntries(const std::string &mission,
                                unsigned highlightedEntry);

    PARAGUI_CALLBACK(onDone);

    bool m_insertEntryOnShow;
};

#endif // HIGHSCORE_MENU_H
