#include "GuiException.h"
#include "NewGameMenu.h"
#include "LevelSelectorMenu.h"

MENU_SINGLETON_INIT(NewGame);

//----------------------------------------------------------------------
NewGameMenu::NewGameMenu()
{
  getWidget(ID_NEW_MENU_SINGLE)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&NewGameMenu::onSingle);
  getWidget(ID_NEW_MENU_BACK)->SetEventObject(
    MSG_BUTTONCLICK, this, (MSG_CALLBACK_OBJ)&NewGameMenu::onBack);

  getWidget(ID_NEW_MENU_SINGLE)->Show();
  getWidget(ID_NEW_MENU_MULTI)->Show();
  getWidget(ID_NEW_MENU_LOAD)->Show();
  getWidget(ID_NEW_MENU_BACK)->Show();
}

//----------------------------------------------------------------------
NewGameMenu::~NewGameMenu()
{
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(NewGameMenu::onSingle)
{
  try
  {
    MenuManager::getInstance()->changeTo(LevelSelectorMenu::getInstance());
  }
  catch(GuiException e)
  {
    std::cerr << e << std::endl;
    PG_Application::GetApp()->Quit();
  }

  return true;
}

//----------------------------------------------------------------------
PARAGUI_CALLBACK(NewGameMenu::onBack)
{
  MenuManager::getInstance()->changeTo(getPrevious());
  return true;
}

//----------------------------------------------------------------------
void NewGameMenu::eventShow()
{
  getWidget(ID_NEW_MENU)->Show();
}

//----------------------------------------------------------------------
void NewGameMenu::eventHide()
{
  getWidget(ID_NEW_MENU)->Hide();
}
