#include "SoundInterface.h"
#include "SoundFactory.h"
#include "JukeBox.h"
#include "SoundMixer.h"


//----------------------------------------------------------------------------
#define PERCENTAGE_TO_VOLUME(p) (MIX_MAX_VOLUME * p / 100)


//----------------------------------------------------------------------------
SoundMixer* SoundMixer::sm_instance = NULL;

//----------------------------------------------------------------------------
SoundMixer::SoundMixer(int rate, Uint16 format, int channels, int buffers)
{
    SDL_MIXER_CALLS::OpenAudio(rate, format, channels, buffers);
    SDL_MIXER_CALLS::AllocateChannels(32);

    m_enableSound = false;

    m_soundVolume = 0;
    m_musicVolume = 0;
}

//----------------------------------------------------------------------------
SoundMixer::~SoundMixer()
{
    SDL_MIXER_CALLS::CloseAudio();
}

//----------------------------------------------------------------------------
void SoundMixer::init()
{
    int rate = 22050; // 22kHz
    Uint16 format = AUDIO_S16; // 16bit 
    int channels = 2; // stereo
    int buffers = 1024; // fragment size

    sm_instance = new SoundMixer(rate, format, channels, buffers);
    SoundFactory::init();
    JukeBox::init();

    // Switch the SoundInterface to the SoundBridge.
    // Because the PlayerConfiguration initialized the NullSoundInterface,
    // we must pass the values to the SoundBridge.

    SoundInterface *si = SoundInterface::getInstance();
    SoundBridge *sb = SoundBridge::getInstance();

    if (si->isSoundEnabled())
    {
        sb->enableSound();
    }
    sb->setSoundVolume(si->getSoundVolume());
    
    if (si->isMusicEnabled())
    {
        sb->enableMusic();
    }
    sb->setMusicVolume(si->getMusicVolume());

    SoundInterface::setInstance(sb);
}

//----------------------------------------------------------------------------
void SoundMixer::destroy()
{
    SoundInterface::setInstance(NullSoundInterface::getInstance());
    JukeBox::destroy();
    SoundFactory::destroy();

    ZAP_POINTER(sm_instance);
}


//----------------------------------------------------------------------------
void SoundMixer::setSoundVolume(Uint8 percentage)
{
    m_soundVolume = percentage;
    (void)Mix_Volume(-1, PERCENTAGE_TO_VOLUME(m_soundVolume));
}

//----------------------------------------------------------------------------
void SoundMixer::setMusicVolume(Uint8 percentage)
{
    m_musicVolume = percentage;
    (void)Mix_VolumeMusic(PERCENTAGE_TO_VOLUME(m_musicVolume)); 
}

//----------------------------------------------------------------------------
void SoundMixer::setCurrentMusicVolume()
{
    (void)Mix_VolumeMusic(PERCENTAGE_TO_VOLUME(m_musicVolume)); 
}
