//=========================================================
//  MusE
//  Linux Music Editor
//    $Id: poslabel.cpp,v 1.1.1.1 2003/10/29 10:06:23 wschweer Exp $
//  (C) Copyright 2001 Werner Schweer (ws@seh.de)
//=========================================================

#include <cmath>
#include <qapplication.h>
#include <qstyle.h>

#include "poslabel.h"
#include "sig.h"
#include "tempo.h"
#include "globals.h"

extern int mtcType;

//---------------------------------------------------------
//   PosLabel
//---------------------------------------------------------

PosLabel::PosLabel(QWidget* parent, const char* name)
  : QLabel(parent, name)
      {
      _tickValue = 0;
      _sampleValue = 0;
      _smpte = false;
      setFrameStyle(WinPanel | Sunken);
      setLineWidth(2);
      setMidLineWidth(3);
      int fw = style().pixelMetric(QStyle::PM_DefaultFrameWidth, this);
      setIndent(fw);
      updateValue();
      }

//---------------------------------------------------------
//   sizeHint
//---------------------------------------------------------

QSize PosLabel::sizeHint() const
      {
      QFontMetrics fm(font());
      int fw = style().pixelMetric(QStyle::PM_DefaultFrameWidth, this);
      int h  = fm.height() + fw * 2;
      int w;
      if (_smpte)
            w  = 2 + fm.width('9') * 9 + fm.width(':') * 3 + fw * 4;
      else
            w  = 2 + fm.width('9') * 9 + fm.width('.') * 2 + fw * 4;
      return QSize(w, h).expandedTo(QApplication::globalStrut());
      }

//---------------------------------------------------------
//   updateValue
//---------------------------------------------------------

void PosLabel::updateValue()
      {
      QString s;
      if (_smpte) {
            double time = double(_sampleValue) / double(sampleRate);
            int min  = int(time) / 60;
            int sec  = int(time) % 60;
            double rest = time - (min * 60 + sec);
            switch(mtcType) {
                  case 0:     // 24 frames sec
                        rest *= 24;
                        break;
                  case 1:     // 25
                        rest *= 25;
                        break;
                  case 2:     // 30 drop frame
                        rest *= 30;
                        break;
                  case 3:     // 30 non drop frame
                        rest *= 30;
                        break;
                  }
            int frame = int(rest);
            int subframe = int((rest-frame)*100);
            s.sprintf("%03d:%02d:%02d:%02d", min, sec, frame, subframe);
            }
      else {
            int bar, beat, tick;
            sigmap.tickValues(_tickValue, &bar, &beat, &tick);
            s.sprintf("%04d.%02d.%03d", bar+1, beat+1, tick);
            }
      setText(s);
      }

//---------------------------------------------------------
//   setSampleValue
//---------------------------------------------------------

void PosLabel::setSampleValue(int val)
      {
      if (val == _sampleValue)
            return;
      _sampleValue = val;
      updateValue();
      }

//---------------------------------------------------------
//   setTickValue
//---------------------------------------------------------

void PosLabel::setTickValue(int val)
      {
      if (val == _tickValue)
            return;
      _tickValue = val;
      updateValue();
      }

//---------------------------------------------------------
//   setValue
//---------------------------------------------------------

void PosLabel::setValue(int val)
      {
      int oval = _smpte ? _sampleValue : _tickValue;
      if (val == oval)
            return;
      if (_smpte)
            _sampleValue = val;
      else
            _tickValue = val;
      updateValue();
      }

//---------------------------------------------------------
//   setSmpte
//---------------------------------------------------------

void PosLabel::setSmpte(bool val)
      {
      _smpte = val;
      if (val)
            _sampleValue = lrint(tempomap.tick2time(_tickValue) * sampleRate);
      else
            _tickValue = tempomap.time2tick(double(_sampleValue) / double(sampleRate));
      updateValue();
      }

