# This script was automatically generated from 
#  http://www.gentoo.org/security/en/glsa/glsa-200411-12.xml
# It is released under the Nessus Script Licence.
# The messages are release under the Creative Commons - Attribution /
# Share Alike license. See http://creativecommons.org/licenses/by-sa/2.0/
#
# Avisory is copyright 2001-2004 Gentoo Foundation, Inc.
# GLSA2nasl Convertor is copyright 2004 Michel Arboi

if (! defined_func('bn_random')) exit(0);

if (description)
{
 script_id(15646);
 script_version("$Revision: 1.1 $");
 script_xref(name: "GLSA", value: "200411-12");

 desc = 'The remote host is affected by the vulnerability described in GLSA-200411-12
(zgv: Multiple buffer overflows)


    Multiple arithmetic overflows have been detected in the image processing
    code of zgv.
  
Impact

    An attacker could entice a user to open a specially-crafted image file,
    potentially resulting in execution of arbitrary code with the rights of the
    user running zgv.
  
Workaround

    There is no known workaround at this time.
  
References:
    http://www.securityfocus.com/archive/1/379472


Solution: 
    All zgv users should upgrade to the latest version:
    # emerge --sync
    # emerge --ask --oneshot --verbose ">=media-gfx/zgv-5.8"
  

Risk factor : Medium
';
 script_description(english: desc);
 script_copyright(english: "(C) 2004 Michel Arboi");
 script_name(english: "[GLSA-200411-12] zgv: Multiple buffer overflows");
 script_category(ACT_GATHER_INFO);
 script_family(english: "Gentoo Local Security Checks");
 script_dependencies("ssh_get_info.nasl");
 script_require_keys('Host/Gentoo/qpkg-list');
 script_summary(english: 'zgv: Multiple buffer overflows');
 exit(0);
}

include('qpkg.inc');
if (qpkg_check(package: "media-gfx/zgv", unaffected: make_list("ge 5.8"), vulnerable: make_list("lt 5.8")
)) { security_warning(0); exit(0); }
