/*

Copyright (C) 2000, 2001, 2002 Christian Kreibich <christian@whoop.org>.

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies of the Software and its documentation and acknowledgment shall be
given in the documentation and software packages that this Software was
used.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL
THE AUTHORS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/
#ifndef __nd_macros_h
#define __nd_macros_h

#include <stdlib.h>
#include <netdude/nd_trace_registry.h>

#define	TV_SUB(a,b,c)	{ \
	(c)->tv_sec = (a)->tv_sec - (b)->tv_sec; \
	if ((a)->tv_usec < (b)->tv_usec) { \
		(c)->tv_sec -= 1;		/* need to borrow */ \
		(c)->tv_usec = ((a)->tv_usec + 1000000) - (b)->tv_usec; \
	} else { \
		(c)->tv_usec = (a)->tv_usec - (b)->tv_usec; \
	} \
}

/**
 * return_if_no_current_trace - current trace safety check.
 * @tr: variable in which current trace is stored.
 *
 * The macro checks whether there is currently a trace being
 * edited. If that is the case, this trace is stored in @tr,
 * otherwise the macro returns from the current function.
 */
#define return_if_no_current_trace(tr) \
do { tr = nd_trace_registry_get_current(); D_ASSERT_PTR(tr); if (!tr) return; } while (0)

/**
 * return_val_if_no_current_trace - version of return_if_no_current_trace with return value.
 * @tr: variable in which current trace is stored.
 * @val: return value when there is no current trace.
 *
 * This is the same macro as return_if_no_current_trace(), but
 * it returns @val is there is no current trace.
 */
#define return_val_if_no_current_trace(tr, val) \
do { tr = nd_trace_registry_get_current(); D_ASSERT_PTR(tr); if (!tr) return (val); } while (0)


/**
 * TOUCH - suppresses warnings.
 * @x: unused variable to be silenced.
 * 
 * The macro's purpose is to touch a variable and thus
 * shut up compiler warnings when there are unused
 * parameters in the code.
 */
#define TOUCH(x)  { x = 0; }

#endif
     
