/* Manage ImageDisplay structs.
 */

#include "ip.h"

/* Remove a box_info.
 */
static void *
tidy_regions( struct box_info *box )
{	
	/* Pop down display.
	 */
	(void) remove_region_display( box );

	return( NULL );
}

/* Remove a display. We remove any children of this display (zooms and
 * hi-reses), then remove ourselves. 
 */
void *
remove_display( ImageDisplay *scr )
{	
	/* Recurse down to the leaves of this display tree. 
	 */
	slist_map( scr->child, (SListMapFn) remove_display, NULL );

	assert( !scr->child );

	/* Remove region displays on this display. If we remove the last
	 * display of a non-computed region, remove the region symbol too.
	 */
	slist_map( scr->regions, (SListMapFn) tidy_regions, NULL );

	/* Remove this display and all its locator boxes from the
	 * screen. Free everything up.
	 */
	delete_display( scr );

	return( NULL );
}

/* sym is a computed region symbol which had asked for a region display on
 * rsym. Break the link between the two.
 */
void *
break_region_display( Symbol *rsym, Symbol *sym )
{
	/* Break interlinks.
	 */
	sym->rdisps = g_slist_remove( sym->rdisps, rsym );
	rsym->regs = g_slist_remove( rsym->regs, sym );

	return( NULL );
}

/* rsym is an image symbol upon which sym thinks it has a region. Junk the
 * link between the two.
 */
void *
break_display_region( Symbol *sym, Symbol *rsym )
{
	/* Break interlinks.
	 */
	sym->rdisps = g_slist_remove( sym->rdisps, rsym );
	rsym->regs = g_slist_remove( rsym->regs, sym );

	return( NULL );
}

/* sym is a region symbol, rsym is the symbol it would like to have a display
 * on. Link the two together through the rdisps/regions lists.
 */
void *
pop_region_on_sym( Symbol *rsym, Symbol *sym )
{
	/* Sanity!
	 */
	assert( ii_sym_image( rsym ) );

	/* Link two together,
	 */
	sym->rdisps = g_slist_prepend( sym->rdisps, rsym );
	rsym->regs = g_slist_prepend( rsym->regs, sym );

	/* Make a region display for each of the image displays in rsym.
	 */
	return( slist_map( rsym->winds, 
		(SListMapFn) build_region_display, sym ) );
}

/* Make an IMAGE symbol. Load happens when this symbol is recomputed.
 */
void
make_image( Symbol *sym, char *fl )
{
	/*
	assert( sym->type == SYM_ZOMBIE && 
		sym->base.type == ELEMENT_NOVAL );

	sym->type = SYM_VALUE;
	sym->recomp.type = RECOMP_IMAGE;
	SETSTR( sym->recomp.imagename, fl );

	symbol_made( sym );
	 */
}

/* Reload an IMAGE symbol.
 */
Bool
reload_symbol( Symbol *sym )
{
	/*
	char *fname = sym->recomp.imagename;
	IMAGE *im;

	assert( sym->type == SYM_VALUE &&
		sym->recomp.type == RECOMP_IMAGE &&
		fname );

	if( !(im = im_open( fname, "r" )) )
		return( False );

	if( !reduce_build_image( sym, im ) )
		return( False );
	 */

	return( True );
}

/* Make a new IMAGE symbol.
 */
Symbol *
add_image( char *fl )
{	
	Symbol *sym = workspace_add_symbol( main_workspacegroup->current );

	if( !sym ) 
		return( NULL );

	/* Load into our new unnamed symbol.
	 */
	make_image( sym, fl );

	/* Return new symbol. 
	 */
	return( sym );
}

/* Make a new IMAGE symbol and load it.
 */
Symbol *
add_image_load( char *fl )
{
	Symbol *sym;

	if( !(sym = add_image( fl )) )
		return( NULL );
	if( !symbol_recalculate( sym ) ) {
		gtk_object_destroy( GTK_OBJECT( sym ) );
		symbol_recalculate_all();
		return( NULL );
	}

	return( sym );
}

/* Increment counter if this symbol has an associated window.
 */
static Symbol *
test_managed( Symbol *sym, int *n )
{	
	if( sym->dest == 0 && sym->type == SYM_VALUE ) 
		(*n) += g_slist_length( sym->winds );

	return( NULL );
}

/* Count the displays we have on the screen.
 */
static int
count_displays( void )
{
	int n = 0;

	if( mainw_visible ) 
		n++;
	else
		(void) stable_map( symbol_root->expr->locals, 
			(symbol_map_fn) test_managed, &n, NULL );

	return( n );
}

/* Look for any displays. Return True if there are no managed windows left.
 * Called from screen_destroy_cb to see if it should main_quit() on a 
 * window remove.

 	FIXME ... IM_RECT_RIGHT place for this?

 */
Bool
test_finished( void )
{
	return( count_displays() == 0 );
}

