/*
 *  Copyright (C) 2004 Mathias Andre <mathias@openbrookes.org>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 */

#ifndef __NB_UI_ATTACHMENT_VIEW_H__
#define __NB_UI_ATTACHMENT_VIEW_H__

#include <glib.h>

#include "../nb_attachment_list.h"

typedef struct _attachment_drag AttachmentDrag;

struct _attachment_drag 
{
	gint start_x;
	gint start_y;
	gint pressed_button;
};

void		nb_ui_attachment_view_create (void);

void		nb_ui_attachment_view_show (void);
void		nb_ui_attachment_view_hide (void);
void		nb_ui_attachment_view_icon_list_show_hide (void);

void		nb_ui_attachment_view_select_files (void);

void		nb_ui_attachment_view_update (AttachmentList * attachments);

void		nb_ui_attachment_view_context_menu (GtkWidget * widget, GdkEventButton * event);

/* callbacks */
void		nb_ui_attachment_view_remove_attachments (GtkMenuItem * menuitem, gpointer user_data);
gboolean	nb_ui_attachment_view_cb_button_pressed (GtkWidget * widget, GdkEventButton * event, gpointer user_data);
gboolean	nb_ui_attachment_view_cb_button_released (GtkWidget * widget, GdkEventButton * event, gpointer user_data);
gboolean	nb_ui_attachment_view_cb_motion (GtkWidget * widget, GdkEventButton * event, gpointer user_data);

void		nb_ui_attachment_view_cb_drag_data_get (GtkWidget * widget, GdkDragContext * drag_context, GtkSelectionData * data, guint info, guint time, gpointer user_data);

/* context menu callbacks */
gboolean	nb_ui_attachment_view_button_press (GtkWidget * widget, GdkEventButton * event);	

#endif
