#include "portable.h"
#include <stdio.h>
#include <sys/time.h>
#include "slap.h"
#include <ldap_pvt.h>
#include "external.h"
#include "nws_back_cache.h"
#include "nws_back.h"

NWSobj *
nws_new_obj(void);

int
nws_free_obj(NWSobj *);

int
nws_make_coll(nwsBackConfig *ncc, char *name, char *memberlist, char *type);

int
nws_next_attrval(char **ptr1, char **ptr2, char **ptr3)
{
  char *attr = *ptr1;
  char *value;			/* = *ptr2; */
  char *next_attr;		/* = *ptr3; */

  value = attr;

  while (value[0] != ':') {
	value++;
  }

  *value = '\0';		/* make attr null terminated */
  value++;				/* value is now correct */
  next_attr = strchr(value, '\t');
  if (next_attr == NULL) {
	printf("parse error in nws_next_attrval.\n");
	exit(-1);
  }
  *next_attr = '\0';		/* value is now null terminated */
  next_attr++;			/* next_attr is now correct */
  if (next_attr[0] == '\t') {
	next_attr = NULL;
  }

  *ptr1 = attr;
  *ptr2 = value;
  *ptr3 = next_attr;

  /* printf("attr: %s\tvalue: %s\n", attr, value); */
  return(1);
}

char *
nws_next_object(char *obj) {
  while(1) {
	obj++;
	if ((obj[0] == '\t') && (obj[1] == '\t')) {
	  obj += 2;
	  if(obj[0] == '\0') {
		return NULL;
	  }
	  else {
		return(obj);
	  }
	}
  }
}

/* Parse the nws_nameserver registration objects into the nws cache
   structs */
int
nws_cache_parse(nwsBackConfig *nbc)
{
  
  char *current_obj;
  char *attr, *value, *next_attr;
  NWSobj *obj, *new_head;
  NWSobj *old_obj_list, *old_obj;
  struct timeval now;
  nwsCacheConfig *ncc;

  ncc = (nwsCacheConfig *)nbc;
  

  Debug(LDAP_DEBUG_TRACE, "==>nws_cache_parse()\n",0,0,0);

  if(gettimeofday(&now, NULL) < 0) {
	Debug(LDAP_DEBUG_TRACE,"nws_cache_parse(): gettimeofday() failed.\n"
		  ,0,0,0);
	now.tv_sec = 0;
	now.tv_usec = 0;
  }

  current_obj = nbc->nws_reg_objs;

  obj = nws_new_obj();

  new_head = obj;

  while (current_obj != NULL) {
	attr = current_obj;
	current_obj = nws_next_object(current_obj);

	nws_next_attrval(&attr, &value, &next_attr);

	if(!strcmp(attr, "name")) {
	  obj->name = strdup(value);
	}
	else {
	  printf("The first attribute in this object is not \"name\".\n");
	  exit(-1);
	}

	attr = next_attr;
	nws_next_attrval(&attr, &value, &next_attr);

	if(!strcmp(attr, "objectclass")) {
	  obj->type = strdup(value);
	}
	else if (!strcmp(attr, "timestamp")) {
	  obj->nws_timestamp = atoi(value);

	  attr = next_attr;
	  nws_next_attrval(&attr, &value, &next_attr);

	  if(!strcmp(attr, "objectclass")) {
		obj->type = strdup(value);
	  }
	  else {
		printf("The second attribute in this object is \"timestamp\", but the 3rd is not \"objectclass\".\n");
		exit(-1);
	  }	
	  
	}
	else {
	  printf("The second attribute in this object is not \"objectclass\" or \"timestamp\".\n");
	  exit(-1);
	}	
	
	attr = next_attr;

	/* parse the remaining attributes depending on the objectclass */
	if (!strcmp("nwsHost", obj->type)) {
	  obj->itype = NWS_OBJ_nwsDaemon;
	  while(next_attr != NULL) {
		nws_next_attrval(&attr, &value, &next_attr);

		if (!strcmp(attr, "hostType")) {
		  obj->at.nd.daemonType = strdup(value);
		}
		else if (!strcmp(attr, "ipAddress")) {
		  obj->at.nd.ipAddress = strdup(value);
		}
		else if (!strcmp(attr, "owner")) {
		  obj->at.nd.owner = strdup(value);
		}
		else if (!strcmp(attr, "port")) {
		  obj->at.nd.port = strdup(value);
		}
		else if (!strcmp(attr, "started")) {
		  obj->at.nd.started = strdup(value);
		}
		else if (!strcmp(attr, "version")) {
		  obj->at.nd.version = strdup(value);
		}
		else if (!strcmp(attr, "timestamp")) {
		  obj->nws_timestamp = atoi(value);
		}
		else {
		  Debug(LDAP_DEBUG_TRACE,"Unknown attribute: %s (in name=%s)\n", attr, obj->name, 0);
		  /* exit(0); */
		}
		attr = next_attr;
	  }
	}
	else if (!strcmp("nwsControl", obj->type)) {
	  obj->itype = NWS_OBJ_nwsControl;
	  while(next_attr != NULL) {
		nws_next_attrval(&attr, &value, &next_attr);

		if (!strcmp(attr, "controlName")) {
		  obj->at.nc.controlName = strdup(value);
		}
		else if (!strcmp(attr, "host")) {
		  obj->at.nc.host = strdup(value);
		}
		else if (!strcmp(attr, "option")) {
		  obj->at.nc.option = strdup(value);
		}
		else if (!strcmp(attr, "skillName")) {
		  obj->at.nc.skillName = strdup(value);
		}
		else if (!strcmp(attr, "member")) {
		  obj->at.nc.member = strdup(value);
		}
		else if (!strcmp(attr, "period")) {
		  obj->at.nc.period = strdup(value);
		}
		else if (!strcmp(attr, "timestamp")) {
		  obj->nws_timestamp = atoi(value);
		}
		else {
		  Debug(LDAP_DEBUG_TRACE,"Unknown attribute: %s (in name=%s)\n", attr, obj->name, 0);
		  /*exit(0);*/
		}
		attr = next_attr;
	  }
	}
	else if (!strcmp("nwsSeries", obj->type)) {
	  obj->itype = NWS_OBJ_nwsSeries;
	  while(next_attr != NULL) {

		nws_next_attrval(&attr, &value, &next_attr);

		if (!strcmp(attr, "target")) {
		  obj->at.ns.target = strdup(value);
		}
		else if (!strcmp(attr, "memory")) {
		  obj->at.ns.memory = strdup(value);
		}
		else if (!strcmp(attr, "label")) {
		  obj->at.ns.label = strdup(value);
		}
		else if (!strcmp(attr, "option")) {
		  obj->at.ns.option = strdup(value);
		}
		else if (!strcmp(attr, "resource")) {
		  obj->at.ns.resource = strdup(value);
		}
		else if (!strcmp(attr, "activity")) {
		  obj->at.ns.activity = strdup(value);
		}
		else if (!strcmp(attr, "buffer")) {
		  obj->at.ns.buffer = strdup(value);
		}
		else if (!strcmp(attr, "message")) {
		  obj->at.ns.message = strdup(value);
		}
		else if (!strcmp(attr, "size")) {
		  obj->at.ns.size = strdup(value);
		}
		else if (!strcmp(attr, "target")) {
		  obj->at.ns.target = strdup(value);
		}
		else if (!strcmp(attr, "host")) {
		  obj->at.ns.host = strdup(value);
		}
		else if (!strcmp(attr, "nice")) {
		  obj->at.ns.nice = strdup(value);
		}
		else if (!strcmp(attr, "type")) {
		  obj->at.ns.type = strdup(value);
		}
		else if (!strcmp(attr, "timestamp")) {
		  obj->nws_timestamp = atoi(value);
		}
		else {
		  Debug(LDAP_DEBUG_TRACE,"Unknown attribute: %s (in name=%s)\n", attr, obj->name, 0);
		  /*exit(0); */
		}
		attr = next_attr;
	  }

	  obj->at.ns.nsc = nws_get_series(nbc, obj);
	  obj->at.ns.nsc->lastseen.tv_sec = now.tv_sec - 1;
	  obj->at.ns.nsc->lastupdate.tv_sec = 0;

	}
	
	else if (!strcmp("nwsActivity", obj->type)) {
	  obj->itype = NWS_OBJ_nwsActivity;
	  obj->at.na.member = NULL;
	  while(next_attr != NULL) {
		nws_next_attrval(&attr, &value, &next_attr);

		if (!strcmp(attr, "controlName")) {
		  obj->at.na.controlName = strdup(value);
		}
		else if (!strcmp(attr, "host")) {
		  obj->at.na.host = strdup(value);
		}
		else if (!strcmp(attr, "option")) {
		  obj->at.na.option = strdup(value);
		}
		else if (!strcmp(attr, "resource")) {
		  obj->at.na.resource = strdup(value);
		}
		else if (!strcmp(attr, "skillName")) {
		  obj->at.na.skillName = strdup(value);
		}
		else if (!strcmp(attr, "size")) {
		  obj->at.na.size = strdup(value);
		}
		else if (!strcmp(attr, "period")) {
		  obj->at.na.period = strdup(value);
		}
		else if (!strcmp(attr, "member")) {
		  obj->at.na.member = strdup(value);
		}
		else if (!strcmp(attr, "type")) {
		  obj->at.na.type = strdup(value);
		}
		else if (!strcmp(attr, "buffer")) {
		  obj->at.na.buffer = strdup(value);
		}
		else if (!strcmp(attr, "message")) {
		  obj->at.na.message = strdup(value);
		}
		else if (!strcmp(attr, "timestamp")) {
		  obj->nws_timestamp = atoi(value);
		}
		else {
		  Debug(LDAP_DEBUG_TRACE,"Unknown attribute: %s (in name=%s)\n", attr, obj->name, 0);
		  /*exit(0); */
		}
		attr = next_attr;
	  }

	  /* with a member attribute, this is a clique, so make a collection */

	  if (nbc->grid_count > 0) {
		if (obj->at.na.member != NULL) { 
		
		nws_make_coll(ncc, obj->name, obj->at.na.member, (char *)"clique");
		}
	  }

	}
	else if (!strcmp("nwsSkill", obj->type)) {
	  obj->itype = NWS_OBJ_nwsSkill;
	  while(next_attr != NULL) {
		nws_next_attrval(&attr, &value, &next_attr);

		if (!strcmp(attr, "host")) {
		  obj->at.nk.host = strdup(value);
		}
		else if (!strcmp(attr, "option")) {
		  obj->at.nk.option = strdup(value);
		}
		else if (!strcmp(attr, "skillName")) {
		  obj->at.nk.skillName = strdup(value);
		}
		else if (!strcmp(attr, "path")) {
		  obj->at.nk.path = strdup(value);
		}
		else if (!strcmp(attr, "nice")) {
		  obj->at.nk.nice = strdup(value);
		}	
		else if (!strcmp(attr, "type")) {
		  obj->at.nk.type = strdup(value);
		}
		else if (!strcmp(attr, "target")) {
		  obj->at.nk.target = strdup(value);
		}	
		else if (!strcmp(attr, "buffer")) {
		  obj->at.nk.buffer = strdup(value);
		}
		else if (!strcmp(attr, "message")) {
		  obj->at.nk.message = strdup(value);
		}
		else if (!strcmp(attr, "size")) {
		  obj->at.nk.size = strdup(value);
		}
		else if (!strcmp(attr, "timestamp")) {
		  obj->nws_timestamp = atoi(value);
		}
		else {
		  Debug(LDAP_DEBUG_TRACE,"Unknown attribute: %s (in name=%s)\n", attr, obj->name, 0);		  
		  /*exit(0); */
		}
		attr = next_attr;
	  }
	}
	else {
	  obj->itype = NWS_OBJ_Unknown;
	  printf("Unknown object type: %s\n", obj->type);
	  exit(-1);
	}

	nws_insert_obj(ncc, new_head, obj);

	if (current_obj != NULL) {
	  if ((obj = nws_new_obj()) == NULL) {
		perror("nws_new_obj() failed");
		return(-1);
	  }
	}
  }

  /* find the series/activity relation in nwsSeries records
	 and set the series cache period based on the generation
	 period.
   */
  for(obj = new_head; obj != NULL; obj = obj->next) {
	if(obj->itype == NWS_OBJ_nwsSeries) {
	  if(obj->at.ns.activity != NULL) {
		struct nws_obj *tobj;
		for(tobj = new_head; tobj != NULL; tobj = tobj->next) {
		  if(tobj->itype == NWS_OBJ_nwsActivity) {
			if(!strcmp(tobj->name, obj->at.ns.activity)) {
			  obj->at.ns.nsc->period = atoi(tobj->at.na.period);
			  if(obj->at.ns.nsc->period < nbc->min_refresh_period) {
				obj->at.ns.nsc->period = nbc->min_refresh_period;
			  }
			  /* printf("series: %s (from act: %s) has period %d\n",
					 obj->name,
					 tobj->name,
					 obj->at.ns.nsc->period);
			  */
			}
		  }
		}
	  }
	}
  }

  /* lock the lists and move the new one in */
  ldap_pvt_thread_mutex_lock(&nbc->obj_list_mutex);
  old_obj_list = nbc->nws_obj_list;
  nbc->nws_obj_list = new_head;
  ldap_pvt_thread_mutex_unlock(&nbc->obj_list_mutex);

  /* clean up the old list */
  obj = old_obj_list;
  while (obj != NULL) {
	old_obj = obj;
	obj = obj->next;
	if (old_obj != NULL) {
	  nws_free_obj(old_obj);
	}
  }

  Debug(LDAP_DEBUG_TRACE, "<==nws_cache_parse()\n",0,0,0);
  return(1);
}




