(*
 * Graph: generic graph library
 * Copyright (C) 2004
 * Sylvain Conchon, Jean-Christophe Filliatre and Julien Signoles
 * 
 * This software is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License version 2, as published by the Free Software Foundation.
 * 
 * This software is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * 
 * See the GNU Library General Public License version 2 for more details
 * (enclosed in the file LGPL).
 *)

module type HashedOrderedType = sig
  type t
  val equal : t -> t -> bool
  val hash : t -> int 
  val compare : t -> t -> int 
end

module type S = sig
  type elt
  type t
    
  val init : elt list -> t
  val find : elt -> t -> elt
  val union : elt -> elt -> t -> unit
end


module Make(X:HashedOrderedType) = struct

  type elt = X.t
  module H = Hashtbl.Make(X)
  type t = elt H.t * (elt list) H.t

  let init l = 
    let r = H.create 997 in
    let s = H.create 997 in
      List.iter (fun v-> H.add r v v; H.add s v [v]) l;
      r,s

  let find x (r,s) = H.find r x

  let union x y (r,s) = 
    let rx,ry = H.find r x , H.find r y in
    let sx,sy = H.find s rx , H.find s ry in
      if not(X.equal rx ry) then begin
	List.iter (fun v->H.replace r v rx ) sy;
	H.replace s rx (sx@sy);
      end
      
end
