/*
 * testpkt.h --
 *
 *      Diagnostic functions to test packetization and extraction of packets
 *
 * Copyright (c) 1996-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * @(#) $Header: /usr/mash/src/repository/mash/mash-1/mb/testpkt.h,v 1.5 2002/02/03 03:16:30 lim Exp $
 */

#ifndef TESTPKT_H
#define TESTPKT_H

extern "C"
{
#include <string.h>
};
#include "mb-cmd.h"

// these are the routines that is used to diagnose packetization
// and extraction

// packetize it, extract from it, then packetize again,
// the 2 packets should be identical
//
#ifdef MB_DEBUG
inline Bool TestPacketize(MBCmd* pCmd) {
    int len=pCmd->getPacketLen();
    Byte *pb =  new Byte[len+10];
    memset(pb, 0, len+10);
    int i;

    // put a guard region for counter checking
    // that memory is not overwritten
    for (i=pCmd->getPacketLen();i<10;i++) pb[i]=i+23;

    Byte *pbEnd=pCmd->Packetize(pb);

    for (i=pCmd->getPacketLen();i<10;i++) assert(pb[i]==i+23);
    assert(pbEnd==pb+len);
    MBCmd* pNewCmd = MBCmd::Create(0,pb);
    for (i=pCmd->getPacketLen();i<10;i++) assert(pb[i]==i+23);

    assert(len==pNewCmd->getPacketLen());
    Byte *pbNew = new Byte[len+10];
    memset(pbNew, 0, len+10);
    for (i=pNewCmd->getPacketLen();i<10;i++) pb[i]=i+23;
    Byte* pbEndNew=pNewCmd->Packetize(pbNew);
    for (i=pCmd->getPacketLen();i<10;i++) assert(pb[i]==i+23);
    assert(pbEndNew==pbNew+len);

    for (i=0;i<len;i++) {
        if (pb[i]!=pbNew[i]) {
            Trace(ALL,("failed at i=%d, pb[i]=%x, pbNew[i]=%x, len=%d",
                       i, pb[i], pbNew[i], len));
        }
        assert(pb[i]==pbNew[i]);
    }
    delete[] pb;
    delete[] pbNew;
    delete pNewCmd;

    return TRUE;
}
#endif

#endif /* #ifdef TESTPKT_H */
