/*
 * misc.cc --
 *
 *      This file defines a number of TclClasses which can be accessed by name
 *      from Tcl's global namespace. Specifically, this allows Tcl code to
 *      execute C code through the command function without needing to
 *      instantiate a TclClass.
 *
 * Copyright (c) 1996-2001 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef lint
static const char rcsid[] =
    "@(#) $Header: /usr/mash/src/repository/mash/mash-1/misc/misctk.cc,v 1.3 2002/02/24 00:11:16 lim Exp $";
#endif

#include <tclcl.h>
#ifdef USE_DDRAW
#include <tkWin.h>
#endif
#include "vw.h"

class MonitorInfoCommand : public TclCommand {
public:
        MonitorInfoCommand() : TclCommand("get_monitorinfo") { }
        virtual int command(int argc, const char*const* argv);
private:
        char monitorinfo_[4096];
};

int MonitorInfoCommand::command(int /* argc */, const char*const* /* argv */)
{
        Tcl& tcl = Tcl::instance();
#ifdef USE_DDRAW
        // We need to call DDrawOkay here to make sure the multiple
        // monitor information gets initialized. The width and height
        // arguments appear to not matter, so we just use 2 as the
        // value since Matt comments that Mash tends to like to
        // destroy 1x1 sized windows.
        DDrawVideoImage::DDrawOkay(2, 2, Tk_GetHWND(Tk_WindowId(tcl.tkmain())));
        DDrawVideoImage::getTclMonitorList(monitorinfo_);
        tcl.result(monitorinfo_);
#else
        tcl.result("");
#endif
        return (TCL_OK);
};


void init_tkmisc()
{
	(void)new MonitorInfoCommand;
}
