/*
 * ns-map.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef mash_srmv2_nsmap
#define mash_srmv2_nsmap

#include <tcl.h>

class NS_Node;
class SRMv2_NameSpace;
#include "srmv2.h"
#define SRMv2_CLD 0
#define SRMv2_HOT 1
#define SRMv2_UNUSED 2
#define SRMv2_INIT_PRIO 1
#define MAXNAMES 1024
/*
 * A NameMap contains 2 tables: one that map names to containers, and
 * another that maps container ids to ASCII names.
 */
struct activity {
	unsigned char hot; /* Boolean, SRMv2_HOT ==> hot, SRMv2_CLD ==> cold,
			    * SRMv2_UNUSED ==> unused */
	unsigned char selected;
        int tix;
};

class NameMap {
 public:
	NameMap();
	NS_Node* getnode(char *name);
	int  getcid(char *name);
	char* getname(int id) { return names_[id]; }
	unsigned int copen(const char *name, unsigned int cid=0);
	unsigned int calloc(unsigned int parent, const char *relname,
			    int *created, unsigned int cid=0);
	unsigned int insert(char *name, NS_Node *node);
	void init_prio();
	srmv2_announcehdr* hiprio(unsigned int count);
	void update_prio(unsigned int cid);
	void sort_prio(float* winner, int sz);
	void build_record(srmv2_announcehdr *sh, unsigned int cid);
	void regadu(unsigned int cid, unsigned int seqno, unsigned int ebytes);
	SRMv2_NameSpace* get_namespace() { return namespace_; }

 protected:
	Tcl_HashTable* nodes_;	/* name --> NS_Node* */
	char* names_[MAXNAMES]; /* container id --> ASCII name */
	SRMv2_NameSpace *namespace_;
	activity* prio_;
};

#endif

