/*
 * session-srmv2.h --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 1998-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#ifndef srmv2_session_h
#define srmv2_session_h

#include "tclcl.h"
#include "inet.h"
#include "srmv2.h"
#include "pktbuf-srmv2.h"
#include "net.h"
#include "transmitter.h"

/*extern "C" {
#include "srmv2-api.h"
}*/

class SRMv2_BufferPool;
class SRMv2_Manager;
class SRMv2_Source;

class SRMv2_TokenBucket : public Timer {
public:
	SRMv2_TokenBucket(SRMv2_Session* session);
	~SRMv2_TokenBucket() {}
	void request_to_send(unsigned int cid, unsigned int seqno, unsigned int sbytes,
			     unsigned int ebytes);
	void update_avbl(unsigned int bytes);
	void rate(double r) { rate_ = r * 1000/8; }
private:
	void timeout();
	double rate_; /* Bytes/second */
	double wait_; /* Waiting time in seconds */
	int avbl_;    /* Available bytes bucket */
	double sampleTime_; /* Previous NTP time the rate was sampled and bytes updated */
	unsigned int cid_;
	unsigned int seqno_;
	unsigned int sbytes_;
	unsigned int ebytes_;
	SRMv2_Session *session_;
};

class SRMv2_Session : public Transmitter, public SessionHandler {
public:
	SRMv2_Session();
	~SRMv2_Session() { }

	int  command(int argc, const char*const* argv);
	SRMv2_Source *local_source() { return lsrc_; }
	void announce(CtrlHandler*) { }

	void send_adu(SRMv2_Source *source, char *data,
		      unsigned int ss, unsigned int sbytes,
		      unsigned int ebytes, unsigned int adulbytes,
		      unsigned int cid, unsigned char type, unsigned char frag=0);

	void send_rreq(SRMv2_Source *source, unsigned int ss,
		       unsigned int es, unsigned int sbytes,
		       unsigned int ebytes, unsigned int cid);

	void send_announce(SRMv2_Source *src, srmv2_announcehdr* sa_list, int count,
			   unsigned char type=SRMv2_ANNOUNCE);
	void start_announce();
	void recv(DataHandler*);
	void recv(CtrlHandler*) { }
	void send_delayinfo();
	void clear_to_send(unsigned int cid, unsigned int seqno, unsigned int sbytes,
			   unsigned int ebytes, int alen);
	SRMv2_Source *source(int *srcID, unsigned int address, int *created);
	SRMv2_Source *source(SRMv2_Source *src);
	double backoff(SRMv2_Source* src, unsigned int level);
	int recover(char *aname, unsigned int start, unsigned int end);
	FILE* logfile() { return logfile_; }
	SRMv2_TokenBucket* tokenBucket() { return tokenBucket_; }

protected:
	void simloss(int len);
	void transmit(pktbuf* pb);
	void parse_header(pktbuf *pb, unsigned int addr);
	void timeout();
	float delay(unsigned int addr);
	void fill_delays(pktbuf* pb);
	void update_delay(unsigned int addr, unsigned int tsend, unsigned int n,
			  srmv2_delayhdr* dvec);


	int badproto_;
	int simcount_;
	int atimer_;   /* SRM_ANNOUNCE timer, in ms */
	double lossProb_;
	float c1_;
	float c2_;
	FILE* logfile_;

	DataHandler dh_;
	CtrlHandler ch_;
	pktbuf *pb_;
	SRMv2_Source *lsrc_;
	SRMv2_Manager *manager_;
	SRMv2_BufferPool *pool_;
	SRMv2_TokenBucket *tokenBucket_;
        Tcl_HashTable  *srcs_;
        Tcl_HashTable  *delayinfo_; /* Delay information, indexed by IPv4 addresses */
};
#endif

