# avswitch-srvr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/avswitch-server/avswitch-srvr.tcl,v 1.13 2002/02/03 04:21:37 lim Exp $


import SerialChannel/AVSwitch-Knox-RS8x8 UDPServer Rendezvous


#
# a UI-less server that accepts RPC-like commands and
# returns results for controlling an avswitch
#
Class AVSwitchServer

AVSwitchServer public init {addrspec} {
    $self instvar avswitch_ al_ prev_vs_ addrspec_

    set addrspec_ $addrspec
    set avswitch_ [new SerialChannel/AVSwitch-Knox-RS8x8 1024]
    set al_ [new UDPServer/AVSwitch $addrspec $self]
    set prev_vs_ ""
    set raddr [$self get_option rendez]
    if {$raddr != ""} {
	$self start_rendezvous_ads $raddr
    }
}

AVSwitchServer public destroy {} {
    $self instvar al_ avswitch_ advertiser_

    delete $al_
    delete $avswitch_
    if {$raddr != ""} {
	delete advertiser_
    }
    eval [list $self] next
}

AVSwitchServer public set_routes {args} {
    $self instvar avswitch_

    set args [lindex $args 0]   ; # this is necessary 'cause param is "args"
    #puts "args: $args"

    if {[llength $args] != 3} {
	puts "bad \# of args to set-routes"
	return
    }
    set cmd [lindex $args 0]
    set out [lindex $args 1]
    set in [lindex $args 2]

    if {$out > 8 || $out < 1 || $in > 8 || $in < 1} {
	puts "bad values to set-routes"
	return
    }

    eval $avswitch_ $args
}


#
AVSwitchServer public get_video_settings {} {
    $self instvar avswitch_
    return [$avswitch_ array get videoSettings_]
}

#
AVSwitchServer public get_audio_settings {} {
    $self instvar avswitch_
    return [$avswitch_ array get audioSettings_]
}

# start advertising mappings to rendezvous address `raddr'
AVSwitchServer public start_rendezvous_ads {raddr} {
    $self instvar advertiser_ prev_vs_ addrspec_
    array set voutlist "6 [gethostbyname diamond] 7 [gethostbyname heart] \
	    8 [gethostbyname club]"
    array set vinlist "5 CoLab/cam1 6 CoLab/cam2 7 CoLab/cam3 8 CoLab/cam4"

    set vs [$self get_video_settings]
    # if not parsed yet, try again later
    if {[lsearch $vs 0] != -1} {
	after 2000 "$self start_rendezvous_ads $raddr"
	return
    }
    # check for a change in settings
    if {$vs != $prev_vs_} {
	set prev_vs_ $vs
	if [info exists advertiser_] {delete $advertiser_}
	set advertiser_ [new Rendezvous $raddr]
	set msg ""
	puts "advertising camera<->machine settings to $raddr"
	foreach {vout vin} $vs {
	    if {$vin == 5 || $vin == 6 || $vin == 7 || $vin == 8} {
		if {$vout == 6 || $vout == 7 || $vout == 8} {
		    append msg "camera: camName:$vinlist($vin)"
		    append msg " videoIn:$voutlist($vout)\n"
		}
	    }
	}
	puts "$msg"
	$advertiser_ start $msg

	set msg "will-provide: mash-object=AVSwitchServer ctrlspec=$addrspec_"
	set uid [$self get_option uniqid]
	if {$uid != ""} {set msg "$msg uniqid=$uid"}
	$advertiser_ start $msg
    }
    after 5000 "$self start_rendezvous_ads $raddr"
}


#
#------------------------------------------------------------
#

# AVSwitch RPC-style interface
#
Class UDPServer/AVSwitch -superclass UDPServer

UDPServer/AVSwitch public init {addrspec parent} {
    $self instvar parent_ pending_announce_
    set parent_ $parent
    set pending_announce_ -1

    eval [list $self] next $addrspec
}


UDPServer/AVSwitch private recv {addr port data size} {
    puts "Msg: $addr\[$size\]: $data"

    $self instvar parent_ pending_announce_

    set theMethod [lindex $data 0]
    switch $theMethod {
	refresh_settings {[$parent_ set avswitch_] refresh_settings}
	test_LEDs {[$parent_ set avswitch_] test_LEDs}
	route_both -
	route_audio -
	route_video {$parent_ set_routes "$data"}
    }
    if {$pending_announce_ != -1} {
	after cancel $pending_announce_
    }
    # have to wait for the update from the switch to be received & processed
    set pending_announce_ [after 4000 $self announce_reply]
}

UDPServer/AVSwitch private announce_reply {} {
    $self instvar parent_ pending_announce_

    set av [$parent_ set avswitch_]
    set v [$av array get videoSettings_]
    set a [$av array get audioSettings_]
    $self announce "v: $v ; a: $a"
    after 10 $self announce [list "v: $v ; a: $a"]
    after 40 $self announce [list "v: $v ; a: $a"]
    set pending_announce_ -1
}

