# dynamic_html.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/applications/pathfinder/dynamic_html.tcl,v 1.12 2002/02/03 04:22:06 lim Exp $


import HTTP_Agent/Play_Agent
import HTTP_Agent/SDP_Agent
import HTTP_Agent/Rec_Agent
import SDPMessage
import SDPMedia
import SDPTime
import Program
import SessionCatalog

Class DynamicHTMLifier

DynamicHTMLifier proc init_ { } {
    $self parentify HTTP_Agent/Play_Agent
    $self parentify HTTP_Agent/SDP_Agent
    $self parentify HTTP_Agent/Rec_Agent
    $self parentify SDPMessage
    $self parentify SDPMedia
    $self parentify SDPTime
    $self parentify Program
    $self parentify SessionCatalog

    # Initialize the html directory.
    #set html_dir ~/mash/tcl/applications/mash_server/html/
    set o [$self options]
    $o load_preferences "pathfinder"
    set html_dir [$self get_option html_dir]

    # HTML files for the Play_Agent
    append playback_list $html_dir playback-list.html
    $self set htmlfiles_(playback_list) $playback_list
    append playback_msg $html_dir playback-msg.html
    $self set htmlfiles_(playback_msg) $playback_msg
    append playback_desc $html_dir playback-desc.html
    $self set htmlfiles_(playback_desc) $playback_desc

    # HTML files for the SDP_Agent
    append sessions_list $html_dir live-list.html
    $self set htmlfiles_(sessions_list) $sessions_list
    append sessions_msg $html_dir live-msg.html
    $self set htmlfiles_(sessions_msg) $sessions_msg
    append sessions_desc $html_dir live-desc.html
    $self set htmlfiles_(sessions_desc) $sessions_desc

    append media $html_dir media.html
    $self set htmlfiles_(media) $media

    append time_none $html_dir time_none.html
    $self set htmlfiles_(time_none) $time_none
    append time_weekly $html_dir time_weekly.html
    $self set htmlfiles_(time_weekly) $time_weekly
    append time_daily $html_dir time_daily.html
    $self set htmlfiles_(time_daily) $time_daily

    append time1_none $html_dir time1_none.html
    $self set htmlfiles_(time1_none) $time1_none
    append time1_weekly $html_dir time1_weekly.html
    $self set htmlfiles_(time1_weekly) $time1_weekly
    append time1_daily $html_dir time1_daily.html
    $self set htmlfiles_(time1_daily) $time1_daily

    # HTML files for the Rec_Agent
    append recordings_list $html_dir record-list.html
    $self set htmlfiles_(recordings_list) $recordings_list
    append record_msg $html_dir record-msg.html
    $self set htmlfiles_(record_msg) $record_msg
    append recordings_status $html_dir record-status.html
    $self set htmlfiles_(recordings_status) $recordings_status

	if { [$self get_option allow_distrib] == "yes" } {
		$self set htmlfiles_(recordings_status) $recordings_status
		append distrib_recordings $html_dir distrib-record.html
		$self set htmlfiles_(distrib_recordings) $distrib_recordings
		append dr_msg $html_dir dr-msg.html
		$self set htmlfiles_(dr_msg) $dr_msg
	}

    $self read_html
    after 900 "$self read_html"
}


DynamicHTMLifier proc parentify { cls } {
    set super [$cls info superclass]
    set idx [lsearch -exact $super Object]
    if { $idx!=-1 } {
	set super [lreplace $super $idx $idx]
    }
    lappend super $self
    $cls superclass $super
}


DynamicHTMLifier proc read_html { } {
    $self instvar htmlfiles_
    foreach file [array names htmlfiles_] {
	puts "Reading HTML file: $htmlfiles_($file)"
	$self read_file $htmlfiles_($file) $file
    }
}


DynamicHTMLifier proc read_file { filename subscript } {
    $self instvar html_

    set html_($subscript) ""
    set file [open $filename]
    while { ![eof $file] } {
	append html_($subscript) "[gets $file]\n"
    }
    close $file
}


DynamicHTMLifier instproc create_dynamic_html { html } {
    set new_html { }

    set idx [string first "<%" $html]
    while { $idx != -1 } {
	append new_html [string range $html 0 [expr $idx-1]]
	set html [string range $html [expr $idx+2] end]
	set idx [string first ">" $html]
	if { $idx==-1 } {
	    error "Error in dynamic HTML: Can't find closing '>'"
	}
	set cmd [string range $html 0 [expr $idx-1]]
	set html [string range $html [expr $idx+1] end]
	append new_html [eval $cmd]
	set idx [string first "<%" $html]
    }

    append new_html $html
    return $new_html
}

DynamicHTMLifier init_

