# fca-rcvr.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1997-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


####? should this belong here
Class FloorGrant
FloorGrant instproc init {floorType floorInstance {grantSeqNo {}} {srcId {}} {requestId{}} } {
    # requestId_ -- request to grant to
    $self instvar srcId_ grantSeqNo_ floorType_ floorInstance_ requestId_
    set srcId_ $srcId
    set grantSeqNo_ $grantSeqNo
    set floorType_ $floorType
    set floorInstance_ $floorInstance
    set requestId_ $requestId
}


Class FCAFloorRequest
FCAFloorRequest instproc init {srcId {requestId {}} {floorTypes {}} \
	{comment {}} } {
    $self next
    $self instvar srcId_ requestId_ floorTypes_  comment_
    set floorTypes_ $floorTypes
    set requestId_ $requestId
    set srcId_ $srcId
    set comment_ $comment
}


# return a list which contains uid addr and comment of the request
FCAFloorRequest instproc request {} {
    $self instvar requestId_ srcId_ comment_
    return {$requestId_ $srcId_ $comment_}
}


FCAFloorRequest instproc requestId {} {
    $self instvar requestId_
    return $requestId_
}


FCAFloorRequest instproc srcId {} {
    $self instvar srcId_
    return $srcId_
}


FCAFloorRequest instproc floorTypes {} {
    $self instvar floorTypes_
    return $floorTypes_

}

FCAFloorRequest instproc comment {} {
    $self instvar comment_
    return $comment_
}



Class FCAAllRequests

FCAAllRequests instproc init { } {
    $self set doneRequestId_ 0
    $self set maxRequestId_  0
}


FCAAllRequests instproc is_canceled { requestId } {
    $self instvar requests_ doneRequestId_

    if { $requestId <= $doneRequestId_ && \
	    ![info exists requests_($requestId)] } {
	return 1
    }

    if { [info exists requests_($requestId)] && \
	    $requests_($requestId)=="canceled" } {
	return 1
    }
    return 0
}


FCAAllRequests instproc have { requestId } {
    $self instvar requests_
    if { [info exists requests_($requestId)] } {
	set request $requests_($requestId)
	if { $request!={} && $request!="canceled" } {
	    return 1
	}
    }
    return 0
}


FCAAllRequests instproc dont_have { requestId } {
    $self instvar requests_ doneRequestId_
    if { $requestId <= $doneRequestId_ } {
	# we always have everything upto doneRequestId_
	return 0
    }

    if { ![info exists requests_($requestId)] || $requests_($requestId)=={} } {
	return 1
    }
    return 0
}


FCAAllRequests instproc incr { requestId } {
    $self instvar requests_ doneRequestId_ maxRequestId_
    if { $requestId > $maxRequestId_ } {
	set maxRequestId_ $requestId
    }

    if { $requestId == [expr $doneRequestId_ + 1] } {
	while { $doneRequestId_ < $maxRequestId_ && \
		![$self dont_have [expr $doneRequestId_+1] ]} {

	    if { [$self is_canceled [expr $doneRequestId_ + 1]] } {
		unset requests_([expr $doneRequestId_ + 1])
	    }
	    incr doneRequestId_
	}
    }
}


# request may be "" indicating that we know this request is around, but we
# don't have the actual data yet
FCAAllRequests instproc got_request { requestId request } {
    $self instvar requests_
    set requests_($requestId) $request
    $self incr $requestId
}


FCAAllRequests instproc cancel { requestId } {
    $self instvar requests_ doneRequestId_

    if { $requestId <= $doneRequestId_ } {
	catch { unset requests_($requestId) }
	return
    }

    if { [info exists requests_($requestId)] } {
	set request $requests_($requestId)
	if { $request!="" } {
	    delete $request
	}
    }

    set requests_($requestId) "canceled"
    $self incr $requestId
}


FCAAllRequests instproc get { requestId } {
    $self instvar requests_
    if { [info exists requests_($requestId)] } {
	return $requests_($requestId)
    } else {
	return ""
    }
}


FCAAllRequests instproc doneRequestId { } {
    return [$self set doneRequestId_]
}


FCAAllRequests instproc maxRequestId { } {
    return [$self set maxRequestId_]
}



Class FCAImportant
FCAImportant instproc init { } {
    $self next
    $self set maxSeqno_ 0
}


# type is either cancel or release
# id is the requestId for "cancel", grantSeqno for "release"

FCAImportant instproc add { type id } {
    $self instvar list_ maxSeqno_
    incr maxSeqno_
    set list_($maxSeqno_) "$type $id"
    return $maxSeqno_
}

FCAImportant instproc get { seq } {
    $self instvar list_
    if { [info exist list_($seq)] } {
	return $list_($seq)
    }
    return ""
}


FCAImportant instproc obsolete { seqno } {
    $self instvar list_ maxSeqno_
    if { $seqno <= $maxSeqno_ } {
	catch { unset list_($seqno) }
    } elseif { $seqno == [expr $maxSeqno_ + 1] } {
	incr maxSeqno_
    }
}


FCAImportant instproc obsolete_specific { type id } {
    $self instvar list_
    foreach entry [array names list_ *] {
	if { $list_($entry) == "$type $id" } {
	    unset list_($entry)
	}
    }
}


FCAImportant instproc is_obsolete { seqno } {
    $self instvar maxSeqno_ list_
    assert "$seqno <= $maxSeqno_"
    if { $seqno <= $maxSeqno_ } {
	if { ![info exists list_($seqno)] } {
	    return 1
	}
    }
    return 0
}


FCAImportant instproc maxSeqno { } {
    return [$self set maxSeqno_]
}


#FCAImportant instproc get { seqno typeVar idVar } {
#}


################## Generic rcvr ###################
Class FCARcvr/Tcl -superclass FCARcvr
FCARcvr/Tcl instproc init { mgr srcId } {
    $self next

    $self set mgr_ $mgr
    $self set srcId_ $srcId
    $self set requests_  [new FCAAllRequests]
    $self set important_ [new FCAImportant]
    $self set repairRequest_ ""
    $self set repairReply_ ""
    $self set test_ 1
}


FCARcvr/Tcl instproc repair_request {} {
    return [$self set repairRequest_]
}



FCARcvr/Tcl instproc get_requests { } {
    return [$self set requests_]
}


FCARcvr/Tcl instproc srcId {} {
    $self instvar srcId_
    return $srcId_
}


FCARcvr/Tcl instproc obsolete_important { type id } {
    [$self set important_] obsolete_specific $type $id
}


# return on whether need to reschedule
FCARcvr/Tcl instproc make_repair_request { isImportant sseq eseq } {
    $self instvar repairRequest_
    set newItem "$isImportant $sseq $eseq"
    set needSched 0
    if { $repairRequest_=="" } {
	set needSched 1
	set repairRequest_ [new FCARepairRequest/Tcl/Participant]
    }
    $repairRequest_ insert $newItem
    return $needSched
}


# make participant repair reply
FCARcvr/Tcl instproc make_repair_reply {list} {
    $self instvar repairReply_ requests_ important_ mgr_ srcId_

    DbgOut "in make_repair_reply, list = $list"
    DbgOut "FCARcvr/Tcl::make_repair_reply"
    set needSched 0
    foreach item $list {
	set important [lindex $item 0]
	set sseq [lindex $item 1]
	set eseq [lindex $item 2]
	DbgOut "FCARcvr/Tcl::make_repair_reply, this item is $item"


	if { $important } {
	    for {set i $sseq} {$i <= $eseq} {incr i 1} {
		# if 'i' is greater than the max we've seen, then we can't
		# reply; otherwise, we either have the data or it's already
		# obsolete

		if { $i <= [$important_ maxSeqno] } {
		    # we know for sure that either we have the data or
		    # the data is obsolete

		    set item [$important_ get $i]

		    if { $repairReply_=={} } {
			set needSched 1
			set repairReply_ [new FCARepairReply/Tcl/Participant]
		    }

		    set fcaPkt [new FCA_Packet]
		    switch [lindex $item 0] {
			cancel {
			    $fcaPkt set pktType PKT_FLOOR_CANCEL
			    $fcaPkt set seqno $i
			    $fcaPkt set requestId [lindex $item 1]
			}
			release {
			    not_implemented "release rreply"
			}
			"" {
			    # obsolete
			    $fcaPkt set pktType PKT_OBSOLETE
			    $fcaPkt set seqno $i
			}
		    }

		    $repairReply_ insertReply $fcaPkt
		}
	    }
	} else {
	    for {set i $sseq} {$i <= $eseq} {incr i 1} {
		DbgOut "it is floor request repair request"

		if {[$requests_ have $i]} {
		    if {$repairReply_ == "" } {
			set needSched 1
			set repairReply_ [new FCARepairReply/Tcl/Participant]
		    }
		    DbgOut "about to insert the reply"

		    set request [$requests_ get $i]

		    set fcaPkt [new FCA_Packet]
		    $fcaPkt set pktType PKT_FLOOR_REQUEST
		    $fcaPkt set requestId [$request requestId]
		    $fcaPkt set comment [$request comment]
		    $fcaPkt set floors [$request floorTypes]
		    $fcaPkt set numFloors [llength [$fcaPkt set floors]]

		    $repairReply_ insertReply $fcaPkt

		} elseif { [$requests_ is_canceled $i] } {
		    if {$repairReply_ == "" } {
			set needSched 1
			set repairReply_ [new FCARepairReply/Tcl/Participant]
		    }

		    set fcaPkt [new FCA_Packet]
		    $fcaPkt set pktType PKT_FLOOR_CANCEL
		    # FIXME: need to check whether this has been in the important
		    # list or not!
		    $fcaPkt set seqno 0
		    $fcaPkt set requestId $i

		    $repairReply_ insertReply $fcaPkt
		}
	    }
	}


	#for {set i $sseq} {$i <= $eseq} {incr i 1} {
	#    if {$important} {
	#	set cancelitem [$important_ get $i]
	#	if { $cancelitem != "" } {
	#	    # have the data to reply
	#	    if {$repairReply_ == "" } {
	#		set needSched 1
	#		set repairReply_ [new FCARepairReply/Tcl/Participant]
	#	    }
	#	    $repairReply_ insertReply $important "$cancelitem $i"
	#	}
	#    } else {
	#	DbgOut "it is floor request repair request"
	#	if {[$requests_ have $i]} {
	#	    if {$repairReply_ == "" } {
	#		DbgOut "needSched = 1"
	#		set needSched 1
	#		set repairReply_ [new FCARepairReply/Tcl/Participant]
	#	    }
	#	    DbgOut "about to insert the reply"
	#	    $repairReply_ insertReply $important [$requests_ get $i]
	#	}
	#    }
	#}
    }

    if {$needSched} {
	$mgr_ sched_reply $repairReply_ $srcId_
	DbgOut "FCARcvr/Tcl::make_repair_reply, repairReply ($repairReply_)\
		the replies are [$repairReply_ pktReplies]"
    }
}


#--- SRM callbacks ---#
# handling participant repair request
FCARcvr/Tcl instproc handle_request { fcaPkt } {
    $self instvar repairRequest_ mgr_ srcId_
    DbgOut "FCARcvr/Tcl::handle_request, about to make repair reply\
	    request list = [$fcaPkt set list]"
    DbgOut "localSrcId [$mgr_ set localSrcId_], rcvr srcId_ ($srcId_)"
    DbgOut "$$$$$$$$$$$$$$$$$$$$$$$$$$$"
    if {$repairRequest_ != "" } {
	if {[$repairRequest_ overlap $fcaPkt]} {
	    $repairRequest_ backoff
	    DbgOut "FCARcvr/Tcl::handle_request, repairRequest_ \
		    just backed off"
	    return
	}
    }
    # if not backed off, see whether can reply:
    DbgOut "FCARcvr/Tcl::handle_request, about to make repair reply\
	    request list = [$fcaPkt set list]"
    $self make_repair_reply [$fcaPkt set list]
}



# handle participant repair reply
FCARcvr/Tcl instproc handle_reply { replyPkt } {
    $self instvar mgr_ repairReply_ repairRequest_ requests_ important_

    DbgOut "!!!!!!!!!!!!!!!!!!FCARcvr/Tcl::handle_reply, $$$$$$$$$$$$$$$$$"
    if {$replyPkt == ""} {
	DbgOut "FCARcvr/Tcl::handle_reply, replyPkt is empty"
	return
    }
    set numReplies [$replyPkt set numReplies]
    DbgOut "FCARcvr/Tcl::handle_reply, in replyPkt, numReplies = $numReplies"
    set replies [$replyPkt set pktReplies]
    DbgOut "FCARcvr/Tcl::handle_reply, replies obj = $replies"
    foreach reply $replies {
	if {$repairReply_ != ""} {
	    set canceled [$repairReply_ cancel_reply $reply]
	    if { [$repairReply_ set numReplies] <= 0 } {
		# this reply's done
		delete $repairReply_
		DbgOut "Deleting repair reply!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
		set repairReply_ ""
	    }

	    DbgOut "FCARcvr/Tcl handle_reply, canceled = $canceled"
	    continue
	}

	set replyPktType [$reply set pktType]
	DbgOut "FCARcvr/Tcl::handle_reply, replyPktType -- $replyPktType"
	switch $replyPktType  {
	    "PKT_FLOOR_REQUEST" {
		DbgOut "it is a floor request repair reply, \
			FCARcvr/Tcl::handle_reply"
		set replyRequestId [$reply set requestId]
		if { [$requests_ dont_have $replyRequestId] } {
		    DbgOut "FCARcvr/Tcl::handle_reply, make repair for floor\
			    request"
		    $self handle_floor_request $reply

		    # adjust repair request after repairing
		    if {$repairRequest_!="" } {
			$repairRequest_ gotReply 0 $replyRequestId
			if { [$repairRequest_ set numRequests]==0 } {
			    delete $repairRequest_
			    DbgOut "Deleting repair request\
				    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			    set repairRequest_ ""
			}
		    }
		}
	    }
	    "PKT_FLOOR_CANCEL"  {
		set replySeqno [$reply set seqno]
		set maxCancelSeq [$important_ maxSeqno]
		$self handle_floor_cancel $reply

		#adjust repair request after repairing
		if {$repairRequest_!="" } {
		    if { $replySeqno==0 } {
			$repairRequest_ gotReply 0 [$reply set requestId]
		    } else {
			$repairRequest_ gotReply 1 $replySeqno
		    }
		    if { [$repairRequest_ set numRequests]==0 } {
			delete $repairRequest_
			DbgOut "Deleting repair request\
				!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			set repairRequest_ ""
		    }
		}
	    }
	    "PKT_FLOOR_RELEASE" {
		not_implemented yet
		DbgOut "FCARcvr/Tcl::parse_reply, release may not work!"
		set replySeqno [$reply set seqno]
		set maxCancelSeq [$important_ maxSeqno]
		if {[$replySeqno == [expr $maxCancelSeq + 1]} {
		    $self handle_floor_release $reply

		    #adjust repair request after repairing
		    if {$repairRequest_!="" } {
			$repairRequest_ gotReply 1 $replySeqno
			if { [$repairRequest_ set numRequests]==0 } {
			    delete $repairRequest_
			    DbgOut "Deleting repair request\
				    !!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			    set repairRequest_ ""
			}
		    }
		}
	    }
	    "PKT_OBSOLETE" {
		set seqno [$reply set seqno]
		$self instvar important_
		$important_ obsolete $seqno

		#adjust repair request after repairing
		if {$repairRequest_!="" } {
		    $repairRequest_ gotReply 1 $seqno
		    if { [$repairRequest_ set numRequests]==0 } {
			delete $repairRequest_
			DbgOut "Deleting repair request\
				!!!!!!!!!!!!!!!!!!!!!!!!!!!!!"
			set repairRequest_ ""
		    }
		}
	    }
	    default {
		DbgOut "FCARepairReply/Tcl/ParticipantFCARcvr/Tcl::\
			cancel, wrong packet type"
	    }

	}
#	if {!$repaired} {
	    # adjust/cancel the repairReply_
	    # if no repair made by the incoming reply
#	    if {$repairReply_ != ""} {
#		$repairReply_ cancel_reply $reply
#	    }
#	}
    }
}



# non-moderator rcvr will only make participant repair request
FCARcvr/Tcl instproc handle_SA { fcaPkt } {
    $self instvar mgr_ srcId_ requests_ repairRequest_ important_

    DbgOut "FCARcvr/Tcl::handle_SA, at participant rcvr ($srcId_), \
	    got session announcement from $srcId_:\
	    [$fcaPkt set maxRequestId] [$fcaPkt set maxImportantSeqno]"

    DbgOut "FCARcvr/Tcl::handle_SA, localsrcId = [$mgr_ localSrcId]\
	    rcvr srcId = $srcId_"
    if { [$mgr_ set localSrcId_] == $srcId_ } {
	DbgOut "FCARcvr/Tcl::handle_SA, this is a local rcvr, shouldn't be \
		handled here!!"
    }
    set fcd [$mgr_ fcDynamics]
    set needSched 0
    if { ![$fcd isRequestQFull] } {
	set maxRequestId [$fcaPkt set maxRequestId]
	set myMaxRequestId [$requests_ maxRequestId]
	if { $maxRequestId > $myMaxRequestId } {
	    set qSpace [$fcd avail_requestQ_space]
	    set sseq [expr [$requests_ maxRequestId] + 1]
	    set eseq [expr $sseq + $qSpace]
	    if { $eseq > $maxRequestId } {
		set eseq $maxRequestId
	    }
	    set newItem "0 $sseq $eseq"
	    if { $repairRequest_=="" } {
		set needSched 1
		set repairRequest_ [new FCARepairRequest/Tcl/Participant]
	    }
	    $repairRequest_ insert $newItem
	}
    }

    set myImportantSeqno [$important_ maxSeqno]
    set maxImportantSeqno [$fcaPkt set maxImportantSeqno]

    if { $maxImportantSeqno > $myImportantSeqno } {
	set newItem "1 [expr $myImportantSeqno+ 1] $maxImportantSeqno"
	if { $repairRequest_=="" } {
	    set repairRequest_ [new FCARepairRequest/Tcl/Participant]
	    set needSched 1
	}
	$repairRequest_ insert $newItem
    }
    if {$needSched} {
	DbgOut "handleSA: repairRequest = $repairRequest_"
	$mgr_ sched_request $repairRequest_ $srcId_
	DbgOut "repairRequest_(participant) ($repairRequest_) sent out"
	DbgOut "numRequests = [$repairRequest_ set numRequests]\
		list = [$repairRequest_ set list] \
		pktType = [$repairRequest_ set pktType] "
#	after 1000
    }
}



FCARcvr/Tcl instproc recv { fcaPkt } {
    set pktType [$fcaPkt set pktType]
    switch $pktType {
	"PKT_FLOOR_REQUEST" {
	    $self handle_floor_request $fcaPkt
	}
	"PKT_FLOOR_CANCEL" {
	    $self handle_floor_cancel $fcaPkt
	}
	"PKT_FLOOR_RELEASE" {
	    $self handle_floor_release $fcaPkt
	}
	default {
	    DbgOut "[$self srcId]: should not receive $pktType here!"
	}
    }
}


FCARcvr/Tcl instproc handle_floor_request { fcaPkt } {
    $self instvar mgr_ srcId_ requests_ srcId_ test_

    ###!! testing handle_sa and making repair request
#    if {$test_} {
#	set test_ 0
#	DbgOut "rcvr $self ($srcId_) ignoring request [$fcaPkt set requestId]"
#	return
#    }
    DbgOut "FCARcvr/Tcl handle_floor_request, about to rehandle the request"
    set fcDynamics [$mgr_ fcDynamics]
    if { [$fcDynamics isRequestQFull] } {
	# for now, just ignore requests that arrive after the queue is full
	return
    }

    set requestId [$fcaPkt set requestId]
    if { ![$requests_ dont_have $requestId] } {
	# we already have this request, or we don't care about it any more;
	# ignore this packet
	return
    }

    if { $requestId > [expr [$requests_ maxRequestId] + 1] } {
	# this packet is out of order, reject it
	DbgOut "Received out of order floor request"
	return
    }

    # add this request to the list of requests I know of
    set request [new FCAFloorRequest $srcId_ $requestId [$fcaPkt set floors] \
	    [$fcaPkt set comment]]
    $requests_ got_request $requestId $request
    $fcDynamics handle_floor_request $request
}


FCARcvr/Tcl instproc handle_floor_cancel { fcaPkt } {
    $self instvar lastRequestId_ mgr_ requests_ important_ srcId_

    ###!! testing handle_sa and making repair request
#    DbgOut "rcvr $self ($srcId_) ignoring cancel [$fcaPkt set seqno] \
#	    for request [$fcaPkt set requestId]"
#    return

    set seqno [$fcaPkt set seqno]
    if { $seqno > 0 && $seqno != [expr [$important_ maxSeqno] + 1] } {
	# discard this packet, coz it's not in sequence
	return
    }

    set requestId [$fcaPkt set requestId]
    if { $requestId > [expr [$requests_ maxRequestId] + 1] } {
	# ignore out of sequence request id
	return
    }

    # I am trying to delete a (possibly) admitted request
    # (or the next packet in sequence)

    set fcDynamics [$mgr_ fcDynamics]
    set needQueueUpdate 0
    if { [$fcDynamics remove_admitted_request [$self srcId] $requestId] } {
	# this request was in the admitted list i.e. we haven't received a
	# queue update for it; we keep the cancel msg in our important_
	# list until we hear from the moderator

	set needQueueUpdate 1
	if { $seqno > 0 } {
	    $important_ add cancel $requestId
	}
    } else {
	# this requestId is not in the admitted list
	# i.e. it's either not been admitted yet, or it has been admitted and
	# removed: check for the cancel msg's seqno; if it's > 0, it means it
	# had been admitted

	if { $seqno > 0 } {
	    $important_ obsolete $seqno
	}
    }

    $fcDynamics handle_floor_cancel $srcId_ $requestId $needQueueUpdate
    $requests_ cancel $requestId
}


FCARcvr/Tcl instproc handle_floor_release { fcaPkt } {
    $self instvar mgr_
    set localIsModerator [$mgr_ localIsModerator]
    set fcDynamics [$mgr_ fcDynamics]
    set numUpdates [$fcaPkt set numUpdates]
    set pktUpdates [$fcaPkt set pktUpdates]
    if { $numUpdates != [llength $pktUpdates]} {
	DbgOut "numfls != number of updates within pktGrants"
    }
    set needToUpdate 0
    set releaseUpdates {}
    set numReleased
    foreach i $pktUpdates {
	set grantSeqNo [$i set grantSeqno]
	set srcId [$i set srcId]
	set floorType [$i set floorType]
	set instance [$i set floorInstance]
	set requestId [$i set requestId]
	set release [new FloorGrant $floorType $floorInstance $grantSeqNo $srcId $requestId]
	set lastGrant [$fcDynamics getIsGrant $floorType $instance]
	set bigger [expr $grantSeqNo > $lastGrant]
	if {![$self GRIsStale $floorType $instance $grantSeqNo]} {
	    # if not a stale release
	    if {($localIsModerator) && (!$bigger) } {
		# equal and is moderator
		set success [$fcDynamics releaseHolder $floorType $instance $grantSeqNo]
		if {$success} {
		    set needToUpdate 1
		    incr numFlReleased 1
		    set releaseUpdates [lappend $releaseUpdates $i]
		} else {
		    DbgOut "releaseHolder failed"
		}
	    }

	}
    }
    if {$needToUpdate} {
        # send release update
	$fcDynamics incrStateNum
	set newStateNum [$fcDynamics curStateNum]
	set isGrant 0
	set modRcvr [$mgr_ localRcvr]
	$modRcvr sendGrantUpdate $isGrant $releaseUpdates $newStateNum
    }
}
