# agent-rtp-simple.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 2000-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.

import RTPAgent

# We inherit from RTPAgent so that when a new source is discovered, the
#   activate call does the right stuff
#
# The idea is that we can create a simple RTP agent that can get audio or
#   video packets, and we can give it the Tcl/C++ split objects to attach to
#   that will be passed the RTP and RTCP packets
#
# This makes it easy to grab all the data or rtcp packets from a specified
#   multicast address and have them sent to your handlers
#
# I wasn't able to find a class that already existed that allows this, though
#   you'd think there would be....
#
# A simple use is:
#
#    set dHandler [new Module/DFIXME]
#    set cHandler [new Module/CFIXME]
#    set agent [new RTPSimpleAgent audio 233.1.1.1/9000 $dHandler $cHandler]
#
#    DFIXME and CFIXME are split objects that are derived from a PacketModule, such
#       as Module/VideoDecoder/Null
#
#    DFIXME must call pb->release() on the packet in it's recv() call (or an
#       object that is passed the packet must call it)
#
#    This will set up an agent that looks for RTP packets on the 233.1.1.1/9000
#       multicast address and when it receives data packets, will call the
#       dHandler's recv() function.  RTCP packets received will be passed on
#       to the cHandler through its recv() function.
#
#
Class RTPSimpleAgent -superclass RTPAgent


# type = "audio" or "video"
# addr = addr/port string
#
# We don't really need to differentiate the type of session;
#   the audio, video, etc sessions don't filter out other types of packets
#
# Apparently, the Session/RTP is a virtual class that should not be directly
#   instantiated; not sure why, since the AudioSession class is just the
#   RtpSession class.  As a result, we pass in the type to the constructor
RTPSimpleAgent instproc init { type addr dataHandler controlHandler} {
    $self instvar dataHandler_ controlHandler_ type_

    set type_ $type
    if {$type_ != "audio" && $type_ != "video"} {
	puts stderr "RTPSimpleAgent::create_session: warning, invalid type \"$type_\" specified, defaulting to audio; valid values are \[audio, video\]"
	set type_ "audio"
    }

    set dataHandler_ $dataHandler
    set controlHandler_ $controlHandler

#    puts stdout "RTPSimpleAgent::init: addr=$addr"

    set ab [new AddressBlock $addr]
    eval $self next $ab
}

RTPSimpleAgent instproc destroy {} {
	$self next
}

RTPSimpleAgent instproc create_session {} {
    $self instvar type_
#    puts stdout "RTPSimpleAgent::create_session: called"

    switch -exact -- $type_ {
	audio {
	    set session [new Session/RTP/Audio]
	}
	video {
	    set session [new Session/RTP/Video]
	}
	default {
	    set session [new Session/RTP/Audio]
	}
    }

    return $session
}



# Override RTP agent's default method.
# Called from C++ (through Source/RTP) when we start
# actively receiving data pkts from the given source.

RTPSimpleAgent instproc activate src {
    $self instvar dataHandler_ controlHandler_

#    puts stdout "RTPSimpleAgent::activate [$src getid]"
#    puts stdout [format "%s %x" "src is $src; ssrc=0x" [$src ssrc]]
#    puts stdout "addr is [$src addr]"

    if {$dataHandler_ != ""} {
	$src data-handler $dataHandler_
    } else {
	# this works for audio too, because it just releases the packet
	$src data-handler [new Module/VideoDecoder/Null]
	# there needs to be a data handler attached, to call release on the
	#   packets, also, the source expects there to be one attached, or it
	#   will seg fault!
    }

    if {$controlHandler_ != ""} {
	$src ctrl-handler $controlHandler_
    }

    $self next $src
}

RTPSimpleAgent instproc deactivate src {
    #puts "RTPSimpleAgent deactivate"
    $self next $src
}

