# rlm-misc.tcl --
#
#       FIXME: This file needs a description here.
#
# Copyright (c) 1996-2002 The Regents of the University of California.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#
# A. Redistributions of source code must retain the above copyright notice,
#    this list of conditions and the following disclaimer.
# B. Redistributions in binary form must reproduce the above copyright notice,
#    this list of conditions and the following disclaimer in the documentation
#    and/or other materials provided with the distribution.
# C. Neither the names of the copyright holders nor the names of its
#    contributors may be used to endorse or promote products derived from this
#    software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
# AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
# IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
# ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR
# ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
# DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
# SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
# OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
# OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
# @(#) $Header: /usr/mash/src/repository/mash/mash-1/tcl/net/rlm-misc.tcl,v 1.5 2002/02/03 04:28:06 lim Exp $


#FIXME
#proc randomize v {
#	return [expr 0.5 * $v + double([ns-random] % 10000000) / 1e7 * $v]
#
#}

proc uniform01 {} {
    return [expr double(([random] % 10000000) + 1) / 1e7]
}

proc uniform { a b } {
	return [expr ($b - $a) * [uniform01] + $a]
}

proc exponential mean {
	return [expr - $mean * log([uniform01])]
}

proc trunc_exponential lambda {
	while 1 {
		set u [exponential $lambda]
		if { $u < [expr 4 * $lambda] } {
			return $u
		}
	}
}

#FIXME make this a class?
proc sched { delay proc } {
	set delay [expr int($delay * 1000)]
	return [after $delay $proc]
}

proc set_timer { which mmg delay } {
	global rlm_tid
	set v $which:$mmg
	if [info exists rlm_tid($v)] {
		puts "timer botched ($v)"
		exit -1
        }
	set rlm_tid($v) [sched $delay "trigger_timer $which $mmg"]
}

proc trigger_timer { which mmg } {
	global rlm_tid
	unset rlm_tid($which:$mmg)
	$mmg trigger_$which
}

#
# cancel s-timer on flow $mmg
# e.g., because we experienced loss
#
proc cancel_timer { which mmg } {
	global rlm_tid
	set v $which:$mmg
	if [info exists rlm_tid($v)] {
		after cancel $rlm_tid($v)
		unset rlm_tid($v)
	}
}
