/*
 * gettimes.c --
 *
 *      FIXME: This file needs a description here.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <stdio.h>
#include <sys/time.h>
#include <sys/types.h>

struct FileHeader {
        char version[16];
        char protocol[8];
        char media[32];
        char cname[128];
        char name[128];

        u_int32_t start_sec;
        u_int32_t start_usec;
        u_int32_t end_sec;
        u_int32_t end_usec;

        u_int32_t privateLen;
};

#define SKIP_BYTES 312
#define GETTIMEOFDAY_TO_NTP_OFFSET 2208988800UL

int main(int argc, char** argv)
{
  FILE* infile;
  char buf[1024];
  int start_sec;
  int start_usec;
  struct timeval val;

  struct FileHeader hdr;

  if(argc != 2)
  {
    printf("xxx <filename>");
    exit(1);
  }

  infile = fopen(argv[1], "r");

  fread(&hdr, sizeof(struct FileHeader), 1, infile);

  printf("name = %s\n", hdr.name);
  printf("start_sec = %u, start_usec = %u\n", hdr.start_sec, hdr.start_usec);
  gettimeofday(&val, NULL);

  val.tv_sec = val.tv_sec + GETTIMEOFDAY_TO_NTP_OFFSET;

  printf("now_sec = %u, now_usec = %u\n", val.tv_sec, val.tv_usec);

  fclose(infile);

  return(0);
}

