/*
 * vd-utils.cc --
 *
 *      Implementation of common utilities used in VD.  Moving sum keeps
 *      a sum of the last X items added to it.  Subtimes provides subtraction
 *      for struct timevals.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include "vd-utils.h"




MovingSum::MovingSum()
{
  int x;

  size = 20;
  runningTotal = 0;
  curIndex = 0;
  buf = new int[size];
  for(x = 0; x < size; ++x)
  {
    buf[x] = 0;
  }
}

MovingSum::MovingSum(int historySize)
{
  int x;

  size = historySize;
  runningTotal = 0;
  curIndex = 0;
  buf = new int[size];
  for(x = 0; x < size; ++x)
  {
    buf[x] = 0;
  }
}

MovingSum::~MovingSum()
{
  delete [] buf;
}

int MovingSum::getCurrentSum()
{
  return runningTotal;
}

int MovingSum::nextVal(int val)
{
  //printf("MovingSum::nextVal: val=%d, curIndex=%d, runningTotal=%d, buf[]=%d\n", val, curIndex, runningTotal, buf[curIndex]);

  runningTotal -= buf[curIndex];
  runningTotal += val;
  buf[curIndex] = val;
  curIndex = (curIndex + 1) % size;

  return runningTotal;
}

////////////////////////////////////////////////////////////////

// FIXME - won't detect if a time difference is negative
// t3 = t1 - t2
void subTimes(struct timeval* t1, struct timeval* t2, struct timeval* t3)
{
  t3->tv_usec = t1->tv_usec - t2->tv_usec;
  t3->tv_sec = t1->tv_sec - t2->tv_sec;

  while(t3->tv_usec < 0)
  {
    t3->tv_sec--;
    t3->tv_usec += 1000000;
  }
}
