/*
 * lml33.h --
 *
 *      LML33 device abstractions and ioctl definitions.
 *
 * Copyright (c) 2000-2002 The Regents of the University of California.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * A. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * B. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * C. Neither the names of the copyright holders nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS
 * IS'' AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 */

#include <linux/ioctl.h>

#define         LINVS_IOC_MAGIC        194
#define         LINVS_IOC_MAXNR        11

#ifdef __KERNEL__
#if LINUX_VERSION_CODE >= 0x020200
    #define GET_USER(v,arg) get_user(v,(int *)arg)
#else
    GET_USER(v,arg) v = get_user((int *)arg);
#endif
#endif

/* Turn on video overlay */
#define         LINVS_IOCOVERLAY       _IOW(LINVS_IOC_MAGIC, 0, int)
#define         LINVS_OVERLAY_ON       1
#define         LINVS_OVERLAY_OFF      0

/* Set the horizontal screen position of the video overlay */
#define         LINVS_IOCSXOFFSET      _IOW(LINVS_IOC_MAGIC, 1, int)

/* Set the vertical screen position of the video overlay */
#define         LINVS_IOCSYOFFSET      _IOW(LINVS_IOC_MAGIC, 2, int)

/* Query the driver bitrate - which can be set at loadtime */
#define         LINVS_IOCGBITRATE      _IOR(LINVS_IOC_MAGIC, 3, int)

/* Set the video stream */
#define         LINVS_IOCVIDEOSTREAM  _IOW(LINVS_IOC_MAGIC, 4, int)

// Set the video overlay/raw capture resolution
#define         LINVS_IOCOVERLAYRES  _IOW(LINVS_IOC_MAGIC, 5, int)

/* Query status register of BT819 */
#define         LINVS_IOCGVIDEOINSTATUS _IOR(LINVS_IOC_MAGIC, 6, int)

// Grab a raw frame into video capture RAM
#define         LINVS_IOC_BEGINGRAB     _IOW(LINVS_IOC_MAGIC, 7, int)
#define         LINVS_IOC_WAITGRABDONE  _IOW(LINVS_IOC_MAGIC, 8, int)

// Raw frame capture parameters
#define         LINVS_IOC_RSET_RESOLUTION _IOW(LINVS_IOC_MAGIC,9, int)
#define         LINVS_IOC_RSET_PIXEL_FMT _IOW(LINVS_IOC_MAGIC,10, int)
#define         LINVS_IOC_RSET_COLOR_ENC _IOW(LINVS_IOC_MAGIC,11, int)

/* Parameters and structures for jpeg compressed data */

#define MRK_SOI 0xD8FF
#define MRK_APP3 0xE3FF
#define APP_NAME "LML"

#define dword unsigned long int
#define word  unsigned short int

enum ColorEncoding_enum {
  NTSC=1,PAL=2,SECAM=3
};
typedef enum ColorEncoding_enum ColorEncoding;

enum VideoStream_enum {
  D1=1,HALF_D1=2,CIF=3,QCIF=4,
  SIF=5,QSIF=6,
  N320x240=7,P320x288=8,
  N640x480=9,P640x576=10
};
typedef enum VideoStream_enum VideoStream;


struct FrameHeader_struct {
  word mrkSOI __attribute__ ((packed));
  word mrkAPP3 __attribute__ ((packed));
  word lenAPP3 __attribute__ ((packed));
  char nm[4] __attribute__ ((packed));
  word frameNo __attribute__ ((packed));
  dword sec __attribute__ ((packed));
  dword usec __attribute__ ((packed));
  dword frameSize __attribute__ ((packed));
  dword frameSeqNo __attribute__ ((packed));
  ColorEncoding colorEncoding __attribute__ ((packed));
  VideoStream videoStream __attribute__ ((packed));
  word timeDecimation __attribute__ ((packed));
  char filler[10] __attribute__ ((packed));
};
typedef struct FrameHeader_struct FrameHeader;

#define MAX_FRAME_SIZE 262144

struct CodecFrame_struct {
  FrameHeader header;
  char data[MAX_FRAME_SIZE];
};
typedef struct CodecFrame_struct CodecFrame;

