/*
 * Copyright (c) 1997 Carnegie Mellon University. All Rights Reserved.
 *
 * Permission to use, copy, modify, and distribute this software and
 * its documentation is hereby granted (including for commercial or
 * for-profit use), provided that both the copyright notice and this
 * permission notice appear in all copies of the software, derivative
 * works, or modified versions, and any portions thereof, and that
 * both notices appear in supporting documentation, and that credit
 * is given to Carnegie Mellon University in all publications reporting
 * on direct or indirect use of this code or its derivatives.
 *
 * THIS SOFTWARE IS EXPERIMENTAL AND IS KNOWN TO HAVE BUGS, SOME OF
 * WHICH MAY HAVE SERIOUS CONSEQUENCES.  CARNEGIE MELLON PROVIDES THIS
 * SOFTWARE IN ITS ``AS IS'' CONDITION, AND ANY EXPRESS OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL CARNEGIE MELLON UNIVERSITY BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT
 * OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR
 * BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF
 * LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE
 * USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
 * DAMAGE.
 *
 * Carnegie Mellon encourages (but does not require) users of this
 * software to return any improvements or extensions that they make,
 * and to grant Carnegie Mellon the rights to redistribute these
 * changes without encumbrance.
 */

/*  
 * Revision: @(#)network.h	1.2        8/24/93     Hui Zhang   
 */
#ifndef IF_INCL
#define IF_INCL

#include <sys/types.h>
#include "consts.h"
#include "hfsc_queue.h"
#include "hfsc_list.h"
#include "hfsc_time.h"

#ifdef __cplusplus
extern "C" {
#endif

struct gateway {
    u_int gt_id;
    int   gt_numOfLink;
    u_int gt_inLink[MAX_LINK];
    u_int gt_outLink[MAX_LINK];
};

struct ifnet {
    u_char            if_busy;                 /* 1 if busy, 0 if not */
    u_char            if_workConserving;       /* 1 if work conserving */
    u_short           if_noJitterControl;      /* 1 if no jitter control */
    u_int             if_mtu;
    u_int             if_id;
    u_int             if_srcGateway, if_desGateway;
    u_long            if_linkSpeed;
    int               if_clockTick;
    Time              if_clockTickOffset;
    pkqptr            if_rtipPcbs;  
    Time              if_delayBound[MAX_LEVEL];
    u_long            if_maxBusyPeriod[MAX_LEVEL];
    void              (*if_output)();
    struct Queue     *if_queue;
    pkqptr            if_nonRealTimeQueue;
    pkqptr            if_nonEligibleQueue;
    int               if_nonRealTimeQueueLength;
    int               if_nonEligibleQueueLength;
    double            if_utilization;
/* functions and variables used for logging purpose */
    void              (*if_log)();
    FILE               *if_fp;
    void              (*if_reportStatus)();
    Time               if_endOfCurrentBusyPeriod;
};

#define if_accept    if_queue->q_accept
#define if_release   if_queue->q_release
extern u_int NumGateway;
extern u_int NumIfnet;
/*
extern struct gateway *Gateway[MAX_GATEWAY];
extern struct ifnet   *Ifnet[MAX_LINK];
 */

extern struct gateway *Gateway[];
extern struct ifnet   *Ifnet[];

#ifdef __cplusplus
}
#endif

#endif








