#!/usr/bin/env python
# Copyright (C) 2000-2001 The OpenRPG Project
#
#	openrpg-dev@lists.sourceforge.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
# --
#
# File: dieroller/utils.py
# Author: OpenRPG Team
# Maintainer:
# Version:
#   $Id: utils.py,v 1.6 2003/11/05 21:14:44 snowdog_ Exp $
#
# Description: Classes to help manage the die roller
#

__version__ = "$Id: utils.py,v 1.6 2003/11/05 21:14:44 snowdog_ Exp $"

from die import *
# add addtional rollers here
from wod import *
from d20 import *
from hero import *
from shadowrun import *
from hackmaster import *

import re

rollers = ['std','wod','d20','hero','shadowrun','hackmaster']

class roller_manager:
    def __init__(self,roller_class="std"):        
        try:
            self.set_roller(roller_class)
        except:
            self.roller_class = "std"
        
    def set_roller(self,roller_class):
        try:
            rollers.index(roller_class)
            self.roller_class = roller_class
        except:
            raise Exception, "Invalid die roller!" 

    def get_roller(self):
        return self.roller_class
            
    def get_rollers(self):
        return rollers        
        
    def stdDieToDClass(self,match):
        s = match.group(0)
        (num,sides) = s.split('d')

        if sides.strip().upper() == 'F':
            sides = '15'
        if int(num)>100 or int(sides)>10000:
            return "none"
        else:
            return "(" + num.strip() + "**"+self.roller_class+"(" + sides.strip() + "))"

    #  Use this to convert ndm-style (3d6) dice to d_base format
    def convertTheDieString(self,s):
       reg = re.compile("\d+\s*[a-zA-Z]+\s*[\dFf]+")
       (result,num_matches) = re.subn(reg,self.stdDieToDClass,s)
       return result


    def resolveDieStr(self,s):      
       return str(eval(self.convertTheDieString(s)))

    
    
    
    
