/*
 * PIMPPA: Bowser - Statistics
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <sys/stat.h>
#include <time.h>
#include <unistd.h>
#include "proto.h"
#include "../src/pimppa.h"

struct p_stats
{
	int total_files;
	int total_megs;
	int online_files;
	int online_megs;
	int offline_files;
	int offline_megs;
	int assign_patterns;
	int file_areas;
	time_t stats_date;
};

struct p_stats CurrentStats;

static void
update_stats(GnomeDialog *dlg, int button, gpointer data)
{
	char buffer[QUERY_MAX];
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;

	switch(button) {
		case 0:
			break;
		case 1:
			gnome_dialog_close(dlg);
			return;
			break;
	}

	gnome_dialog_close(dlg);

	gnome_appbar_set_status (GNOME_APPBAR(statusBar), "Updating stats...");
	while (gtk_events_pending())
		gtk_main_iteration();

/******** All ******************/

	p_query(db, "SELECT count(*), (sum(file_size)/(1024*1024)) FROM p_files");
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if((sql_row=mysql_fetch_row(sql_result)))
		{
			CurrentStats.total_files=atoi(sql_row[0]);
			CurrentStats.total_megs=atoi(sql_row[1]);
		}
		mysql_free_result(sql_result);
	}
	
	gnome_appbar_set_progress(GNOME_APPBAR(statusBar), (float)0.2);
	while (gtk_events_pending())
		gtk_main_iteration();

/********** Online *************/

	p_query(db, "SELECT count(*), (sum(file_size)/(1024*1024)) " 
		    "FROM p_files "
		    "WHERE file_area>0 AND NOT (file_flags & %ld)",
		FILE_OFFLINE);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if((sql_row=mysql_fetch_row(sql_result)))
		{
			CurrentStats.online_files=atoi(sql_row[0]);
			CurrentStats.online_megs=atoi(sql_row[1]);
		}
		mysql_free_result(sql_result);
	}

	gnome_appbar_set_progress(GNOME_APPBAR(statusBar), (float)0.4);
	while (gtk_events_pending())
		gtk_main_iteration();

/********** Offline *************/

	p_query(db, "SELECT count(*), (sum(file_size)/(1024*1024)) " 
		    "FROM p_files "
		    "WHERE file_area>0 AND (file_flags & %ld)",
 	        FILE_OFFLINE);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if((sql_row=mysql_fetch_row(sql_result)))
		{
			CurrentStats.offline_files=atoi(sql_row[0]);
			CurrentStats.offline_megs=atoi(sql_row[1]);
		}
		mysql_free_result(sql_result);
	}

	gnome_appbar_set_progress(GNOME_APPBAR(statusBar), (float)0.6);
	while (gtk_events_pending())
		gtk_main_iteration();

/************ assign patterns ***************/
	
	p_query(db, "SELECT count(*) "
		    "FROM p_assign");
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if((sql_row=mysql_fetch_row(sql_result)))
		{
			CurrentStats.assign_patterns=atoi(sql_row[0]);
		}
		mysql_free_result(sql_result);
	}

	gnome_appbar_set_progress(GNOME_APPBAR(statusBar), (float)0.8);
	while (gtk_events_pending())
		gtk_main_iteration();

/************ fileareas ***************/
	
	p_query(db, "SELECT count(*) "
		    "FROM p_areas");
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if((sql_row=mysql_fetch_row(sql_result)))
		{
			CurrentStats.file_areas=atoi(sql_row[0]);
		}
		mysql_free_result(sql_result);
	}

	CurrentStats.stats_date=time(NULL);

	mysql_escape_string(buffer, (char *)&CurrentStats, sizeof(CurrentStats));

	p_query(db, "REPLACE INTO p_misc (misc_key,misc_data) "
		    "VALUES ('%s', '%s')",
		P_KEY_STATS, buffer);
	
	gnome_appbar_set_progress(GNOME_APPBAR(statusBar), (float)0);
	while (gtk_events_pending())
		gtk_main_iteration();
	
	gnome_appbar_set_status (GNOME_APPBAR(statusBar), "");

	show_stats();

	return;
}

void show_stats(void)
{
	char buffer[QUERY_MAX];
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	GtkWidget *label;
	GtkWidget *dlg;

	memset(&CurrentStats, 0, sizeof(CurrentStats));
	
	dlg=gnome_dialog_new("PIMPPA statistics",
						"Update (slow)",
						GNOME_STOCK_BUTTON_CLOSE,
						NULL);
	gnome_dialog_set_parent(GNOME_DIALOG(dlg), GTK_WINDOW(Bowser));

    gtk_signal_connect(GTK_OBJECT(dlg),"clicked",
                    GTK_SIGNAL_FUNC(update_stats),
                    NULL);

/***** Get stored stats here ********/

	p_query(db, "SELECT misc_data FROM p_misc "
		    "WHERE misc_key='%s'", 
		P_KEY_STATS);
	sql_result=mysql_store_result(db);
	if(sql_result)
	{
		if((sql_row=mysql_fetch_row(sql_result)))
		{
			memcpy(&CurrentStats, sql_row[0], sizeof(CurrentStats));
		}
		mysql_free_result(sql_result);
	}

/**** Show stats *************/

	sprintf(buffer, "Stats for %s", ctime(&CurrentStats.stats_date));
	label = gtk_label_new(buffer);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);

	sprintf(buffer, "Files passed: %7d   Megs passed: %7dM",
					CurrentStats.total_files, CurrentStats.total_megs);
	label = gtk_label_new(buffer);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),label,TRUE,TRUE, 0);
	gtk_widget_show(label);

	sprintf(buffer, "Files online: %7d   Megs online: %7dM",
					CurrentStats.online_files, CurrentStats.online_megs);
	label = gtk_label_new(buffer);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);
	
	sprintf(buffer, "Files offline: %7d   Megs offline: %7dM",
					CurrentStats.offline_files, CurrentStats.offline_megs);
	label = gtk_label_new(buffer);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);
	
	sprintf(buffer, "Fileareas: %3d   Assign patterns: %6d",
					CurrentStats.file_areas, CurrentStats.assign_patterns);
	label = gtk_label_new(buffer);
	gtk_box_pack_start(GTK_BOX(GNOME_DIALOG(dlg)->vbox),label,TRUE,TRUE,0);
	gtk_widget_show(label);

	gtk_widget_show(dlg);

	return;
}


