CREATE DATABASE pimppa;

# MySQL dump 6.0
#
# Host: localhost    Database: pimppa
#--------------------------------------------------------
# Server version	3.22.25

USE pimppa;

#
# Table structure for table 'p_areas'
#
CREATE TABLE p_areas (
  area_id smallint(5) DEFAULT '0' NOT NULL auto_increment,
  area_name varchar(50) DEFAULT '' NOT NULL,
  area_path varchar(255) DEFAULT '' NOT NULL,
  area_flags tinyint(3) unsigned DEFAULT '0' NOT NULL,
  area_context tinyint DEFAULT '0' NOT NULL,
  area_targets text NOT NULL,
  PRIMARY KEY (area_id),
  UNIQUE unique_area_name (area_name)
);

#
# Table structure for table 'p_contexts'
#
CREATE TABLE p_contexts (
  c_name varchar(50) DEFAULT '' NOT NULL,
  c_id smallint(5) DEFAULT '0' NOT NULL,
  c_desc varchar(255) DEFAULT '' NOT NULL,
  PRIMARY KEY(c_id),
  UNIQUE unique_c_name (c_name)
);

#
# Table structure for table 'p_assign'
#
CREATE TABLE p_assign (
  a_pattern varchar(50) DEFAULT '' NOT NULL,
  a_context tinyint DEFAULT '0' NOT NULL,
  a_dest smallint(5) DEFAULT '0' NOT NULL,
  PRIMARY KEY (a_pattern,a_context)
);

#
# Table structure for table 'p_files'
#
CREATE TABLE p_files (
  file_id int(10) unsigned DEFAULT '0' NOT NULL auto_increment,
  file_name varchar(128) DEFAULT '' NOT NULL,
  file_size int(10) unsigned DEFAULT '0' NOT NULL,
  file_area smallint(5) DEFAULT '0' NOT NULL,
  file_integ tinyint(4) DEFAULT '0' NOT NULL,
  file_trans tinyint(4) DEFAULT '0' NOT NULL,
  file_date datetime DEFAULT '0000-00-00 00:00:00' NOT NULL,
  file_backup tinyint(4) unsigned DEFAULT '0' NOT NULL,
  file_desc text NOT NULL,
  file_flags tinyint(4) unsigned DEFAULT '0' NOT NULL,
  file_md5sum char(16) BINARY DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0' NOT NULL,
  PRIMARY KEY (file_id),
  KEY index_file_name (file_name),
  KEY index_file_area (file_area),
  KEY index_file_date (file_date),
  KEY index_file_md5sum (file_md5sum),
  UNIQUE unique_file (file_name,file_area)
);

#
# Table structure for table 'p_groups'
#
CREATE TABLE p_groups (
  g_name varchar(128) DEFAULT '' NOT NULL,
  g_server smallint(5) DEFAULT '1' NOT NULL,
  g_last int(10) DEFAULT '0' NOT NULL,
  g_flags mediumint(9) DEFAULT '0' NOT NULL,
  g_dest smallint(5) DEFAULT '0' NOT NULL,
  PRIMARY KEY (g_name,g_server)
);

#
# Table structure for table 'p_rules'
#
CREATE TABLE p_rules (
  r_rule varchar(255) DEFAULT '' NOT NULL, 
  r_context tinyint DEFAULT '0' NOT NULL, 
  r_target smallint DEFAULT '0' NOT NULL, 
  r_type tinyint DEFAULT '0' NOT NULL, 
  PRIMARY KEY (r_rule, r_context), 
  KEY index_r_context (r_context)
);
				

#
# Table structure for table 'p_servers'
#
CREATE TABLE p_servers (
  s_id smallint(5) unsigned DEFAULT '0' NOT NULL auto_increment,
  s_name varchar(255) DEFAULT '' NOT NULL,
  s_user varchar(255) DEFAULT '' NOT NULL,
  s_pass varchar(255) DEFAULT '' NOT NULL,
  s_flags int(10) DEFAULT '0' NOT NULL,
  PRIMARY KEY (s_id),
  UNIQUE unique_server (s_name)
);

#
# Table structure for table 'p_misc'
#
CREATE TABLE p_misc (
  misc_key varchar(32) DEFAULT '' NOT NULL,
  misc_data text NOT NULL,
  PRIMARY KEY (misc_key)
);

#
# Table structure for table 'p_types'
#
CREATE TABLE p_types (
  type_ext varchar(8) DEFAULT '' NOT NULL,
  type_testcmd varchar(255) DEFAULT '' NOT NULL,
  type_testpos tinyint(4) DEFAULT '0' NOT NULL,
  type_testokstr varchar(32) DEFAULT '' NOT NULL,
  type_transcmd varchar(255) DEFAULT '' NOT NULL,
  type_transto varchar(8) DEFAULT '' NOT NULL,
  PRIMARY KEY (type_ext)
);

# 
# Create the default "trashcan" area
#
INSERT INTO p_areas (area_id, area_name, area_path,area_targets) VALUES (-1,'0DOOM','/dev/null', 'End of the Line');

#
# Add bogus newsserver
#
INSERT INTO p_servers (s_name) VALUES ('nntp.changethis.com');

#
# Add default context
#
INSERT INTO p_contexts (c_name,c_id,c_desc) VALUES ('all', 0, 'Global context');

#
# Add the user and priviledges
#
USE mysql;

INSERT INTO user (Host, User, password)
				VALUES ("localhost", "pimppa", PASSWORD('change_this'));
INSERT INTO db (Host, Db,User,Select_priv, Insert_priv,
				Update_priv,Delete_priv,Create_priv) VALUES
				("localhost", "pimppa", "pimppa", 'Y','Y',
				'Y','Y','Y');

FLUSH PRIVILEGES;


