# --------------------------------------------------------------------------- #
# $Id: eps.py,v 1.16 2004/01/04 17:31:01 weismann Exp $
# --------------------------------------------------------------------------- #
#
# Encapsulated Postscript
#
# This file contains a bunch of hacks that demonstrate how you can try
# to integrate support for your favorite tool into pointless. There is NOT 
# much error checking at the moment. The aim was merely to demonstrate how to
# integrate support for external tools.
#
# The integration of a given tool <foo> can be split into four sections, the
# register_foo section, the write_foo section, the run_foo section and
# the _foo section. The register_foo is used to registre the command
# into the PLL language. The _foo function is the one that will be
# called as part of the parsing of the pll-input whenever a =foo (or a
# =begin-foo ... =end-foo section is detected. Finally, the write_foo 
# and run_foo functions are auxilary functions for the _foo function. 
# The write_foo is used to modify the input with additinon commands
# required for the run and the run_foo is finally used to run the
# external foo application.
#

from pllshared import *
import os
import re
import pllmodules 

pll = None

def register():
	pll.add_command("eps:sf", _eps, empty = 1)

def run_ps2epsi(filename, outfile):
	ps2epsi = pllmodules.find_program("ps2epsi")
	errormsg = ""
	if ps2epsi:
		failed = os.system("%s %s %s" % (ps2epsi, filename, outfile))
	else:
		errormsg = "Unable to find the ps2epsi program"
		failed = 1
	return not failed, errormsg

def run_convert_ps2eps(filename):
	convert = pllmodules.find_program("convert")
	errormsg = ""
	if convert:
		psfile = filename+".ps"
		epsfile = filename+".eps"
		failed = os.system("%s %s %s" (convert, psfile, epsfile))
	else:
		errormsg = "Unable to find the convert program"
		failed=1
	return not failed, errormsg

def run_eps2eps(epsin, epsout):
	eps2eps = pllmodules.find_program("eps2eps")
	errormsg = ""
	if eps2eps:
		failed = os.system("%s %s %s" % (eps2eps, epsin, epsout))
	else:
		errormsg = "Unable to find the eps2eps program"
		failed=1
	return not failed, errormsg

def eps2png(epsfile, pngfile, scale):
	f = open(epsfile)
	fl = f.readlines()
	f.close()
	bounds = None
	for l in fl:
		r = re.match('^%%BoundingBox:\s*(\S+)\s+(\S+)\s+(\S+)\s+(\S+)', l)
		if r:
			bounds = [int(r.group(1)), int(r.group(2)),
			          int(r.group(3)), int(r.group(4))]
			break
	if not bounds:
		return 0, ("No bounding box in eps file '%s'"%epsfile)
	ps_width  = (bounds[2] - bounds[0])
	ps_height = (bounds[3] - bounds[1])
	px_width  = ps_width*scale
	px_height = ps_height*scale
	gscommands  = "%f %f scale\n" % (scale, scale)
	gscommands += "%i %i translate\n" % (-bounds[0], -bounds[1])
	gscommands += "(%s) run\n" % epsfile
	gscommands += "showpage\n"
	gscommands += "quit\n"
	px_size = "%ix%i"%(px_width,px_height)

	gs = pllmodules.find_program("gs")
	if not gs:
		return 0, ("Unable to find the gs program")
	gs_cmdline = "%s -q -dNOPAUSE -r72 -g%s -dTextAlphaBits=4 -dGraphicsAlphaBits=4 -sDEVICE=pnggray -sOutputFile=%s -" % (gs, px_size, pngfile)
	p = os.popen(gs_cmdline, 'w')
	p.write(gscommands)
	p.close()
	return 1, ""

def _eps(args, parser):
	name, scale = args
	epsfile = pll.find_file(name)
	if not epsfile:
		raise PllCommandError("Unable to open '%s'"%name)
	pngfile = pll.get_cachefilename(epsfile)+".png"
	ok, error = eps2png(epsfile, pngfile, scale*pll.scale)
	if not ok:
		raise PllCommandError("Unable to convert '%s'\n%s'" % (name,error))
	return [
		pll.vertical_glue(0),
		pll.gaimage(pngfile, center=0)
	]

# --------------------------------------------------------------------------- #

